/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.RoutingPolicyRule;
import com.nutanix.dp1.net.networking.v4.config.VpcName;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingPolicy
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(RoutingPolicy.class);
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @Max(value=1000L)
    @Min(value=1L)
    @JsonProperty(value="priority")
    public @Max(value=1000L) @Min(value=1L) Integer priority = null;
    @Size(min=1, max=1)
    @JsonProperty(value="policies")
    public @Size(min=1, max=1) List<RoutingPolicyRule> policies = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vpcExtId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vpcExtId = null;
    @JsonProperty(value="vpc")
    public VpcName vpc = null;

    public RoutingPolicy() {
    }

    public RoutingPolicy(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, Integer priority, List<RoutingPolicyRule> policies, String vpcExtId, VpcName vpc) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setPriority(priority);
        this.setPolicies(policies);
        this.setVpcExtId(vpcExtId);
        this.setVpc(vpc);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.RoutingPolicy";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static RoutingPolicyBuilder RoutingPolicyBuilder() {
        return new RoutingPolicyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoutingPolicy)) {
            return false;
        }
        RoutingPolicy other = (RoutingPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        List<RoutingPolicyRule> this$policies = this.getPolicies();
        List<RoutingPolicyRule> other$policies = other.getPolicies();
        if (this$policies == null ? other$policies != null : !((Object)this$policies).equals(other$policies)) {
            return false;
        }
        String this$vpcExtId = this.getVpcExtId();
        String other$vpcExtId = other.getVpcExtId();
        if (this$vpcExtId == null ? other$vpcExtId != null : !this$vpcExtId.equals(other$vpcExtId)) {
            return false;
        }
        VpcName this$vpc = this.getVpc();
        VpcName other$vpc = other.getVpc();
        return !(this$vpc == null ? other$vpc != null : !((Object)this$vpc).equals(other$vpc));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RoutingPolicy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        List<RoutingPolicyRule> $policies = this.getPolicies();
        result = result * 59 + ($policies == null ? 43 : ((Object)$policies).hashCode());
        String $vpcExtId = this.getVpcExtId();
        result = result * 59 + ($vpcExtId == null ? 43 : $vpcExtId.hashCode());
        VpcName $vpc = this.getVpc();
        result = result * 59 + ($vpc == null ? 43 : ((Object)$vpc).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public List<RoutingPolicyRule> getPolicies() {
        return this.policies;
    }

    public String getVpcExtId() {
        return this.vpcExtId;
    }

    public VpcName getVpc() {
        return this.vpc;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="priority")
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @JsonProperty(value="policies")
    public void setPolicies(List<RoutingPolicyRule> policies) {
        this.policies = policies;
    }

    @JsonProperty(value="vpcExtId")
    public void setVpcExtId(String vpcExtId) {
        this.vpcExtId = vpcExtId;
    }

    @JsonProperty(value="vpc")
    public void setVpc(VpcName vpc) {
        this.vpc = vpc;
    }

    @Override
    public String toString() {
        return "RoutingPolicy(name=" + this.getName() + ", description=" + this.getDescription() + ", priority=" + this.getPriority() + ", policies=" + this.getPolicies() + ", vpcExtId=" + this.getVpcExtId() + ", vpc=" + this.getVpc() + ")";
    }

    public static class RoutingPolicyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private Integer priority;
        private List<RoutingPolicyRule> policies;
        private String vpcExtId;
        private VpcName vpc;

        RoutingPolicyBuilder() {
        }

        public RoutingPolicyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RoutingPolicyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RoutingPolicyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RoutingPolicyBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public RoutingPolicyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RoutingPolicyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public RoutingPolicyBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public RoutingPolicyBuilder policies(List<RoutingPolicyRule> policies) {
            this.policies = policies;
            return this;
        }

        public RoutingPolicyBuilder vpcExtId(String vpcExtId) {
            this.vpcExtId = vpcExtId;
            return this;
        }

        public RoutingPolicyBuilder vpc(VpcName vpc) {
            this.vpc = vpc;
            return this;
        }

        public RoutingPolicy build() {
            return new RoutingPolicy(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.priority, this.policies, this.vpcExtId, this.vpc);
        }

        public String toString() {
            return "RoutingPolicy.RoutingPolicyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", priority=" + this.priority + ", policies=" + this.policies + ", vpcExtId=" + this.vpcExtId + ", vpc=" + this.vpc + ")";
        }
    }
}

