/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.DhcpOptions;
import com.nutanix.dp1.net.networking.v4.config.IPConfig;
import com.nutanix.dp1.net.networking.v4.config.IPUsage;
import com.nutanix.dp1.net.networking.v4.config.MigrationState;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.SubnetType;
import com.nutanix.dp1.net.networking.v4.config.VirtualSwitch;
import com.nutanix.dp1.net.networking.v4.config.Vpc;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subnet
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Subnet.class);
    @Size(min=0, max=255)
    private @Size(min=0, max=255) List<IPAddress> reservedIpAddresses = null;
    @Size(min=0, max=255)
    private @Size(min=0, max=255) List<IPAddress> dynamicIpAddresses = null;
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(value="subnetType")
    public SubnetType subnetType = null;
    @Max(value=0xFFFFFFL)
    @Min(value=0L)
    @JsonProperty(value="networkId")
    public @Max(value=0xFFFFFFL) @Min(value=0L) Integer networkId = null;
    @JsonProperty(value="dhcpOptions")
    public DhcpOptions dhcpOptions = null;
    @Size(min=0, max=1)
    @JsonProperty(value="ipConfig")
    public @Size(min=0, max=1) List<IPConfig> ipConfig = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="virtualSwitchReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String virtualSwitchReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vpcReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vpcReference = null;
    @JsonProperty(value="isNatEnabled")
    public Boolean isNatEnabled = null;
    @JsonProperty(value="isExternal")
    public Boolean isExternal = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="networkFunctionChainReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String networkFunctionChainReference = null;
    @Size(max=128)
    @JsonProperty(value="bridgeName")
    public @Size(max=128) String bridgeName = null;
    @JsonProperty(value="isAdvancedNetworking")
    public Boolean isAdvancedNetworking = null;
    @Size(max=128)
    @JsonProperty(value="clusterName")
    public @Size(max=128) String clusterName = null;
    @JsonProperty(value="hypervisorType")
    public String hypervisorType = null;
    @JsonProperty(value="virtualSwitch")
    public VirtualSwitch virtualSwitch = null;
    @JsonProperty(value="vpc")
    public Vpc vpc = null;
    @JsonProperty(value="ipPrefix")
    public String ipPrefix = null;
    @JsonProperty(value="ipUsage")
    public IPUsage ipUsage = null;
    @JsonProperty(value="migrationState")
    public MigrationState migrationState = null;

    public Subnet() {
    }

    public Subnet(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, SubnetType subnetType, Integer networkId, DhcpOptions dhcpOptions, List<IPConfig> ipConfig, String clusterReference, String virtualSwitchReference, String vpcReference, Boolean isNatEnabled, Boolean isExternal, List<IPAddress> reservedIpAddresses, List<IPAddress> dynamicIpAddresses, String networkFunctionChainReference, String bridgeName, Boolean isAdvancedNetworking, String clusterName, String hypervisorType, VirtualSwitch virtualSwitch, Vpc vpc, String ipPrefix, IPUsage ipUsage, MigrationState migrationState) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setSubnetType(subnetType);
        this.setNetworkId(networkId);
        this.setDhcpOptions(dhcpOptions);
        this.setIpConfig(ipConfig);
        this.setClusterReference(clusterReference);
        this.setVirtualSwitchReference(virtualSwitchReference);
        this.setVpcReference(vpcReference);
        this.setIsNatEnabled(isNatEnabled);
        this.setIsExternal(isExternal);
        this.setReservedIpAddresses(reservedIpAddresses);
        this.setDynamicIpAddresses(dynamicIpAddresses);
        this.setNetworkFunctionChainReference(networkFunctionChainReference);
        this.setBridgeName(bridgeName);
        this.setIsAdvancedNetworking(isAdvancedNetworking);
        this.setClusterName(clusterName);
        this.setHypervisorType(hypervisorType);
        this.setVirtualSwitch(virtualSwitch);
        this.setVpc(vpc);
        this.setIpPrefix(ipPrefix);
        this.setIpUsage(ipUsage);
        this.setMigrationState(migrationState);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.Subnet";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setReservedIpAddresses(List<IPAddress> reservedIpAddresses) {
        if (this.reservedIpAddresses == null) {
            this.reservedIpAddresses = reservedIpAddresses;
        } else {
            log.warn("Read-only property reservedIpAddresses already contains a non-null value and cannot be set again");
        }
    }

    public void setDynamicIpAddresses(List<IPAddress> dynamicIpAddresses) {
        if (this.dynamicIpAddresses == null) {
            this.dynamicIpAddresses = dynamicIpAddresses;
        } else {
            log.warn("Read-only property dynamicIpAddresses already contains a non-null value and cannot be set again");
        }
    }

    public static SubnetBuilder SubnetBuilder() {
        return new SubnetBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<IPAddress> this$reservedIpAddresses = this.getReservedIpAddresses();
        List<IPAddress> other$reservedIpAddresses = other.getReservedIpAddresses();
        if (this$reservedIpAddresses == null ? other$reservedIpAddresses != null : !((Object)this$reservedIpAddresses).equals(other$reservedIpAddresses)) {
            return false;
        }
        List<IPAddress> this$dynamicIpAddresses = this.getDynamicIpAddresses();
        List<IPAddress> other$dynamicIpAddresses = other.getDynamicIpAddresses();
        if (this$dynamicIpAddresses == null ? other$dynamicIpAddresses != null : !((Object)this$dynamicIpAddresses).equals(other$dynamicIpAddresses)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        SubnetType this$subnetType = this.getSubnetType();
        SubnetType other$subnetType = other.getSubnetType();
        if (this$subnetType == null ? other$subnetType != null : !((Object)((Object)this$subnetType)).equals((Object)other$subnetType)) {
            return false;
        }
        Integer this$networkId = this.getNetworkId();
        Integer other$networkId = other.getNetworkId();
        if (this$networkId == null ? other$networkId != null : !((Object)this$networkId).equals(other$networkId)) {
            return false;
        }
        DhcpOptions this$dhcpOptions = this.getDhcpOptions();
        DhcpOptions other$dhcpOptions = other.getDhcpOptions();
        if (this$dhcpOptions == null ? other$dhcpOptions != null : !((Object)this$dhcpOptions).equals(other$dhcpOptions)) {
            return false;
        }
        List<IPConfig> this$ipConfig = this.getIpConfig();
        List<IPConfig> other$ipConfig = other.getIpConfig();
        if (this$ipConfig == null ? other$ipConfig != null : !((Object)this$ipConfig).equals(other$ipConfig)) {
            return false;
        }
        String this$clusterReference = this.getClusterReference();
        String other$clusterReference = other.getClusterReference();
        if (this$clusterReference == null ? other$clusterReference != null : !this$clusterReference.equals(other$clusterReference)) {
            return false;
        }
        String this$virtualSwitchReference = this.getVirtualSwitchReference();
        String other$virtualSwitchReference = other.getVirtualSwitchReference();
        if (this$virtualSwitchReference == null ? other$virtualSwitchReference != null : !this$virtualSwitchReference.equals(other$virtualSwitchReference)) {
            return false;
        }
        String this$vpcReference = this.getVpcReference();
        String other$vpcReference = other.getVpcReference();
        if (this$vpcReference == null ? other$vpcReference != null : !this$vpcReference.equals(other$vpcReference)) {
            return false;
        }
        Boolean this$isNatEnabled = this.getIsNatEnabled();
        Boolean other$isNatEnabled = other.getIsNatEnabled();
        if (this$isNatEnabled == null ? other$isNatEnabled != null : !((Object)this$isNatEnabled).equals(other$isNatEnabled)) {
            return false;
        }
        Boolean this$isExternal = this.getIsExternal();
        Boolean other$isExternal = other.getIsExternal();
        if (this$isExternal == null ? other$isExternal != null : !((Object)this$isExternal).equals(other$isExternal)) {
            return false;
        }
        String this$networkFunctionChainReference = this.getNetworkFunctionChainReference();
        String other$networkFunctionChainReference = other.getNetworkFunctionChainReference();
        if (this$networkFunctionChainReference == null ? other$networkFunctionChainReference != null : !this$networkFunctionChainReference.equals(other$networkFunctionChainReference)) {
            return false;
        }
        String this$bridgeName = this.getBridgeName();
        String other$bridgeName = other.getBridgeName();
        if (this$bridgeName == null ? other$bridgeName != null : !this$bridgeName.equals(other$bridgeName)) {
            return false;
        }
        Boolean this$isAdvancedNetworking = this.getIsAdvancedNetworking();
        Boolean other$isAdvancedNetworking = other.getIsAdvancedNetworking();
        if (this$isAdvancedNetworking == null ? other$isAdvancedNetworking != null : !((Object)this$isAdvancedNetworking).equals(other$isAdvancedNetworking)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$hypervisorType = this.getHypervisorType();
        String other$hypervisorType = other.getHypervisorType();
        if (this$hypervisorType == null ? other$hypervisorType != null : !this$hypervisorType.equals(other$hypervisorType)) {
            return false;
        }
        VirtualSwitch this$virtualSwitch = this.getVirtualSwitch();
        VirtualSwitch other$virtualSwitch = other.getVirtualSwitch();
        if (this$virtualSwitch == null ? other$virtualSwitch != null : !((Object)this$virtualSwitch).equals(other$virtualSwitch)) {
            return false;
        }
        Vpc this$vpc = this.getVpc();
        Vpc other$vpc = other.getVpc();
        if (this$vpc == null ? other$vpc != null : !((Object)this$vpc).equals(other$vpc)) {
            return false;
        }
        String this$ipPrefix = this.getIpPrefix();
        String other$ipPrefix = other.getIpPrefix();
        if (this$ipPrefix == null ? other$ipPrefix != null : !this$ipPrefix.equals(other$ipPrefix)) {
            return false;
        }
        IPUsage this$ipUsage = this.getIpUsage();
        IPUsage other$ipUsage = other.getIpUsage();
        if (this$ipUsage == null ? other$ipUsage != null : !((Object)this$ipUsage).equals(other$ipUsage)) {
            return false;
        }
        MigrationState this$migrationState = this.getMigrationState();
        MigrationState other$migrationState = other.getMigrationState();
        return !(this$migrationState == null ? other$migrationState != null : !((Object)((Object)this$migrationState)).equals((Object)other$migrationState));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Subnet;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<IPAddress> $reservedIpAddresses = this.getReservedIpAddresses();
        result = result * 59 + ($reservedIpAddresses == null ? 43 : ((Object)$reservedIpAddresses).hashCode());
        List<IPAddress> $dynamicIpAddresses = this.getDynamicIpAddresses();
        result = result * 59 + ($dynamicIpAddresses == null ? 43 : ((Object)$dynamicIpAddresses).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        SubnetType $subnetType = this.getSubnetType();
        result = result * 59 + ($subnetType == null ? 43 : ((Object)((Object)$subnetType)).hashCode());
        Integer $networkId = this.getNetworkId();
        result = result * 59 + ($networkId == null ? 43 : ((Object)$networkId).hashCode());
        DhcpOptions $dhcpOptions = this.getDhcpOptions();
        result = result * 59 + ($dhcpOptions == null ? 43 : ((Object)$dhcpOptions).hashCode());
        List<IPConfig> $ipConfig = this.getIpConfig();
        result = result * 59 + ($ipConfig == null ? 43 : ((Object)$ipConfig).hashCode());
        String $clusterReference = this.getClusterReference();
        result = result * 59 + ($clusterReference == null ? 43 : $clusterReference.hashCode());
        String $virtualSwitchReference = this.getVirtualSwitchReference();
        result = result * 59 + ($virtualSwitchReference == null ? 43 : $virtualSwitchReference.hashCode());
        String $vpcReference = this.getVpcReference();
        result = result * 59 + ($vpcReference == null ? 43 : $vpcReference.hashCode());
        Boolean $isNatEnabled = this.getIsNatEnabled();
        result = result * 59 + ($isNatEnabled == null ? 43 : ((Object)$isNatEnabled).hashCode());
        Boolean $isExternal = this.getIsExternal();
        result = result * 59 + ($isExternal == null ? 43 : ((Object)$isExternal).hashCode());
        String $networkFunctionChainReference = this.getNetworkFunctionChainReference();
        result = result * 59 + ($networkFunctionChainReference == null ? 43 : $networkFunctionChainReference.hashCode());
        String $bridgeName = this.getBridgeName();
        result = result * 59 + ($bridgeName == null ? 43 : $bridgeName.hashCode());
        Boolean $isAdvancedNetworking = this.getIsAdvancedNetworking();
        result = result * 59 + ($isAdvancedNetworking == null ? 43 : ((Object)$isAdvancedNetworking).hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $hypervisorType = this.getHypervisorType();
        result = result * 59 + ($hypervisorType == null ? 43 : $hypervisorType.hashCode());
        VirtualSwitch $virtualSwitch = this.getVirtualSwitch();
        result = result * 59 + ($virtualSwitch == null ? 43 : ((Object)$virtualSwitch).hashCode());
        Vpc $vpc = this.getVpc();
        result = result * 59 + ($vpc == null ? 43 : ((Object)$vpc).hashCode());
        String $ipPrefix = this.getIpPrefix();
        result = result * 59 + ($ipPrefix == null ? 43 : $ipPrefix.hashCode());
        IPUsage $ipUsage = this.getIpUsage();
        result = result * 59 + ($ipUsage == null ? 43 : ((Object)$ipUsage).hashCode());
        MigrationState $migrationState = this.getMigrationState();
        result = result * 59 + ($migrationState == null ? 43 : ((Object)((Object)$migrationState)).hashCode());
        return result;
    }

    public List<IPAddress> getReservedIpAddresses() {
        return this.reservedIpAddresses;
    }

    public List<IPAddress> getDynamicIpAddresses() {
        return this.dynamicIpAddresses;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SubnetType getSubnetType() {
        return this.subnetType;
    }

    public Integer getNetworkId() {
        return this.networkId;
    }

    public DhcpOptions getDhcpOptions() {
        return this.dhcpOptions;
    }

    public List<IPConfig> getIpConfig() {
        return this.ipConfig;
    }

    public String getClusterReference() {
        return this.clusterReference;
    }

    public String getVirtualSwitchReference() {
        return this.virtualSwitchReference;
    }

    public String getVpcReference() {
        return this.vpcReference;
    }

    public Boolean getIsNatEnabled() {
        return this.isNatEnabled;
    }

    public Boolean getIsExternal() {
        return this.isExternal;
    }

    public String getNetworkFunctionChainReference() {
        return this.networkFunctionChainReference;
    }

    public String getBridgeName() {
        return this.bridgeName;
    }

    public Boolean getIsAdvancedNetworking() {
        return this.isAdvancedNetworking;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getHypervisorType() {
        return this.hypervisorType;
    }

    public VirtualSwitch getVirtualSwitch() {
        return this.virtualSwitch;
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    public String getIpPrefix() {
        return this.ipPrefix;
    }

    public IPUsage getIpUsage() {
        return this.ipUsage;
    }

    public MigrationState getMigrationState() {
        return this.migrationState;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="subnetType")
    public void setSubnetType(SubnetType subnetType) {
        this.subnetType = subnetType;
    }

    @JsonProperty(value="networkId")
    public void setNetworkId(Integer networkId) {
        this.networkId = networkId;
    }

    @JsonProperty(value="dhcpOptions")
    public void setDhcpOptions(DhcpOptions dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
    }

    @JsonProperty(value="ipConfig")
    public void setIpConfig(List<IPConfig> ipConfig) {
        this.ipConfig = ipConfig;
    }

    @JsonProperty(value="clusterReference")
    public void setClusterReference(String clusterReference) {
        this.clusterReference = clusterReference;
    }

    @JsonProperty(value="virtualSwitchReference")
    public void setVirtualSwitchReference(String virtualSwitchReference) {
        this.virtualSwitchReference = virtualSwitchReference;
    }

    @JsonProperty(value="vpcReference")
    public void setVpcReference(String vpcReference) {
        this.vpcReference = vpcReference;
    }

    @JsonProperty(value="isNatEnabled")
    public void setIsNatEnabled(Boolean isNatEnabled) {
        this.isNatEnabled = isNatEnabled;
    }

    @JsonProperty(value="isExternal")
    public void setIsExternal(Boolean isExternal) {
        this.isExternal = isExternal;
    }

    @JsonProperty(value="networkFunctionChainReference")
    public void setNetworkFunctionChainReference(String networkFunctionChainReference) {
        this.networkFunctionChainReference = networkFunctionChainReference;
    }

    @JsonProperty(value="bridgeName")
    public void setBridgeName(String bridgeName) {
        this.bridgeName = bridgeName;
    }

    @JsonProperty(value="isAdvancedNetworking")
    public void setIsAdvancedNetworking(Boolean isAdvancedNetworking) {
        this.isAdvancedNetworking = isAdvancedNetworking;
    }

    @JsonProperty(value="clusterName")
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @JsonProperty(value="hypervisorType")
    public void setHypervisorType(String hypervisorType) {
        this.hypervisorType = hypervisorType;
    }

    @JsonProperty(value="virtualSwitch")
    public void setVirtualSwitch(VirtualSwitch virtualSwitch) {
        this.virtualSwitch = virtualSwitch;
    }

    @JsonProperty(value="vpc")
    public void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    @JsonProperty(value="ipPrefix")
    public void setIpPrefix(String ipPrefix) {
        this.ipPrefix = ipPrefix;
    }

    @JsonProperty(value="ipUsage")
    public void setIpUsage(IPUsage ipUsage) {
        this.ipUsage = ipUsage;
    }

    @JsonProperty(value="migrationState")
    public void setMigrationState(MigrationState migrationState) {
        this.migrationState = migrationState;
    }

    @Override
    public String toString() {
        return "Subnet(reservedIpAddresses=" + this.getReservedIpAddresses() + ", dynamicIpAddresses=" + this.getDynamicIpAddresses() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", subnetType=" + (Object)((Object)this.getSubnetType()) + ", networkId=" + this.getNetworkId() + ", dhcpOptions=" + this.getDhcpOptions() + ", ipConfig=" + this.getIpConfig() + ", clusterReference=" + this.getClusterReference() + ", virtualSwitchReference=" + this.getVirtualSwitchReference() + ", vpcReference=" + this.getVpcReference() + ", isNatEnabled=" + this.getIsNatEnabled() + ", isExternal=" + this.getIsExternal() + ", networkFunctionChainReference=" + this.getNetworkFunctionChainReference() + ", bridgeName=" + this.getBridgeName() + ", isAdvancedNetworking=" + this.getIsAdvancedNetworking() + ", clusterName=" + this.getClusterName() + ", hypervisorType=" + this.getHypervisorType() + ", virtualSwitch=" + this.getVirtualSwitch() + ", vpc=" + this.getVpc() + ", ipPrefix=" + this.getIpPrefix() + ", ipUsage=" + this.getIpUsage() + ", migrationState=" + (Object)((Object)this.getMigrationState()) + ")";
    }

    public static class SubnetBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private SubnetType subnetType;
        private Integer networkId;
        private DhcpOptions dhcpOptions;
        private List<IPConfig> ipConfig;
        private String clusterReference;
        private String virtualSwitchReference;
        private String vpcReference;
        private Boolean isNatEnabled;
        private Boolean isExternal;
        private List<IPAddress> reservedIpAddresses;
        private List<IPAddress> dynamicIpAddresses;
        private String networkFunctionChainReference;
        private String bridgeName;
        private Boolean isAdvancedNetworking;
        private String clusterName;
        private String hypervisorType;
        private VirtualSwitch virtualSwitch;
        private Vpc vpc;
        private String ipPrefix;
        private IPUsage ipUsage;
        private MigrationState migrationState;

        SubnetBuilder() {
        }

        public SubnetBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SubnetBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public SubnetBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public SubnetBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubnetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SubnetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SubnetBuilder subnetType(SubnetType subnetType) {
            this.subnetType = subnetType;
            return this;
        }

        public SubnetBuilder networkId(Integer networkId) {
            this.networkId = networkId;
            return this;
        }

        public SubnetBuilder dhcpOptions(DhcpOptions dhcpOptions) {
            this.dhcpOptions = dhcpOptions;
            return this;
        }

        public SubnetBuilder ipConfig(List<IPConfig> ipConfig) {
            this.ipConfig = ipConfig;
            return this;
        }

        public SubnetBuilder clusterReference(String clusterReference) {
            this.clusterReference = clusterReference;
            return this;
        }

        public SubnetBuilder virtualSwitchReference(String virtualSwitchReference) {
            this.virtualSwitchReference = virtualSwitchReference;
            return this;
        }

        public SubnetBuilder vpcReference(String vpcReference) {
            this.vpcReference = vpcReference;
            return this;
        }

        public SubnetBuilder isNatEnabled(Boolean isNatEnabled) {
            this.isNatEnabled = isNatEnabled;
            return this;
        }

        public SubnetBuilder isExternal(Boolean isExternal) {
            this.isExternal = isExternal;
            return this;
        }

        public SubnetBuilder reservedIpAddresses(List<IPAddress> reservedIpAddresses) {
            this.reservedIpAddresses = reservedIpAddresses;
            return this;
        }

        public SubnetBuilder dynamicIpAddresses(List<IPAddress> dynamicIpAddresses) {
            this.dynamicIpAddresses = dynamicIpAddresses;
            return this;
        }

        public SubnetBuilder networkFunctionChainReference(String networkFunctionChainReference) {
            this.networkFunctionChainReference = networkFunctionChainReference;
            return this;
        }

        public SubnetBuilder bridgeName(String bridgeName) {
            this.bridgeName = bridgeName;
            return this;
        }

        public SubnetBuilder isAdvancedNetworking(Boolean isAdvancedNetworking) {
            this.isAdvancedNetworking = isAdvancedNetworking;
            return this;
        }

        public SubnetBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public SubnetBuilder hypervisorType(String hypervisorType) {
            this.hypervisorType = hypervisorType;
            return this;
        }

        public SubnetBuilder virtualSwitch(VirtualSwitch virtualSwitch) {
            this.virtualSwitch = virtualSwitch;
            return this;
        }

        public SubnetBuilder vpc(Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public SubnetBuilder ipPrefix(String ipPrefix) {
            this.ipPrefix = ipPrefix;
            return this;
        }

        public SubnetBuilder ipUsage(IPUsage ipUsage) {
            this.ipUsage = ipUsage;
            return this;
        }

        public SubnetBuilder migrationState(MigrationState migrationState) {
            this.migrationState = migrationState;
            return this;
        }

        public Subnet build() {
            return new Subnet(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.subnetType, this.networkId, this.dhcpOptions, this.ipConfig, this.clusterReference, this.virtualSwitchReference, this.vpcReference, this.isNatEnabled, this.isExternal, this.reservedIpAddresses, this.dynamicIpAddresses, this.networkFunctionChainReference, this.bridgeName, this.isAdvancedNetworking, this.clusterName, this.hypervisorType, this.virtualSwitch, this.vpc, this.ipPrefix, this.ipUsage, this.migrationState);
        }

        public String toString() {
            return "Subnet.SubnetBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", subnetType=" + (Object)((Object)this.subnetType) + ", networkId=" + this.networkId + ", dhcpOptions=" + this.dhcpOptions + ", ipConfig=" + this.ipConfig + ", clusterReference=" + this.clusterReference + ", virtualSwitchReference=" + this.virtualSwitchReference + ", vpcReference=" + this.vpcReference + ", isNatEnabled=" + this.isNatEnabled + ", isExternal=" + this.isExternal + ", reservedIpAddresses=" + this.reservedIpAddresses + ", dynamicIpAddresses=" + this.dynamicIpAddresses + ", networkFunctionChainReference=" + this.networkFunctionChainReference + ", bridgeName=" + this.bridgeName + ", isAdvancedNetworking=" + this.isAdvancedNetworking + ", clusterName=" + this.clusterName + ", hypervisorType=" + this.hypervisorType + ", virtualSwitch=" + this.virtualSwitch + ", vpc=" + this.vpc + ", ipPrefix=" + this.ipPrefix + ", ipUsage=" + this.ipUsage + ", migrationState=" + (Object)((Object)this.migrationState) + ")";
        }
    }
}

