/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.TrafficMirrorPort;
import com.nutanix.dp1.net.networking.v4.config.TrafficMirrorSourcePort;
import com.nutanix.dp1.net.networking.v4.config.TrafficMirrorState;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficMirror
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(TrafficMirror.class);
    private String stateMessage = null;
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @Size(min=1, max=50)
    @JsonProperty(value="sourceList")
    public @Size(min=1, max=50) List<TrafficMirrorSourcePort> sourceList = null;
    @Size(min=1, max=50)
    @JsonProperty(value="destinationList")
    public @Size(min=1, max=50) List<TrafficMirrorPort> destinationList = null;
    @JsonProperty(value="isEnabled")
    public Boolean isEnabled = true;
    @Size(min=1, max=1)
    @JsonProperty(value="clusterReferenceList")
    public @Size(min=1, max=1) List<String> clusterReferenceList = null;
    @Size(min=1, max=64)
    @JsonProperty(value="hostReferenceList")
    public @Size(min=1, max=64) List<String> hostReferenceList = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="virtualSwitchReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String virtualSwitchReference = null;
    @JsonProperty(value="state")
    public TrafficMirrorState state = null;

    public TrafficMirror() {
    }

    public TrafficMirror(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, List<TrafficMirrorSourcePort> sourceList, List<TrafficMirrorPort> destinationList, Boolean isEnabled, List<String> clusterReferenceList, List<String> hostReferenceList, String virtualSwitchReference, TrafficMirrorState state, String stateMessage) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setSourceList(sourceList);
        this.setDestinationList(destinationList);
        this.setIsEnabled(isEnabled);
        this.setClusterReferenceList(clusterReferenceList);
        this.setHostReferenceList(hostReferenceList);
        this.setVirtualSwitchReference(virtualSwitchReference);
        this.setState(state);
        this.setStateMessage(stateMessage);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.TrafficMirror";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setStateMessage(String stateMessage) {
        if (this.stateMessage == null) {
            this.stateMessage = stateMessage;
        } else {
            log.warn("Read-only property stateMessage already contains a non-null value and cannot be set again");
        }
    }

    public static TrafficMirrorBuilder TrafficMirrorBuilder() {
        return new TrafficMirrorBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrafficMirror)) {
            return false;
        }
        TrafficMirror other = (TrafficMirror)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$stateMessage = this.getStateMessage();
        String other$stateMessage = other.getStateMessage();
        if (this$stateMessage == null ? other$stateMessage != null : !this$stateMessage.equals(other$stateMessage)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<TrafficMirrorSourcePort> this$sourceList = this.getSourceList();
        List<TrafficMirrorSourcePort> other$sourceList = other.getSourceList();
        if (this$sourceList == null ? other$sourceList != null : !((Object)this$sourceList).equals(other$sourceList)) {
            return false;
        }
        List<TrafficMirrorPort> this$destinationList = this.getDestinationList();
        List<TrafficMirrorPort> other$destinationList = other.getDestinationList();
        if (this$destinationList == null ? other$destinationList != null : !((Object)this$destinationList).equals(other$destinationList)) {
            return false;
        }
        Boolean this$isEnabled = this.getIsEnabled();
        Boolean other$isEnabled = other.getIsEnabled();
        if (this$isEnabled == null ? other$isEnabled != null : !((Object)this$isEnabled).equals(other$isEnabled)) {
            return false;
        }
        List<String> this$clusterReferenceList = this.getClusterReferenceList();
        List<String> other$clusterReferenceList = other.getClusterReferenceList();
        if (this$clusterReferenceList == null ? other$clusterReferenceList != null : !((Object)this$clusterReferenceList).equals(other$clusterReferenceList)) {
            return false;
        }
        List<String> this$hostReferenceList = this.getHostReferenceList();
        List<String> other$hostReferenceList = other.getHostReferenceList();
        if (this$hostReferenceList == null ? other$hostReferenceList != null : !((Object)this$hostReferenceList).equals(other$hostReferenceList)) {
            return false;
        }
        String this$virtualSwitchReference = this.getVirtualSwitchReference();
        String other$virtualSwitchReference = other.getVirtualSwitchReference();
        if (this$virtualSwitchReference == null ? other$virtualSwitchReference != null : !this$virtualSwitchReference.equals(other$virtualSwitchReference)) {
            return false;
        }
        TrafficMirrorState this$state = this.getState();
        TrafficMirrorState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TrafficMirror;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $stateMessage = this.getStateMessage();
        result = result * 59 + ($stateMessage == null ? 43 : $stateMessage.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<TrafficMirrorSourcePort> $sourceList = this.getSourceList();
        result = result * 59 + ($sourceList == null ? 43 : ((Object)$sourceList).hashCode());
        List<TrafficMirrorPort> $destinationList = this.getDestinationList();
        result = result * 59 + ($destinationList == null ? 43 : ((Object)$destinationList).hashCode());
        Boolean $isEnabled = this.getIsEnabled();
        result = result * 59 + ($isEnabled == null ? 43 : ((Object)$isEnabled).hashCode());
        List<String> $clusterReferenceList = this.getClusterReferenceList();
        result = result * 59 + ($clusterReferenceList == null ? 43 : ((Object)$clusterReferenceList).hashCode());
        List<String> $hostReferenceList = this.getHostReferenceList();
        result = result * 59 + ($hostReferenceList == null ? 43 : ((Object)$hostReferenceList).hashCode());
        String $virtualSwitchReference = this.getVirtualSwitchReference();
        result = result * 59 + ($virtualSwitchReference == null ? 43 : $virtualSwitchReference.hashCode());
        TrafficMirrorState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TrafficMirrorSourcePort> getSourceList() {
        return this.sourceList;
    }

    public List<TrafficMirrorPort> getDestinationList() {
        return this.destinationList;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public List<String> getClusterReferenceList() {
        return this.clusterReferenceList;
    }

    public List<String> getHostReferenceList() {
        return this.hostReferenceList;
    }

    public String getVirtualSwitchReference() {
        return this.virtualSwitchReference;
    }

    public TrafficMirrorState getState() {
        return this.state;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="sourceList")
    public void setSourceList(List<TrafficMirrorSourcePort> sourceList) {
        this.sourceList = sourceList;
    }

    @JsonProperty(value="destinationList")
    public void setDestinationList(List<TrafficMirrorPort> destinationList) {
        this.destinationList = destinationList;
    }

    @JsonProperty(value="isEnabled")
    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @JsonProperty(value="clusterReferenceList")
    public void setClusterReferenceList(List<String> clusterReferenceList) {
        this.clusterReferenceList = clusterReferenceList;
    }

    @JsonProperty(value="hostReferenceList")
    public void setHostReferenceList(List<String> hostReferenceList) {
        this.hostReferenceList = hostReferenceList;
    }

    @JsonProperty(value="virtualSwitchReference")
    public void setVirtualSwitchReference(String virtualSwitchReference) {
        this.virtualSwitchReference = virtualSwitchReference;
    }

    @JsonProperty(value="state")
    public void setState(TrafficMirrorState state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return "TrafficMirror(stateMessage=" + this.getStateMessage() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", sourceList=" + this.getSourceList() + ", destinationList=" + this.getDestinationList() + ", isEnabled=" + this.getIsEnabled() + ", clusterReferenceList=" + this.getClusterReferenceList() + ", hostReferenceList=" + this.getHostReferenceList() + ", virtualSwitchReference=" + this.getVirtualSwitchReference() + ", state=" + (Object)((Object)this.getState()) + ")";
    }

    public static class TrafficMirrorBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private List<TrafficMirrorSourcePort> sourceList;
        private List<TrafficMirrorPort> destinationList;
        private Boolean isEnabled;
        private List<String> clusterReferenceList;
        private List<String> hostReferenceList;
        private String virtualSwitchReference;
        private TrafficMirrorState state;
        private String stateMessage;

        TrafficMirrorBuilder() {
        }

        public TrafficMirrorBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public TrafficMirrorBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public TrafficMirrorBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public TrafficMirrorBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public TrafficMirrorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TrafficMirrorBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TrafficMirrorBuilder sourceList(List<TrafficMirrorSourcePort> sourceList) {
            this.sourceList = sourceList;
            return this;
        }

        public TrafficMirrorBuilder destinationList(List<TrafficMirrorPort> destinationList) {
            this.destinationList = destinationList;
            return this;
        }

        public TrafficMirrorBuilder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public TrafficMirrorBuilder clusterReferenceList(List<String> clusterReferenceList) {
            this.clusterReferenceList = clusterReferenceList;
            return this;
        }

        public TrafficMirrorBuilder hostReferenceList(List<String> hostReferenceList) {
            this.hostReferenceList = hostReferenceList;
            return this;
        }

        public TrafficMirrorBuilder virtualSwitchReference(String virtualSwitchReference) {
            this.virtualSwitchReference = virtualSwitchReference;
            return this;
        }

        public TrafficMirrorBuilder state(TrafficMirrorState state) {
            this.state = state;
            return this;
        }

        public TrafficMirrorBuilder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public TrafficMirror build() {
            return new TrafficMirror(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.sourceList, this.destinationList, this.isEnabled, this.clusterReferenceList, this.hostReferenceList, this.virtualSwitchReference, this.state, this.stateMessage);
        }

        public String toString() {
            return "TrafficMirror.TrafficMirrorBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", sourceList=" + this.sourceList + ", destinationList=" + this.destinationList + ", isEnabled=" + this.isEnabled + ", clusterReferenceList=" + this.clusterReferenceList + ", hostReferenceList=" + this.hostReferenceList + ", virtualSwitchReference=" + this.virtualSwitchReference + ", state=" + (Object)((Object)this.state) + ", stateMessage=" + this.stateMessage + ")";
        }
    }
}

