/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.UplinkBondLacpStatus;
import com.nutanix.dp1.net.networking.v4.config.UplinkBondType;
import com.nutanix.dp1.net.networking.v4.config.UplinkBondVirtualSwitchInfo;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UplinkBond
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(UplinkBond.class);
    @Size(max=128)
    private @Size(max=128) String name = null;
    @Size(min=2, max=10)
    private @Size(min=2, max=10) List<String> hostNicReferences = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String hostReference = null;
    @JsonProperty(value="type")
    public UplinkBondType type = null;
    @JsonProperty(value="lacpStatus")
    public UplinkBondLacpStatus lacpStatus = null;
    @JsonProperty(value="virtualSwitchInfo")
    public UplinkBondVirtualSwitchInfo virtualSwitchInfo = null;

    public UplinkBond() {
    }

    public UplinkBond(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, List<String> hostNicReferences, UplinkBondType type, UplinkBondLacpStatus lacpStatus, String clusterReference, String hostReference, UplinkBondVirtualSwitchInfo virtualSwitchInfo) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setHostNicReferences(hostNicReferences);
        this.setType(type);
        this.setLacpStatus(lacpStatus);
        this.setClusterReference(clusterReference);
        this.setHostReference(hostReference);
        this.setVirtualSwitchInfo(virtualSwitchInfo);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.UplinkBond";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setName(String name) {
        if (this.name == null) {
            this.name = name;
        } else {
            log.warn("Read-only property name already contains a non-null value and cannot be set again");
        }
    }

    public void setHostNicReferences(List<String> hostNicReferences) {
        if (this.hostNicReferences == null) {
            this.hostNicReferences = hostNicReferences;
        } else {
            log.warn("Read-only property hostNicReferences already contains a non-null value and cannot be set again");
        }
    }

    public void setClusterReference(String clusterReference) {
        if (this.clusterReference == null) {
            this.clusterReference = clusterReference;
        } else {
            log.warn("Read-only property clusterReference already contains a non-null value and cannot be set again");
        }
    }

    public void setHostReference(String hostReference) {
        if (this.hostReference == null) {
            this.hostReference = hostReference;
        } else {
            log.warn("Read-only property hostReference already contains a non-null value and cannot be set again");
        }
    }

    public static UplinkBondBuilder UplinkBondBuilder() {
        return new UplinkBondBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UplinkBond)) {
            return false;
        }
        UplinkBond other = (UplinkBond)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$hostNicReferences = this.getHostNicReferences();
        List<String> other$hostNicReferences = other.getHostNicReferences();
        if (this$hostNicReferences == null ? other$hostNicReferences != null : !((Object)this$hostNicReferences).equals(other$hostNicReferences)) {
            return false;
        }
        String this$clusterReference = this.getClusterReference();
        String other$clusterReference = other.getClusterReference();
        if (this$clusterReference == null ? other$clusterReference != null : !this$clusterReference.equals(other$clusterReference)) {
            return false;
        }
        String this$hostReference = this.getHostReference();
        String other$hostReference = other.getHostReference();
        if (this$hostReference == null ? other$hostReference != null : !this$hostReference.equals(other$hostReference)) {
            return false;
        }
        UplinkBondType this$type = this.getType();
        UplinkBondType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        UplinkBondLacpStatus this$lacpStatus = this.getLacpStatus();
        UplinkBondLacpStatus other$lacpStatus = other.getLacpStatus();
        if (this$lacpStatus == null ? other$lacpStatus != null : !((Object)((Object)this$lacpStatus)).equals((Object)other$lacpStatus)) {
            return false;
        }
        UplinkBondVirtualSwitchInfo this$virtualSwitchInfo = this.getVirtualSwitchInfo();
        UplinkBondVirtualSwitchInfo other$virtualSwitchInfo = other.getVirtualSwitchInfo();
        return !(this$virtualSwitchInfo == null ? other$virtualSwitchInfo != null : !((Object)this$virtualSwitchInfo).equals(other$virtualSwitchInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UplinkBond;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $hostNicReferences = this.getHostNicReferences();
        result = result * 59 + ($hostNicReferences == null ? 43 : ((Object)$hostNicReferences).hashCode());
        String $clusterReference = this.getClusterReference();
        result = result * 59 + ($clusterReference == null ? 43 : $clusterReference.hashCode());
        String $hostReference = this.getHostReference();
        result = result * 59 + ($hostReference == null ? 43 : $hostReference.hashCode());
        UplinkBondType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        UplinkBondLacpStatus $lacpStatus = this.getLacpStatus();
        result = result * 59 + ($lacpStatus == null ? 43 : ((Object)((Object)$lacpStatus)).hashCode());
        UplinkBondVirtualSwitchInfo $virtualSwitchInfo = this.getVirtualSwitchInfo();
        result = result * 59 + ($virtualSwitchInfo == null ? 43 : ((Object)$virtualSwitchInfo).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getHostNicReferences() {
        return this.hostNicReferences;
    }

    public String getClusterReference() {
        return this.clusterReference;
    }

    public String getHostReference() {
        return this.hostReference;
    }

    public UplinkBondType getType() {
        return this.type;
    }

    public UplinkBondLacpStatus getLacpStatus() {
        return this.lacpStatus;
    }

    public UplinkBondVirtualSwitchInfo getVirtualSwitchInfo() {
        return this.virtualSwitchInfo;
    }

    @JsonProperty(value="type")
    public void setType(UplinkBondType type) {
        this.type = type;
    }

    @JsonProperty(value="lacpStatus")
    public void setLacpStatus(UplinkBondLacpStatus lacpStatus) {
        this.lacpStatus = lacpStatus;
    }

    @JsonProperty(value="virtualSwitchInfo")
    public void setVirtualSwitchInfo(UplinkBondVirtualSwitchInfo virtualSwitchInfo) {
        this.virtualSwitchInfo = virtualSwitchInfo;
    }

    @Override
    public String toString() {
        return "UplinkBond(name=" + this.getName() + ", hostNicReferences=" + this.getHostNicReferences() + ", clusterReference=" + this.getClusterReference() + ", hostReference=" + this.getHostReference() + ", type=" + (Object)((Object)this.getType()) + ", lacpStatus=" + (Object)((Object)this.getLacpStatus()) + ", virtualSwitchInfo=" + this.getVirtualSwitchInfo() + ")";
    }

    public static class UplinkBondBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private List<String> hostNicReferences;
        private UplinkBondType type;
        private UplinkBondLacpStatus lacpStatus;
        private String clusterReference;
        private String hostReference;
        private UplinkBondVirtualSwitchInfo virtualSwitchInfo;

        UplinkBondBuilder() {
        }

        public UplinkBondBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public UplinkBondBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public UplinkBondBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public UplinkBondBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public UplinkBondBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UplinkBondBuilder hostNicReferences(List<String> hostNicReferences) {
            this.hostNicReferences = hostNicReferences;
            return this;
        }

        public UplinkBondBuilder type(UplinkBondType type) {
            this.type = type;
            return this;
        }

        public UplinkBondBuilder lacpStatus(UplinkBondLacpStatus lacpStatus) {
            this.lacpStatus = lacpStatus;
            return this;
        }

        public UplinkBondBuilder clusterReference(String clusterReference) {
            this.clusterReference = clusterReference;
            return this;
        }

        public UplinkBondBuilder hostReference(String hostReference) {
            this.hostReference = hostReference;
            return this;
        }

        public UplinkBondBuilder virtualSwitchInfo(UplinkBondVirtualSwitchInfo virtualSwitchInfo) {
            this.virtualSwitchInfo = virtualSwitchInfo;
            return this;
        }

        public UplinkBond build() {
            return new UplinkBond(this.tenantId, this.extId, this.links, this.metadata, this.name, this.hostNicReferences, this.type, this.lacpStatus, this.clusterReference, this.hostReference, this.virtualSwitchInfo);
        }

        public String toString() {
            return "UplinkBond.UplinkBondBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", hostNicReferences=" + this.hostNicReferences + ", type=" + (Object)((Object)this.type) + ", lacpStatus=" + (Object)((Object)this.lacpStatus) + ", clusterReference=" + this.clusterReference + ", hostReference=" + this.hostReference + ", virtualSwitchInfo=" + this.virtualSwitchInfo + ")";
        }
    }
}

