/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.BondModeType;
import com.nutanix.dp1.net.networking.v4.config.Cluster;
import com.nutanix.dp1.net.networking.v4.config.IgmpSpec;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.OwnerType;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualSwitch
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VirtualSwitch.class);
    private Boolean hasDeploymentError = null;
    private Boolean hasUpdateInProgress = null;
    private Boolean hasDeleteInProgress = null;
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(value="isDefault")
    public Boolean isDefault = false;
    @JsonProperty(value="isQuickMode")
    public Boolean isQuickMode = false;
    @JsonProperty(value="mtu")
    public Long mtu = 1500L;
    @JsonProperty(value="bondMode")
    public BondModeType bondMode = null;
    @Size(min=1, max=16)
    @JsonProperty(value="clusters")
    public @Size(min=1, max=16) List<Cluster> clusters = null;
    @JsonProperty(value="igmpSpec")
    public IgmpSpec igmpSpec = null;
    @JsonProperty(value="ownerType")
    public OwnerType ownerType = null;

    public VirtualSwitch() {
    }

    public VirtualSwitch(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, Boolean isDefault, Boolean isQuickMode, Boolean hasDeploymentError, Long mtu, BondModeType bondMode, List<Cluster> clusters, IgmpSpec igmpSpec, OwnerType ownerType, Boolean hasUpdateInProgress, Boolean hasDeleteInProgress) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setIsDefault(isDefault);
        this.setIsQuickMode(isQuickMode);
        this.setHasDeploymentError(hasDeploymentError);
        this.setMtu(mtu);
        this.setBondMode(bondMode);
        this.setClusters(clusters);
        this.setIgmpSpec(igmpSpec);
        this.setOwnerType(ownerType);
        this.setHasUpdateInProgress(hasUpdateInProgress);
        this.setHasDeleteInProgress(hasDeleteInProgress);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.VirtualSwitch";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setHasDeploymentError(Boolean hasDeploymentError) {
        if (this.hasDeploymentError == null) {
            this.hasDeploymentError = hasDeploymentError;
        } else {
            log.warn("Read-only property hasDeploymentError already contains a non-null value and cannot be set again");
        }
    }

    public void setHasUpdateInProgress(Boolean hasUpdateInProgress) {
        if (this.hasUpdateInProgress == null) {
            this.hasUpdateInProgress = hasUpdateInProgress;
        } else {
            log.warn("Read-only property hasUpdateInProgress already contains a non-null value and cannot be set again");
        }
    }

    public void setHasDeleteInProgress(Boolean hasDeleteInProgress) {
        if (this.hasDeleteInProgress == null) {
            this.hasDeleteInProgress = hasDeleteInProgress;
        } else {
            log.warn("Read-only property hasDeleteInProgress already contains a non-null value and cannot be set again");
        }
    }

    public static VirtualSwitchBuilder VirtualSwitchBuilder() {
        return new VirtualSwitchBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualSwitch)) {
            return false;
        }
        VirtualSwitch other = (VirtualSwitch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$hasDeploymentError = this.getHasDeploymentError();
        Boolean other$hasDeploymentError = other.getHasDeploymentError();
        if (this$hasDeploymentError == null ? other$hasDeploymentError != null : !((Object)this$hasDeploymentError).equals(other$hasDeploymentError)) {
            return false;
        }
        Boolean this$hasUpdateInProgress = this.getHasUpdateInProgress();
        Boolean other$hasUpdateInProgress = other.getHasUpdateInProgress();
        if (this$hasUpdateInProgress == null ? other$hasUpdateInProgress != null : !((Object)this$hasUpdateInProgress).equals(other$hasUpdateInProgress)) {
            return false;
        }
        Boolean this$hasDeleteInProgress = this.getHasDeleteInProgress();
        Boolean other$hasDeleteInProgress = other.getHasDeleteInProgress();
        if (this$hasDeleteInProgress == null ? other$hasDeleteInProgress != null : !((Object)this$hasDeleteInProgress).equals(other$hasDeleteInProgress)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        Boolean this$isQuickMode = this.getIsQuickMode();
        Boolean other$isQuickMode = other.getIsQuickMode();
        if (this$isQuickMode == null ? other$isQuickMode != null : !((Object)this$isQuickMode).equals(other$isQuickMode)) {
            return false;
        }
        Long this$mtu = this.getMtu();
        Long other$mtu = other.getMtu();
        if (this$mtu == null ? other$mtu != null : !((Object)this$mtu).equals(other$mtu)) {
            return false;
        }
        BondModeType this$bondMode = this.getBondMode();
        BondModeType other$bondMode = other.getBondMode();
        if (this$bondMode == null ? other$bondMode != null : !((Object)((Object)this$bondMode)).equals((Object)other$bondMode)) {
            return false;
        }
        List<Cluster> this$clusters = this.getClusters();
        List<Cluster> other$clusters = other.getClusters();
        if (this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters)) {
            return false;
        }
        IgmpSpec this$igmpSpec = this.getIgmpSpec();
        IgmpSpec other$igmpSpec = other.getIgmpSpec();
        if (this$igmpSpec == null ? other$igmpSpec != null : !((Object)this$igmpSpec).equals(other$igmpSpec)) {
            return false;
        }
        OwnerType this$ownerType = this.getOwnerType();
        OwnerType other$ownerType = other.getOwnerType();
        return !(this$ownerType == null ? other$ownerType != null : !((Object)((Object)this$ownerType)).equals((Object)other$ownerType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VirtualSwitch;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $hasDeploymentError = this.getHasDeploymentError();
        result = result * 59 + ($hasDeploymentError == null ? 43 : ((Object)$hasDeploymentError).hashCode());
        Boolean $hasUpdateInProgress = this.getHasUpdateInProgress();
        result = result * 59 + ($hasUpdateInProgress == null ? 43 : ((Object)$hasUpdateInProgress).hashCode());
        Boolean $hasDeleteInProgress = this.getHasDeleteInProgress();
        result = result * 59 + ($hasDeleteInProgress == null ? 43 : ((Object)$hasDeleteInProgress).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        Boolean $isQuickMode = this.getIsQuickMode();
        result = result * 59 + ($isQuickMode == null ? 43 : ((Object)$isQuickMode).hashCode());
        Long $mtu = this.getMtu();
        result = result * 59 + ($mtu == null ? 43 : ((Object)$mtu).hashCode());
        BondModeType $bondMode = this.getBondMode();
        result = result * 59 + ($bondMode == null ? 43 : ((Object)((Object)$bondMode)).hashCode());
        List<Cluster> $clusters = this.getClusters();
        result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
        IgmpSpec $igmpSpec = this.getIgmpSpec();
        result = result * 59 + ($igmpSpec == null ? 43 : ((Object)$igmpSpec).hashCode());
        OwnerType $ownerType = this.getOwnerType();
        result = result * 59 + ($ownerType == null ? 43 : ((Object)((Object)$ownerType)).hashCode());
        return result;
    }

    public Boolean getHasDeploymentError() {
        return this.hasDeploymentError;
    }

    public Boolean getHasUpdateInProgress() {
        return this.hasUpdateInProgress;
    }

    public Boolean getHasDeleteInProgress() {
        return this.hasDeleteInProgress;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public Boolean getIsQuickMode() {
        return this.isQuickMode;
    }

    public Long getMtu() {
        return this.mtu;
    }

    public BondModeType getBondMode() {
        return this.bondMode;
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }

    public IgmpSpec getIgmpSpec() {
        return this.igmpSpec;
    }

    public OwnerType getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="isDefault")
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @JsonProperty(value="isQuickMode")
    public void setIsQuickMode(Boolean isQuickMode) {
        this.isQuickMode = isQuickMode;
    }

    @JsonProperty(value="mtu")
    public void setMtu(Long mtu) {
        this.mtu = mtu;
    }

    @JsonProperty(value="bondMode")
    public void setBondMode(BondModeType bondMode) {
        this.bondMode = bondMode;
    }

    @JsonProperty(value="clusters")
    public void setClusters(List<Cluster> clusters) {
        this.clusters = clusters;
    }

    @JsonProperty(value="igmpSpec")
    public void setIgmpSpec(IgmpSpec igmpSpec) {
        this.igmpSpec = igmpSpec;
    }

    @JsonProperty(value="ownerType")
    public void setOwnerType(OwnerType ownerType) {
        this.ownerType = ownerType;
    }

    @Override
    public String toString() {
        return "VirtualSwitch(hasDeploymentError=" + this.getHasDeploymentError() + ", hasUpdateInProgress=" + this.getHasUpdateInProgress() + ", hasDeleteInProgress=" + this.getHasDeleteInProgress() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", isDefault=" + this.getIsDefault() + ", isQuickMode=" + this.getIsQuickMode() + ", mtu=" + this.getMtu() + ", bondMode=" + (Object)((Object)this.getBondMode()) + ", clusters=" + this.getClusters() + ", igmpSpec=" + this.getIgmpSpec() + ", ownerType=" + (Object)((Object)this.getOwnerType()) + ")";
    }

    public static class VirtualSwitchBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private Boolean isDefault;
        private Boolean isQuickMode;
        private Boolean hasDeploymentError;
        private Long mtu;
        private BondModeType bondMode;
        private List<Cluster> clusters;
        private IgmpSpec igmpSpec;
        private OwnerType ownerType;
        private Boolean hasUpdateInProgress;
        private Boolean hasDeleteInProgress;

        VirtualSwitchBuilder() {
        }

        public VirtualSwitchBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VirtualSwitchBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VirtualSwitchBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VirtualSwitchBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public VirtualSwitchBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VirtualSwitchBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VirtualSwitchBuilder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public VirtualSwitchBuilder isQuickMode(Boolean isQuickMode) {
            this.isQuickMode = isQuickMode;
            return this;
        }

        public VirtualSwitchBuilder hasDeploymentError(Boolean hasDeploymentError) {
            this.hasDeploymentError = hasDeploymentError;
            return this;
        }

        public VirtualSwitchBuilder mtu(Long mtu) {
            this.mtu = mtu;
            return this;
        }

        public VirtualSwitchBuilder bondMode(BondModeType bondMode) {
            this.bondMode = bondMode;
            return this;
        }

        public VirtualSwitchBuilder clusters(List<Cluster> clusters) {
            this.clusters = clusters;
            return this;
        }

        public VirtualSwitchBuilder igmpSpec(IgmpSpec igmpSpec) {
            this.igmpSpec = igmpSpec;
            return this;
        }

        public VirtualSwitchBuilder ownerType(OwnerType ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        public VirtualSwitchBuilder hasUpdateInProgress(Boolean hasUpdateInProgress) {
            this.hasUpdateInProgress = hasUpdateInProgress;
            return this;
        }

        public VirtualSwitchBuilder hasDeleteInProgress(Boolean hasDeleteInProgress) {
            this.hasDeleteInProgress = hasDeleteInProgress;
            return this;
        }

        public VirtualSwitch build() {
            return new VirtualSwitch(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.isDefault, this.isQuickMode, this.hasDeploymentError, this.mtu, this.bondMode, this.clusters, this.igmpSpec, this.ownerType, this.hasUpdateInProgress, this.hasDeleteInProgress);
        }

        public String toString() {
            return "VirtualSwitch.VirtualSwitchBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", isDefault=" + this.isDefault + ", isQuickMode=" + this.isQuickMode + ", hasDeploymentError=" + this.hasDeploymentError + ", mtu=" + this.mtu + ", bondMode=" + (Object)((Object)this.bondMode) + ", clusters=" + this.clusters + ", igmpSpec=" + this.igmpSpec + ", ownerType=" + (Object)((Object)this.ownerType) + ", hasUpdateInProgress=" + this.hasUpdateInProgress + ", hasDeleteInProgress=" + this.hasDeleteInProgress + ")";
        }
    }
}

