/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vnic
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Vnic.class);
    @Size(min=0, max=16)
    @JsonProperty(value="learnedIpv4Addresses")
    public @Size(min=0, max=16) List<IPAddress> learnedIpv4Addresses = null;
    @Size(min=0, max=16)
    @JsonProperty(value="assignedIpv4Addresses")
    public @Size(min=0, max=16) List<IPAddress> assignedIpv4Addresses = null;
    @Size(min=0, max=16)
    @JsonProperty(value="assignedSecondaryIpv4Addresses")
    public @Size(min=0, max=16) List<IPAddress> assignedSecondaryIpv4Addresses = null;
    @Pattern(regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$")
    @JsonProperty(value="macAddress")
    public @Pattern(regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$") String macAddress = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vmReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vmReference = null;

    public Vnic() {
    }

    public Vnic(String tenantId, String extId, List<ApiLink> links, Metadata metadata, List<IPAddress> learnedIpv4Addresses, List<IPAddress> assignedIpv4Addresses, List<IPAddress> assignedSecondaryIpv4Addresses, String macAddress, String vmReference) {
        super(tenantId, extId, links, metadata);
        this.setLearnedIpv4Addresses(learnedIpv4Addresses);
        this.setAssignedIpv4Addresses(assignedIpv4Addresses);
        this.setAssignedSecondaryIpv4Addresses(assignedSecondaryIpv4Addresses);
        this.setMacAddress(macAddress);
        this.setVmReference(vmReference);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.Vnic";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static VnicBuilder VnicBuilder() {
        return new VnicBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vnic)) {
            return false;
        }
        Vnic other = (Vnic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<IPAddress> this$learnedIpv4Addresses = this.getLearnedIpv4Addresses();
        List<IPAddress> other$learnedIpv4Addresses = other.getLearnedIpv4Addresses();
        if (this$learnedIpv4Addresses == null ? other$learnedIpv4Addresses != null : !((Object)this$learnedIpv4Addresses).equals(other$learnedIpv4Addresses)) {
            return false;
        }
        List<IPAddress> this$assignedIpv4Addresses = this.getAssignedIpv4Addresses();
        List<IPAddress> other$assignedIpv4Addresses = other.getAssignedIpv4Addresses();
        if (this$assignedIpv4Addresses == null ? other$assignedIpv4Addresses != null : !((Object)this$assignedIpv4Addresses).equals(other$assignedIpv4Addresses)) {
            return false;
        }
        List<IPAddress> this$assignedSecondaryIpv4Addresses = this.getAssignedSecondaryIpv4Addresses();
        List<IPAddress> other$assignedSecondaryIpv4Addresses = other.getAssignedSecondaryIpv4Addresses();
        if (this$assignedSecondaryIpv4Addresses == null ? other$assignedSecondaryIpv4Addresses != null : !((Object)this$assignedSecondaryIpv4Addresses).equals(other$assignedSecondaryIpv4Addresses)) {
            return false;
        }
        String this$macAddress = this.getMacAddress();
        String other$macAddress = other.getMacAddress();
        if (this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress)) {
            return false;
        }
        String this$vmReference = this.getVmReference();
        String other$vmReference = other.getVmReference();
        return !(this$vmReference == null ? other$vmReference != null : !this$vmReference.equals(other$vmReference));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Vnic;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<IPAddress> $learnedIpv4Addresses = this.getLearnedIpv4Addresses();
        result = result * 59 + ($learnedIpv4Addresses == null ? 43 : ((Object)$learnedIpv4Addresses).hashCode());
        List<IPAddress> $assignedIpv4Addresses = this.getAssignedIpv4Addresses();
        result = result * 59 + ($assignedIpv4Addresses == null ? 43 : ((Object)$assignedIpv4Addresses).hashCode());
        List<IPAddress> $assignedSecondaryIpv4Addresses = this.getAssignedSecondaryIpv4Addresses();
        result = result * 59 + ($assignedSecondaryIpv4Addresses == null ? 43 : ((Object)$assignedSecondaryIpv4Addresses).hashCode());
        String $macAddress = this.getMacAddress();
        result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
        String $vmReference = this.getVmReference();
        result = result * 59 + ($vmReference == null ? 43 : $vmReference.hashCode());
        return result;
    }

    public List<IPAddress> getLearnedIpv4Addresses() {
        return this.learnedIpv4Addresses;
    }

    public List<IPAddress> getAssignedIpv4Addresses() {
        return this.assignedIpv4Addresses;
    }

    public List<IPAddress> getAssignedSecondaryIpv4Addresses() {
        return this.assignedSecondaryIpv4Addresses;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getVmReference() {
        return this.vmReference;
    }

    @JsonProperty(value="learnedIpv4Addresses")
    public void setLearnedIpv4Addresses(List<IPAddress> learnedIpv4Addresses) {
        this.learnedIpv4Addresses = learnedIpv4Addresses;
    }

    @JsonProperty(value="assignedIpv4Addresses")
    public void setAssignedIpv4Addresses(List<IPAddress> assignedIpv4Addresses) {
        this.assignedIpv4Addresses = assignedIpv4Addresses;
    }

    @JsonProperty(value="assignedSecondaryIpv4Addresses")
    public void setAssignedSecondaryIpv4Addresses(List<IPAddress> assignedSecondaryIpv4Addresses) {
        this.assignedSecondaryIpv4Addresses = assignedSecondaryIpv4Addresses;
    }

    @JsonProperty(value="macAddress")
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @JsonProperty(value="vmReference")
    public void setVmReference(String vmReference) {
        this.vmReference = vmReference;
    }

    @Override
    public String toString() {
        return "Vnic(learnedIpv4Addresses=" + this.getLearnedIpv4Addresses() + ", assignedIpv4Addresses=" + this.getAssignedIpv4Addresses() + ", assignedSecondaryIpv4Addresses=" + this.getAssignedSecondaryIpv4Addresses() + ", macAddress=" + this.getMacAddress() + ", vmReference=" + this.getVmReference() + ")";
    }

    public static class VnicBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private List<IPAddress> learnedIpv4Addresses;
        private List<IPAddress> assignedIpv4Addresses;
        private List<IPAddress> assignedSecondaryIpv4Addresses;
        private String macAddress;
        private String vmReference;

        VnicBuilder() {
        }

        public VnicBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VnicBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VnicBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VnicBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public VnicBuilder learnedIpv4Addresses(List<IPAddress> learnedIpv4Addresses) {
            this.learnedIpv4Addresses = learnedIpv4Addresses;
            return this;
        }

        public VnicBuilder assignedIpv4Addresses(List<IPAddress> assignedIpv4Addresses) {
            this.assignedIpv4Addresses = assignedIpv4Addresses;
            return this;
        }

        public VnicBuilder assignedSecondaryIpv4Addresses(List<IPAddress> assignedSecondaryIpv4Addresses) {
            this.assignedSecondaryIpv4Addresses = assignedSecondaryIpv4Addresses;
            return this;
        }

        public VnicBuilder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public VnicBuilder vmReference(String vmReference) {
            this.vmReference = vmReference;
            return this;
        }

        public Vnic build() {
            return new Vnic(this.tenantId, this.extId, this.links, this.metadata, this.learnedIpv4Addresses, this.assignedIpv4Addresses, this.assignedSecondaryIpv4Addresses, this.macAddress, this.vmReference);
        }

        public String toString() {
            return "Vnic.VnicBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", learnedIpv4Addresses=" + this.learnedIpv4Addresses + ", assignedIpv4Addresses=" + this.assignedIpv4Addresses + ", assignedSecondaryIpv4Addresses=" + this.assignedSecondaryIpv4Addresses + ", macAddress=" + this.macAddress + ", vmReference=" + this.vmReference + ")";
        }
    }
}

