/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VnicMigrationItemSpec
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VnicMigrationItemSpec.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="networkUuid")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String networkUuid = null;
    @Size(min=0, max=1)
    @JsonProperty(value="requestedIpAddresses")
    public @Size(min=0, max=1) List<IPAddress> requestedIpAddresses = null;

    public VnicMigrationItemSpec() {
    }

    public VnicMigrationItemSpec(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String networkUuid, List<IPAddress> requestedIpAddresses) {
        super(tenantId, extId, links, metadata);
        this.setNetworkUuid(networkUuid);
        this.setRequestedIpAddresses(requestedIpAddresses);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.VnicMigrationItemSpec";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static VnicMigrationItemSpecBuilder VnicMigrationItemSpecBuilder() {
        return new VnicMigrationItemSpecBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VnicMigrationItemSpec)) {
            return false;
        }
        VnicMigrationItemSpec other = (VnicMigrationItemSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$networkUuid = this.getNetworkUuid();
        String other$networkUuid = other.getNetworkUuid();
        if (this$networkUuid == null ? other$networkUuid != null : !this$networkUuid.equals(other$networkUuid)) {
            return false;
        }
        List<IPAddress> this$requestedIpAddresses = this.getRequestedIpAddresses();
        List<IPAddress> other$requestedIpAddresses = other.getRequestedIpAddresses();
        return !(this$requestedIpAddresses == null ? other$requestedIpAddresses != null : !((Object)this$requestedIpAddresses).equals(other$requestedIpAddresses));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VnicMigrationItemSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $networkUuid = this.getNetworkUuid();
        result = result * 59 + ($networkUuid == null ? 43 : $networkUuid.hashCode());
        List<IPAddress> $requestedIpAddresses = this.getRequestedIpAddresses();
        result = result * 59 + ($requestedIpAddresses == null ? 43 : ((Object)$requestedIpAddresses).hashCode());
        return result;
    }

    public String getNetworkUuid() {
        return this.networkUuid;
    }

    public List<IPAddress> getRequestedIpAddresses() {
        return this.requestedIpAddresses;
    }

    @JsonProperty(value="networkUuid")
    public void setNetworkUuid(String networkUuid) {
        this.networkUuid = networkUuid;
    }

    @JsonProperty(value="requestedIpAddresses")
    public void setRequestedIpAddresses(List<IPAddress> requestedIpAddresses) {
        this.requestedIpAddresses = requestedIpAddresses;
    }

    @Override
    public String toString() {
        return "VnicMigrationItemSpec(networkUuid=" + this.getNetworkUuid() + ", requestedIpAddresses=" + this.getRequestedIpAddresses() + ")";
    }

    public static class VnicMigrationItemSpecBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String networkUuid;
        private List<IPAddress> requestedIpAddresses;

        VnicMigrationItemSpecBuilder() {
        }

        public VnicMigrationItemSpecBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VnicMigrationItemSpecBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VnicMigrationItemSpecBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VnicMigrationItemSpecBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public VnicMigrationItemSpecBuilder networkUuid(String networkUuid) {
            this.networkUuid = networkUuid;
            return this;
        }

        public VnicMigrationItemSpecBuilder requestedIpAddresses(List<IPAddress> requestedIpAddresses) {
            this.requestedIpAddresses = requestedIpAddresses;
            return this;
        }

        public VnicMigrationItemSpec build() {
            return new VnicMigrationItemSpec(this.tenantId, this.extId, this.links, this.metadata, this.networkUuid, this.requestedIpAddresses);
        }

        public String toString() {
            return "VnicMigrationItemSpec.VnicMigrationItemSpecBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", networkUuid=" + this.networkUuid + ", requestedIpAddresses=" + this.requestedIpAddresses + ")";
        }
    }
}

