/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.ExternalSubnet;
import com.nutanix.dp1.net.networking.v4.config.IPSubnet;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.VpcDhcpOptions;
import com.nutanix.dp1.net.networking.v4.config.VpcType;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vpc
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Vpc.class);
    @Size(min=0, max=2)
    private @Size(min=0, max=2) List<IPAddress> snatIps = null;
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(value="vpcType")
    public VpcType vpcType = null;
    @JsonProperty(value="commonDhcpOptions")
    public VpcDhcpOptions commonDhcpOptions = null;
    @Size(min=0, max=4)
    @JsonProperty(value="externalSubnets")
    public @Size(min=0, max=4) List<ExternalSubnet> externalSubnets = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="externalRoutingDomainReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String externalRoutingDomainReference = null;
    @Size(min=0, max=10)
    @JsonProperty(value="externallyRoutablePrefixes")
    public @Size(min=0, max=10) List<IPSubnet> externallyRoutablePrefixes = null;

    public Vpc() {
    }

    public Vpc(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, VpcType vpcType, VpcDhcpOptions commonDhcpOptions, List<IPAddress> snatIps, List<ExternalSubnet> externalSubnets, String externalRoutingDomainReference, List<IPSubnet> externallyRoutablePrefixes) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setVpcType(vpcType);
        this.setCommonDhcpOptions(commonDhcpOptions);
        this.setSnatIps(snatIps);
        this.setExternalSubnets(externalSubnets);
        this.setExternalRoutingDomainReference(externalRoutingDomainReference);
        this.setExternallyRoutablePrefixes(externallyRoutablePrefixes);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.Vpc";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setSnatIps(List<IPAddress> snatIps) {
        if (this.snatIps == null) {
            this.snatIps = snatIps;
        } else {
            log.warn("Read-only property snatIps already contains a non-null value and cannot be set again");
        }
    }

    public static VpcBuilder VpcBuilder() {
        return new VpcBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vpc)) {
            return false;
        }
        Vpc other = (Vpc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<IPAddress> this$snatIps = this.getSnatIps();
        List<IPAddress> other$snatIps = other.getSnatIps();
        if (this$snatIps == null ? other$snatIps != null : !((Object)this$snatIps).equals(other$snatIps)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        VpcType this$vpcType = this.getVpcType();
        VpcType other$vpcType = other.getVpcType();
        if (this$vpcType == null ? other$vpcType != null : !((Object)((Object)this$vpcType)).equals((Object)other$vpcType)) {
            return false;
        }
        VpcDhcpOptions this$commonDhcpOptions = this.getCommonDhcpOptions();
        VpcDhcpOptions other$commonDhcpOptions = other.getCommonDhcpOptions();
        if (this$commonDhcpOptions == null ? other$commonDhcpOptions != null : !((Object)this$commonDhcpOptions).equals(other$commonDhcpOptions)) {
            return false;
        }
        List<ExternalSubnet> this$externalSubnets = this.getExternalSubnets();
        List<ExternalSubnet> other$externalSubnets = other.getExternalSubnets();
        if (this$externalSubnets == null ? other$externalSubnets != null : !((Object)this$externalSubnets).equals(other$externalSubnets)) {
            return false;
        }
        String this$externalRoutingDomainReference = this.getExternalRoutingDomainReference();
        String other$externalRoutingDomainReference = other.getExternalRoutingDomainReference();
        if (this$externalRoutingDomainReference == null ? other$externalRoutingDomainReference != null : !this$externalRoutingDomainReference.equals(other$externalRoutingDomainReference)) {
            return false;
        }
        List<IPSubnet> this$externallyRoutablePrefixes = this.getExternallyRoutablePrefixes();
        List<IPSubnet> other$externallyRoutablePrefixes = other.getExternallyRoutablePrefixes();
        return !(this$externallyRoutablePrefixes == null ? other$externallyRoutablePrefixes != null : !((Object)this$externallyRoutablePrefixes).equals(other$externallyRoutablePrefixes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Vpc;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<IPAddress> $snatIps = this.getSnatIps();
        result = result * 59 + ($snatIps == null ? 43 : ((Object)$snatIps).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        VpcType $vpcType = this.getVpcType();
        result = result * 59 + ($vpcType == null ? 43 : ((Object)((Object)$vpcType)).hashCode());
        VpcDhcpOptions $commonDhcpOptions = this.getCommonDhcpOptions();
        result = result * 59 + ($commonDhcpOptions == null ? 43 : ((Object)$commonDhcpOptions).hashCode());
        List<ExternalSubnet> $externalSubnets = this.getExternalSubnets();
        result = result * 59 + ($externalSubnets == null ? 43 : ((Object)$externalSubnets).hashCode());
        String $externalRoutingDomainReference = this.getExternalRoutingDomainReference();
        result = result * 59 + ($externalRoutingDomainReference == null ? 43 : $externalRoutingDomainReference.hashCode());
        List<IPSubnet> $externallyRoutablePrefixes = this.getExternallyRoutablePrefixes();
        result = result * 59 + ($externallyRoutablePrefixes == null ? 43 : ((Object)$externallyRoutablePrefixes).hashCode());
        return result;
    }

    public List<IPAddress> getSnatIps() {
        return this.snatIps;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public VpcType getVpcType() {
        return this.vpcType;
    }

    public VpcDhcpOptions getCommonDhcpOptions() {
        return this.commonDhcpOptions;
    }

    public List<ExternalSubnet> getExternalSubnets() {
        return this.externalSubnets;
    }

    public String getExternalRoutingDomainReference() {
        return this.externalRoutingDomainReference;
    }

    public List<IPSubnet> getExternallyRoutablePrefixes() {
        return this.externallyRoutablePrefixes;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="vpcType")
    public void setVpcType(VpcType vpcType) {
        this.vpcType = vpcType;
    }

    @JsonProperty(value="commonDhcpOptions")
    public void setCommonDhcpOptions(VpcDhcpOptions commonDhcpOptions) {
        this.commonDhcpOptions = commonDhcpOptions;
    }

    @JsonProperty(value="externalSubnets")
    public void setExternalSubnets(List<ExternalSubnet> externalSubnets) {
        this.externalSubnets = externalSubnets;
    }

    @JsonProperty(value="externalRoutingDomainReference")
    public void setExternalRoutingDomainReference(String externalRoutingDomainReference) {
        this.externalRoutingDomainReference = externalRoutingDomainReference;
    }

    @JsonProperty(value="externallyRoutablePrefixes")
    public void setExternallyRoutablePrefixes(List<IPSubnet> externallyRoutablePrefixes) {
        this.externallyRoutablePrefixes = externallyRoutablePrefixes;
    }

    @Override
    public String toString() {
        return "Vpc(snatIps=" + this.getSnatIps() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", vpcType=" + (Object)((Object)this.getVpcType()) + ", commonDhcpOptions=" + this.getCommonDhcpOptions() + ", externalSubnets=" + this.getExternalSubnets() + ", externalRoutingDomainReference=" + this.getExternalRoutingDomainReference() + ", externallyRoutablePrefixes=" + this.getExternallyRoutablePrefixes() + ")";
    }

    public static class VpcBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private VpcType vpcType;
        private VpcDhcpOptions commonDhcpOptions;
        private List<IPAddress> snatIps;
        private List<ExternalSubnet> externalSubnets;
        private String externalRoutingDomainReference;
        private List<IPSubnet> externallyRoutablePrefixes;

        VpcBuilder() {
        }

        public VpcBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VpcBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VpcBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VpcBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public VpcBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VpcBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VpcBuilder vpcType(VpcType vpcType) {
            this.vpcType = vpcType;
            return this;
        }

        public VpcBuilder commonDhcpOptions(VpcDhcpOptions commonDhcpOptions) {
            this.commonDhcpOptions = commonDhcpOptions;
            return this;
        }

        public VpcBuilder snatIps(List<IPAddress> snatIps) {
            this.snatIps = snatIps;
            return this;
        }

        public VpcBuilder externalSubnets(List<ExternalSubnet> externalSubnets) {
            this.externalSubnets = externalSubnets;
            return this;
        }

        public VpcBuilder externalRoutingDomainReference(String externalRoutingDomainReference) {
            this.externalRoutingDomainReference = externalRoutingDomainReference;
            return this;
        }

        public VpcBuilder externallyRoutablePrefixes(List<IPSubnet> externallyRoutablePrefixes) {
            this.externallyRoutablePrefixes = externallyRoutablePrefixes;
            return this;
        }

        public Vpc build() {
            return new Vpc(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.vpcType, this.commonDhcpOptions, this.snatIps, this.externalSubnets, this.externalRoutingDomainReference, this.externallyRoutablePrefixes);
        }

        public String toString() {
            return "Vpc.VpcBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", vpcType=" + (Object)((Object)this.vpcType) + ", commonDhcpOptions=" + this.commonDhcpOptions + ", snatIps=" + this.snatIps + ", externalSubnets=" + this.externalSubnets + ", externalRoutingDomainReference=" + this.externalRoutingDomainReference + ", externallyRoutablePrefixes=" + this.externallyRoutablePrefixes + ")";
        }
    }
}

