/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VpcVirtualSwitchMapping
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VpcVirtualSwitchMapping.class);
    @Size(min=1, max=16)
    @JsonProperty(value="clusterUuids")
    public @Size(min=1, max=16) List<String> clusterUuids = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="virtualSwitchUuid")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String virtualSwitchUuid = null;
    @JsonProperty(value="isAllTrafficPermitted")
    public Boolean isAllTrafficPermitted = null;

    public VpcVirtualSwitchMapping() {
    }

    public VpcVirtualSwitchMapping(String tenantId, String extId, List<ApiLink> links, Metadata metadata, List<String> clusterUuids, String virtualSwitchUuid, Boolean isAllTrafficPermitted) {
        super(tenantId, extId, links, metadata);
        this.setClusterUuids(clusterUuids);
        this.setVirtualSwitchUuid(virtualSwitchUuid);
        this.setIsAllTrafficPermitted(isAllTrafficPermitted);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.VpcVirtualSwitchMapping";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static VpcVirtualSwitchMappingBuilder VpcVirtualSwitchMappingBuilder() {
        return new VpcVirtualSwitchMappingBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VpcVirtualSwitchMapping)) {
            return false;
        }
        VpcVirtualSwitchMapping other = (VpcVirtualSwitchMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$clusterUuids = this.getClusterUuids();
        List<String> other$clusterUuids = other.getClusterUuids();
        if (this$clusterUuids == null ? other$clusterUuids != null : !((Object)this$clusterUuids).equals(other$clusterUuids)) {
            return false;
        }
        String this$virtualSwitchUuid = this.getVirtualSwitchUuid();
        String other$virtualSwitchUuid = other.getVirtualSwitchUuid();
        if (this$virtualSwitchUuid == null ? other$virtualSwitchUuid != null : !this$virtualSwitchUuid.equals(other$virtualSwitchUuid)) {
            return false;
        }
        Boolean this$isAllTrafficPermitted = this.getIsAllTrafficPermitted();
        Boolean other$isAllTrafficPermitted = other.getIsAllTrafficPermitted();
        return !(this$isAllTrafficPermitted == null ? other$isAllTrafficPermitted != null : !((Object)this$isAllTrafficPermitted).equals(other$isAllTrafficPermitted));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VpcVirtualSwitchMapping;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $clusterUuids = this.getClusterUuids();
        result = result * 59 + ($clusterUuids == null ? 43 : ((Object)$clusterUuids).hashCode());
        String $virtualSwitchUuid = this.getVirtualSwitchUuid();
        result = result * 59 + ($virtualSwitchUuid == null ? 43 : $virtualSwitchUuid.hashCode());
        Boolean $isAllTrafficPermitted = this.getIsAllTrafficPermitted();
        result = result * 59 + ($isAllTrafficPermitted == null ? 43 : ((Object)$isAllTrafficPermitted).hashCode());
        return result;
    }

    public List<String> getClusterUuids() {
        return this.clusterUuids;
    }

    public String getVirtualSwitchUuid() {
        return this.virtualSwitchUuid;
    }

    public Boolean getIsAllTrafficPermitted() {
        return this.isAllTrafficPermitted;
    }

    @JsonProperty(value="clusterUuids")
    public void setClusterUuids(List<String> clusterUuids) {
        this.clusterUuids = clusterUuids;
    }

    @JsonProperty(value="virtualSwitchUuid")
    public void setVirtualSwitchUuid(String virtualSwitchUuid) {
        this.virtualSwitchUuid = virtualSwitchUuid;
    }

    @JsonProperty(value="isAllTrafficPermitted")
    public void setIsAllTrafficPermitted(Boolean isAllTrafficPermitted) {
        this.isAllTrafficPermitted = isAllTrafficPermitted;
    }

    @Override
    public String toString() {
        return "VpcVirtualSwitchMapping(clusterUuids=" + this.getClusterUuids() + ", virtualSwitchUuid=" + this.getVirtualSwitchUuid() + ", isAllTrafficPermitted=" + this.getIsAllTrafficPermitted() + ")";
    }

    public static class VpcVirtualSwitchMappingBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private List<String> clusterUuids;
        private String virtualSwitchUuid;
        private Boolean isAllTrafficPermitted;

        VpcVirtualSwitchMappingBuilder() {
        }

        public VpcVirtualSwitchMappingBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VpcVirtualSwitchMappingBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VpcVirtualSwitchMappingBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VpcVirtualSwitchMappingBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public VpcVirtualSwitchMappingBuilder clusterUuids(List<String> clusterUuids) {
            this.clusterUuids = clusterUuids;
            return this;
        }

        public VpcVirtualSwitchMappingBuilder virtualSwitchUuid(String virtualSwitchUuid) {
            this.virtualSwitchUuid = virtualSwitchUuid;
            return this;
        }

        public VpcVirtualSwitchMappingBuilder isAllTrafficPermitted(Boolean isAllTrafficPermitted) {
            this.isAllTrafficPermitted = isAllTrafficPermitted;
            return this;
        }

        public VpcVirtualSwitchMapping build() {
            return new VpcVirtualSwitchMapping(this.tenantId, this.extId, this.links, this.metadata, this.clusterUuids, this.virtualSwitchUuid, this.isAllTrafficPermitted);
        }

        public String toString() {
            return "VpcVirtualSwitchMapping.VpcVirtualSwitchMappingBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", clusterUuids=" + this.clusterUuids + ", virtualSwitchUuid=" + this.virtualSwitchUuid + ", isAllTrafficPermitted=" + this.isAllTrafficPermitted + ")";
        }
    }
}

