/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VpnAppliance
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VpnAppliance.class);
    private String version = null;
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;

    public VpnAppliance() {
    }

    public VpnAppliance(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String version) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setVersion(version);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.VpnAppliance";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setVersion(String version) {
        if (this.version == null) {
            this.version = version;
        } else {
            log.warn("Read-only property version already contains a non-null value and cannot be set again");
        }
    }

    public static VpnApplianceBuilder VpnApplianceBuilder() {
        return new VpnApplianceBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VpnAppliance)) {
            return false;
        }
        VpnAppliance other = (VpnAppliance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VpnAppliance;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "VpnAppliance(version=" + this.getVersion() + ", name=" + this.getName() + ")";
    }

    public static class VpnApplianceBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String version;

        VpnApplianceBuilder() {
        }

        public VpnApplianceBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VpnApplianceBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VpnApplianceBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VpnApplianceBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public VpnApplianceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VpnApplianceBuilder version(String version) {
            this.version = version;
            return this;
        }

        public VpnAppliance build() {
            return new VpnAppliance(this.tenantId, this.extId, this.links, this.metadata, this.name, this.version);
        }

        public String toString() {
            return "VpnAppliance.VpnApplianceBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", version=" + this.version + ")";
        }
    }
}

