/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.DpdConfig;
import com.nutanix.dp1.net.networking.v4.config.GatewayRole;
import com.nutanix.dp1.net.networking.v4.config.IPSubnet;
import com.nutanix.dp1.net.networking.v4.config.IpsecConfig;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.QosConfig;
import com.nutanix.dp1.net.networking.v4.config.Status;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VpnConnection
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VpnConnection.class);
    @Size(min=0, max=250)
    private @Size(min=0, max=250) List<IPSubnet> advertisedPrefixes = null;
    @Size(min=0, max=250)
    private @Size(min=0, max=250) List<IPSubnet> learnedPrefixes = null;
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="localGatewayReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String localGatewayReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="remoteGatewayReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String remoteGatewayReference = null;
    @JsonProperty(value="ipsecConfig")
    public IpsecConfig ipsecConfig = null;
    @JsonProperty(value="dpdConfig")
    public DpdConfig dpdConfig = null;
    @JsonProperty(value="qosConfig")
    public QosConfig qosConfig = null;
    @JsonProperty(value="localGatewayRole")
    public GatewayRole localGatewayRole = null;
    @Max(value=1000L)
    @Min(value=10L)
    @JsonProperty(value="dynamicRoutePriority")
    public @Max(value=1000L) @Min(value=10L) Integer dynamicRoutePriority = null;
    @JsonProperty(value="ipsecTunnelStatus")
    public Status ipsecTunnelStatus = null;
    @JsonProperty(value="ebgpStatus")
    public Status ebgpStatus = null;

    public VpnConnection() {
    }

    public VpnConnection(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, String localGatewayReference, String remoteGatewayReference, IpsecConfig ipsecConfig, DpdConfig dpdConfig, QosConfig qosConfig, GatewayRole localGatewayRole, Integer dynamicRoutePriority, List<IPSubnet> advertisedPrefixes, List<IPSubnet> learnedPrefixes, Status ipsecTunnelStatus, Status ebgpStatus) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setLocalGatewayReference(localGatewayReference);
        this.setRemoteGatewayReference(remoteGatewayReference);
        this.setIpsecConfig(ipsecConfig);
        this.setDpdConfig(dpdConfig);
        this.setQosConfig(qosConfig);
        this.setLocalGatewayRole(localGatewayRole);
        this.setDynamicRoutePriority(dynamicRoutePriority);
        this.setAdvertisedPrefixes(advertisedPrefixes);
        this.setLearnedPrefixes(learnedPrefixes);
        this.setIpsecTunnelStatus(ipsecTunnelStatus);
        this.setEbgpStatus(ebgpStatus);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.VpnConnection";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setAdvertisedPrefixes(List<IPSubnet> advertisedPrefixes) {
        if (this.advertisedPrefixes == null) {
            this.advertisedPrefixes = advertisedPrefixes;
        } else {
            log.warn("Read-only property advertisedPrefixes already contains a non-null value and cannot be set again");
        }
    }

    public void setLearnedPrefixes(List<IPSubnet> learnedPrefixes) {
        if (this.learnedPrefixes == null) {
            this.learnedPrefixes = learnedPrefixes;
        } else {
            log.warn("Read-only property learnedPrefixes already contains a non-null value and cannot be set again");
        }
    }

    public static VpnConnectionBuilder VpnConnectionBuilder() {
        return new VpnConnectionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VpnConnection)) {
            return false;
        }
        VpnConnection other = (VpnConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<IPSubnet> this$advertisedPrefixes = this.getAdvertisedPrefixes();
        List<IPSubnet> other$advertisedPrefixes = other.getAdvertisedPrefixes();
        if (this$advertisedPrefixes == null ? other$advertisedPrefixes != null : !((Object)this$advertisedPrefixes).equals(other$advertisedPrefixes)) {
            return false;
        }
        List<IPSubnet> this$learnedPrefixes = this.getLearnedPrefixes();
        List<IPSubnet> other$learnedPrefixes = other.getLearnedPrefixes();
        if (this$learnedPrefixes == null ? other$learnedPrefixes != null : !((Object)this$learnedPrefixes).equals(other$learnedPrefixes)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$localGatewayReference = this.getLocalGatewayReference();
        String other$localGatewayReference = other.getLocalGatewayReference();
        if (this$localGatewayReference == null ? other$localGatewayReference != null : !this$localGatewayReference.equals(other$localGatewayReference)) {
            return false;
        }
        String this$remoteGatewayReference = this.getRemoteGatewayReference();
        String other$remoteGatewayReference = other.getRemoteGatewayReference();
        if (this$remoteGatewayReference == null ? other$remoteGatewayReference != null : !this$remoteGatewayReference.equals(other$remoteGatewayReference)) {
            return false;
        }
        IpsecConfig this$ipsecConfig = this.getIpsecConfig();
        IpsecConfig other$ipsecConfig = other.getIpsecConfig();
        if (this$ipsecConfig == null ? other$ipsecConfig != null : !((Object)this$ipsecConfig).equals(other$ipsecConfig)) {
            return false;
        }
        DpdConfig this$dpdConfig = this.getDpdConfig();
        DpdConfig other$dpdConfig = other.getDpdConfig();
        if (this$dpdConfig == null ? other$dpdConfig != null : !((Object)this$dpdConfig).equals(other$dpdConfig)) {
            return false;
        }
        QosConfig this$qosConfig = this.getQosConfig();
        QosConfig other$qosConfig = other.getQosConfig();
        if (this$qosConfig == null ? other$qosConfig != null : !((Object)this$qosConfig).equals(other$qosConfig)) {
            return false;
        }
        GatewayRole this$localGatewayRole = this.getLocalGatewayRole();
        GatewayRole other$localGatewayRole = other.getLocalGatewayRole();
        if (this$localGatewayRole == null ? other$localGatewayRole != null : !((Object)((Object)this$localGatewayRole)).equals((Object)other$localGatewayRole)) {
            return false;
        }
        Integer this$dynamicRoutePriority = this.getDynamicRoutePriority();
        Integer other$dynamicRoutePriority = other.getDynamicRoutePriority();
        if (this$dynamicRoutePriority == null ? other$dynamicRoutePriority != null : !((Object)this$dynamicRoutePriority).equals(other$dynamicRoutePriority)) {
            return false;
        }
        Status this$ipsecTunnelStatus = this.getIpsecTunnelStatus();
        Status other$ipsecTunnelStatus = other.getIpsecTunnelStatus();
        if (this$ipsecTunnelStatus == null ? other$ipsecTunnelStatus != null : !((Object)this$ipsecTunnelStatus).equals(other$ipsecTunnelStatus)) {
            return false;
        }
        Status this$ebgpStatus = this.getEbgpStatus();
        Status other$ebgpStatus = other.getEbgpStatus();
        return !(this$ebgpStatus == null ? other$ebgpStatus != null : !((Object)this$ebgpStatus).equals(other$ebgpStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VpnConnection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<IPSubnet> $advertisedPrefixes = this.getAdvertisedPrefixes();
        result = result * 59 + ($advertisedPrefixes == null ? 43 : ((Object)$advertisedPrefixes).hashCode());
        List<IPSubnet> $learnedPrefixes = this.getLearnedPrefixes();
        result = result * 59 + ($learnedPrefixes == null ? 43 : ((Object)$learnedPrefixes).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $localGatewayReference = this.getLocalGatewayReference();
        result = result * 59 + ($localGatewayReference == null ? 43 : $localGatewayReference.hashCode());
        String $remoteGatewayReference = this.getRemoteGatewayReference();
        result = result * 59 + ($remoteGatewayReference == null ? 43 : $remoteGatewayReference.hashCode());
        IpsecConfig $ipsecConfig = this.getIpsecConfig();
        result = result * 59 + ($ipsecConfig == null ? 43 : ((Object)$ipsecConfig).hashCode());
        DpdConfig $dpdConfig = this.getDpdConfig();
        result = result * 59 + ($dpdConfig == null ? 43 : ((Object)$dpdConfig).hashCode());
        QosConfig $qosConfig = this.getQosConfig();
        result = result * 59 + ($qosConfig == null ? 43 : ((Object)$qosConfig).hashCode());
        GatewayRole $localGatewayRole = this.getLocalGatewayRole();
        result = result * 59 + ($localGatewayRole == null ? 43 : ((Object)((Object)$localGatewayRole)).hashCode());
        Integer $dynamicRoutePriority = this.getDynamicRoutePriority();
        result = result * 59 + ($dynamicRoutePriority == null ? 43 : ((Object)$dynamicRoutePriority).hashCode());
        Status $ipsecTunnelStatus = this.getIpsecTunnelStatus();
        result = result * 59 + ($ipsecTunnelStatus == null ? 43 : ((Object)$ipsecTunnelStatus).hashCode());
        Status $ebgpStatus = this.getEbgpStatus();
        result = result * 59 + ($ebgpStatus == null ? 43 : ((Object)$ebgpStatus).hashCode());
        return result;
    }

    public List<IPSubnet> getAdvertisedPrefixes() {
        return this.advertisedPrefixes;
    }

    public List<IPSubnet> getLearnedPrefixes() {
        return this.learnedPrefixes;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocalGatewayReference() {
        return this.localGatewayReference;
    }

    public String getRemoteGatewayReference() {
        return this.remoteGatewayReference;
    }

    public IpsecConfig getIpsecConfig() {
        return this.ipsecConfig;
    }

    public DpdConfig getDpdConfig() {
        return this.dpdConfig;
    }

    public QosConfig getQosConfig() {
        return this.qosConfig;
    }

    public GatewayRole getLocalGatewayRole() {
        return this.localGatewayRole;
    }

    public Integer getDynamicRoutePriority() {
        return this.dynamicRoutePriority;
    }

    public Status getIpsecTunnelStatus() {
        return this.ipsecTunnelStatus;
    }

    public Status getEbgpStatus() {
        return this.ebgpStatus;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="localGatewayReference")
    public void setLocalGatewayReference(String localGatewayReference) {
        this.localGatewayReference = localGatewayReference;
    }

    @JsonProperty(value="remoteGatewayReference")
    public void setRemoteGatewayReference(String remoteGatewayReference) {
        this.remoteGatewayReference = remoteGatewayReference;
    }

    @JsonProperty(value="ipsecConfig")
    public void setIpsecConfig(IpsecConfig ipsecConfig) {
        this.ipsecConfig = ipsecConfig;
    }

    @JsonProperty(value="dpdConfig")
    public void setDpdConfig(DpdConfig dpdConfig) {
        this.dpdConfig = dpdConfig;
    }

    @JsonProperty(value="qosConfig")
    public void setQosConfig(QosConfig qosConfig) {
        this.qosConfig = qosConfig;
    }

    @JsonProperty(value="localGatewayRole")
    public void setLocalGatewayRole(GatewayRole localGatewayRole) {
        this.localGatewayRole = localGatewayRole;
    }

    @JsonProperty(value="dynamicRoutePriority")
    public void setDynamicRoutePriority(Integer dynamicRoutePriority) {
        this.dynamicRoutePriority = dynamicRoutePriority;
    }

    @JsonProperty(value="ipsecTunnelStatus")
    public void setIpsecTunnelStatus(Status ipsecTunnelStatus) {
        this.ipsecTunnelStatus = ipsecTunnelStatus;
    }

    @JsonProperty(value="ebgpStatus")
    public void setEbgpStatus(Status ebgpStatus) {
        this.ebgpStatus = ebgpStatus;
    }

    @Override
    public String toString() {
        return "VpnConnection(advertisedPrefixes=" + this.getAdvertisedPrefixes() + ", learnedPrefixes=" + this.getLearnedPrefixes() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", localGatewayReference=" + this.getLocalGatewayReference() + ", remoteGatewayReference=" + this.getRemoteGatewayReference() + ", ipsecConfig=" + this.getIpsecConfig() + ", dpdConfig=" + this.getDpdConfig() + ", qosConfig=" + this.getQosConfig() + ", localGatewayRole=" + (Object)((Object)this.getLocalGatewayRole()) + ", dynamicRoutePriority=" + this.getDynamicRoutePriority() + ", ipsecTunnelStatus=" + this.getIpsecTunnelStatus() + ", ebgpStatus=" + this.getEbgpStatus() + ")";
    }

    public static class VpnConnectionBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private String localGatewayReference;
        private String remoteGatewayReference;
        private IpsecConfig ipsecConfig;
        private DpdConfig dpdConfig;
        private QosConfig qosConfig;
        private GatewayRole localGatewayRole;
        private Integer dynamicRoutePriority;
        private List<IPSubnet> advertisedPrefixes;
        private List<IPSubnet> learnedPrefixes;
        private Status ipsecTunnelStatus;
        private Status ebgpStatus;

        VpnConnectionBuilder() {
        }

        public VpnConnectionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VpnConnectionBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VpnConnectionBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VpnConnectionBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public VpnConnectionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VpnConnectionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VpnConnectionBuilder localGatewayReference(String localGatewayReference) {
            this.localGatewayReference = localGatewayReference;
            return this;
        }

        public VpnConnectionBuilder remoteGatewayReference(String remoteGatewayReference) {
            this.remoteGatewayReference = remoteGatewayReference;
            return this;
        }

        public VpnConnectionBuilder ipsecConfig(IpsecConfig ipsecConfig) {
            this.ipsecConfig = ipsecConfig;
            return this;
        }

        public VpnConnectionBuilder dpdConfig(DpdConfig dpdConfig) {
            this.dpdConfig = dpdConfig;
            return this;
        }

        public VpnConnectionBuilder qosConfig(QosConfig qosConfig) {
            this.qosConfig = qosConfig;
            return this;
        }

        public VpnConnectionBuilder localGatewayRole(GatewayRole localGatewayRole) {
            this.localGatewayRole = localGatewayRole;
            return this;
        }

        public VpnConnectionBuilder dynamicRoutePriority(Integer dynamicRoutePriority) {
            this.dynamicRoutePriority = dynamicRoutePriority;
            return this;
        }

        public VpnConnectionBuilder advertisedPrefixes(List<IPSubnet> advertisedPrefixes) {
            this.advertisedPrefixes = advertisedPrefixes;
            return this;
        }

        public VpnConnectionBuilder learnedPrefixes(List<IPSubnet> learnedPrefixes) {
            this.learnedPrefixes = learnedPrefixes;
            return this;
        }

        public VpnConnectionBuilder ipsecTunnelStatus(Status ipsecTunnelStatus) {
            this.ipsecTunnelStatus = ipsecTunnelStatus;
            return this;
        }

        public VpnConnectionBuilder ebgpStatus(Status ebgpStatus) {
            this.ebgpStatus = ebgpStatus;
            return this;
        }

        public VpnConnection build() {
            return new VpnConnection(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.localGatewayReference, this.remoteGatewayReference, this.ipsecConfig, this.dpdConfig, this.qosConfig, this.localGatewayRole, this.dynamicRoutePriority, this.advertisedPrefixes, this.learnedPrefixes, this.ipsecTunnelStatus, this.ebgpStatus);
        }

        public String toString() {
            return "VpnConnection.VpnConnectionBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", localGatewayReference=" + this.localGatewayReference + ", remoteGatewayReference=" + this.remoteGatewayReference + ", ipsecConfig=" + this.ipsecConfig + ", dpdConfig=" + this.dpdConfig + ", qosConfig=" + this.qosConfig + ", localGatewayRole=" + (Object)((Object)this.localGatewayRole) + ", dynamicRoutePriority=" + this.dynamicRoutePriority + ", advertisedPrefixes=" + this.advertisedPrefixes + ", learnedPrefixes=" + this.learnedPrefixes + ", ipsecTunnelStatus=" + this.ipsecTunnelStatus + ", ebgpStatus=" + this.ebgpStatus + ")";
        }
    }
}

