/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.stats;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.common.v1.stats.DownSamplingOperator;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.stats.ListenerStats;
import com.nutanix.dp1.net.networking.v4.stats.StatsQueryResponseBase;
import com.nutanix.dp1.net.networking.v4.stats.TargetStats;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerSessionStats
extends StatsQueryResponseBase
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(LoadBalancerSessionStats.class);
    @Size(min=0, max=2)
    @JsonProperty(value="listenerStats")
    public @Size(min=0, max=2) List<ListenerStats> listenerStats = null;
    @Size(min=0, max=32)
    @JsonProperty(value="targetStats")
    public @Size(min=0, max=32) List<TargetStats> targetStats = null;

    public LoadBalancerSessionStats() {
    }

    public LoadBalancerSessionStats(String tenantId, String extId, List<ApiLink> links, DownSamplingOperator statType, List<ListenerStats> listenerStats, List<TargetStats> targetStats) {
        super(tenantId, extId, links, statType);
        this.setListenerStats(listenerStats);
        this.setTargetStats(targetStats);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.stats.LoadBalancerSessionStats";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static LoadBalancerSessionStatsBuilder LoadBalancerSessionStatsBuilder() {
        return new LoadBalancerSessionStatsBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadBalancerSessionStats)) {
            return false;
        }
        LoadBalancerSessionStats other = (LoadBalancerSessionStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<ListenerStats> this$listenerStats = this.getListenerStats();
        List<ListenerStats> other$listenerStats = other.getListenerStats();
        if (this$listenerStats == null ? other$listenerStats != null : !((Object)this$listenerStats).equals(other$listenerStats)) {
            return false;
        }
        List<TargetStats> this$targetStats = this.getTargetStats();
        List<TargetStats> other$targetStats = other.getTargetStats();
        return !(this$targetStats == null ? other$targetStats != null : !((Object)this$targetStats).equals(other$targetStats));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LoadBalancerSessionStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<ListenerStats> $listenerStats = this.getListenerStats();
        result = result * 59 + ($listenerStats == null ? 43 : ((Object)$listenerStats).hashCode());
        List<TargetStats> $targetStats = this.getTargetStats();
        result = result * 59 + ($targetStats == null ? 43 : ((Object)$targetStats).hashCode());
        return result;
    }

    public List<ListenerStats> getListenerStats() {
        return this.listenerStats;
    }

    public List<TargetStats> getTargetStats() {
        return this.targetStats;
    }

    @JsonProperty(value="listenerStats")
    public void setListenerStats(List<ListenerStats> listenerStats) {
        this.listenerStats = listenerStats;
    }

    @JsonProperty(value="targetStats")
    public void setTargetStats(List<TargetStats> targetStats) {
        this.targetStats = targetStats;
    }

    @Override
    public String toString() {
        return "LoadBalancerSessionStats(listenerStats=" + this.getListenerStats() + ", targetStats=" + this.getTargetStats() + ")";
    }

    public static class LoadBalancerSessionStatsBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private DownSamplingOperator statType;
        private List<ListenerStats> listenerStats;
        private List<TargetStats> targetStats;

        LoadBalancerSessionStatsBuilder() {
        }

        public LoadBalancerSessionStatsBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public LoadBalancerSessionStatsBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public LoadBalancerSessionStatsBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public LoadBalancerSessionStatsBuilder statType(DownSamplingOperator statType) {
            this.statType = statType;
            return this;
        }

        public LoadBalancerSessionStatsBuilder listenerStats(List<ListenerStats> listenerStats) {
            this.listenerStats = listenerStats;
            return this;
        }

        public LoadBalancerSessionStatsBuilder targetStats(List<TargetStats> targetStats) {
            this.targetStats = targetStats;
            return this;
        }

        public LoadBalancerSessionStats build() {
            return new LoadBalancerSessionStats(this.tenantId, this.extId, this.links, this.statType, this.listenerStats, this.targetStats);
        }

        public String toString() {
            return "LoadBalancerSessionStats.LoadBalancerSessionStatsBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", statType=" + (Object)((Object)this.statType) + ", listenerStats=" + this.listenerStats + ", targetStats=" + this.targetStats + ")";
        }
    }
}

