/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.stats;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.common.v1.stats.DownSamplingOperator;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.stats.StatsQueryResponseBase;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficMirrorStats
extends StatsQueryResponseBase
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(TrafficMirrorStats.class);
    @Size(min=0, max=7000)
    @JsonProperty(value="transmitPacketCount")
    public @Size(min=0, max=7000) List<Long> transmitPacketCount = null;
    @Size(min=0, max=7000)
    @JsonProperty(value="transmitByteCount")
    public @Size(min=0, max=7000) List<Long> transmitByteCount = null;

    public TrafficMirrorStats() {
    }

    public TrafficMirrorStats(String tenantId, String extId, List<ApiLink> links, DownSamplingOperator statType, List<Long> transmitPacketCount, List<Long> transmitByteCount) {
        super(tenantId, extId, links, statType);
        this.setTransmitPacketCount(transmitPacketCount);
        this.setTransmitByteCount(transmitByteCount);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.stats.TrafficMirrorStats";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static TrafficMirrorStatsBuilder TrafficMirrorStatsBuilder() {
        return new TrafficMirrorStatsBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrafficMirrorStats)) {
            return false;
        }
        TrafficMirrorStats other = (TrafficMirrorStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Long> this$transmitPacketCount = this.getTransmitPacketCount();
        List<Long> other$transmitPacketCount = other.getTransmitPacketCount();
        if (this$transmitPacketCount == null ? other$transmitPacketCount != null : !((Object)this$transmitPacketCount).equals(other$transmitPacketCount)) {
            return false;
        }
        List<Long> this$transmitByteCount = this.getTransmitByteCount();
        List<Long> other$transmitByteCount = other.getTransmitByteCount();
        return !(this$transmitByteCount == null ? other$transmitByteCount != null : !((Object)this$transmitByteCount).equals(other$transmitByteCount));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TrafficMirrorStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Long> $transmitPacketCount = this.getTransmitPacketCount();
        result = result * 59 + ($transmitPacketCount == null ? 43 : ((Object)$transmitPacketCount).hashCode());
        List<Long> $transmitByteCount = this.getTransmitByteCount();
        result = result * 59 + ($transmitByteCount == null ? 43 : ((Object)$transmitByteCount).hashCode());
        return result;
    }

    public List<Long> getTransmitPacketCount() {
        return this.transmitPacketCount;
    }

    public List<Long> getTransmitByteCount() {
        return this.transmitByteCount;
    }

    @JsonProperty(value="transmitPacketCount")
    public void setTransmitPacketCount(List<Long> transmitPacketCount) {
        this.transmitPacketCount = transmitPacketCount;
    }

    @JsonProperty(value="transmitByteCount")
    public void setTransmitByteCount(List<Long> transmitByteCount) {
        this.transmitByteCount = transmitByteCount;
    }

    @Override
    public String toString() {
        return "TrafficMirrorStats(transmitPacketCount=" + this.getTransmitPacketCount() + ", transmitByteCount=" + this.getTransmitByteCount() + ")";
    }

    public static class TrafficMirrorStatsBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private DownSamplingOperator statType;
        private List<Long> transmitPacketCount;
        private List<Long> transmitByteCount;

        TrafficMirrorStatsBuilder() {
        }

        public TrafficMirrorStatsBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public TrafficMirrorStatsBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public TrafficMirrorStatsBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public TrafficMirrorStatsBuilder statType(DownSamplingOperator statType) {
            this.statType = statType;
            return this;
        }

        public TrafficMirrorStatsBuilder transmitPacketCount(List<Long> transmitPacketCount) {
            this.transmitPacketCount = transmitPacketCount;
            return this;
        }

        public TrafficMirrorStatsBuilder transmitByteCount(List<Long> transmitByteCount) {
            this.transmitByteCount = transmitByteCount;
            return this;
        }

        public TrafficMirrorStats build() {
            return new TrafficMirrorStats(this.tenantId, this.extId, this.links, this.statType, this.transmitPacketCount, this.transmitByteCount);
        }

        public String toString() {
            return "TrafficMirrorStats.TrafficMirrorStatsBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", statType=" + (Object)((Object)this.statType) + ", transmitPacketCount=" + this.transmitPacketCount + ", transmitByteCount=" + this.transmitByteCount + ")";
        }
    }
}

