/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.stats;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.common.v1.stats.DownSamplingOperator;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.stats.StatsQueryResponseBase;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VpnConnectionStats
extends StatsQueryResponseBase
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VpnConnectionStats.class);
    @Size(min=0, max=8500)
    @JsonProperty(value="throughputRxKbps")
    public @Size(min=0, max=8500) List<String> throughputRxKbps = null;
    @Size(min=0, max=8500)
    @JsonProperty(value="throughputTxKbps")
    public @Size(min=0, max=8500) List<String> throughputTxKbps = null;

    public VpnConnectionStats() {
    }

    public VpnConnectionStats(String tenantId, String extId, List<ApiLink> links, DownSamplingOperator statType, List<String> throughputRxKbps, List<String> throughputTxKbps) {
        super(tenantId, extId, links, statType);
        this.setThroughputRxKbps(throughputRxKbps);
        this.setThroughputTxKbps(throughputTxKbps);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.stats.VpnConnectionStats";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static VpnConnectionStatsBuilder VpnConnectionStatsBuilder() {
        return new VpnConnectionStatsBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VpnConnectionStats)) {
            return false;
        }
        VpnConnectionStats other = (VpnConnectionStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$throughputRxKbps = this.getThroughputRxKbps();
        List<String> other$throughputRxKbps = other.getThroughputRxKbps();
        if (this$throughputRxKbps == null ? other$throughputRxKbps != null : !((Object)this$throughputRxKbps).equals(other$throughputRxKbps)) {
            return false;
        }
        List<String> this$throughputTxKbps = this.getThroughputTxKbps();
        List<String> other$throughputTxKbps = other.getThroughputTxKbps();
        return !(this$throughputTxKbps == null ? other$throughputTxKbps != null : !((Object)this$throughputTxKbps).equals(other$throughputTxKbps));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VpnConnectionStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $throughputRxKbps = this.getThroughputRxKbps();
        result = result * 59 + ($throughputRxKbps == null ? 43 : ((Object)$throughputRxKbps).hashCode());
        List<String> $throughputTxKbps = this.getThroughputTxKbps();
        result = result * 59 + ($throughputTxKbps == null ? 43 : ((Object)$throughputTxKbps).hashCode());
        return result;
    }

    public List<String> getThroughputRxKbps() {
        return this.throughputRxKbps;
    }

    public List<String> getThroughputTxKbps() {
        return this.throughputTxKbps;
    }

    @JsonProperty(value="throughputRxKbps")
    public void setThroughputRxKbps(List<String> throughputRxKbps) {
        this.throughputRxKbps = throughputRxKbps;
    }

    @JsonProperty(value="throughputTxKbps")
    public void setThroughputTxKbps(List<String> throughputTxKbps) {
        this.throughputTxKbps = throughputTxKbps;
    }

    @Override
    public String toString() {
        return "VpnConnectionStats(throughputRxKbps=" + this.getThroughputRxKbps() + ", throughputTxKbps=" + this.getThroughputTxKbps() + ")";
    }

    public static class VpnConnectionStatsBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private DownSamplingOperator statType;
        private List<String> throughputRxKbps;
        private List<String> throughputTxKbps;

        VpnConnectionStatsBuilder() {
        }

        public VpnConnectionStatsBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VpnConnectionStatsBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VpnConnectionStatsBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VpnConnectionStatsBuilder statType(DownSamplingOperator statType) {
            this.statType = statType;
            return this;
        }

        public VpnConnectionStatsBuilder throughputRxKbps(List<String> throughputRxKbps) {
            this.throughputRxKbps = throughputRxKbps;
            return this;
        }

        public VpnConnectionStatsBuilder throughputTxKbps(List<String> throughputTxKbps) {
            this.throughputTxKbps = throughputTxKbps;
            return this;
        }

        public VpnConnectionStats build() {
            return new VpnConnectionStats(this.tenantId, this.extId, this.links, this.statType, this.throughputRxKbps, this.throughputTxKbps);
        }

        public String toString() {
            return "VpnConnectionStats.VpnConnectionStatsBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", statType=" + (Object)((Object)this.statType) + ", throughputRxKbps=" + this.throughputRxKbps + ", throughputTxKbps=" + this.throughputTxKbps + ")";
        }
    }
}

