/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.net.java.client.api;

import com.nutanix.dp1.net.networking.v4.config.ListNodeSchedulableStatusesApiResponse;
import com.nutanix.net.java.client.ApiClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.net.java.client.api.VirtualSwitchNodesInfoApi")
public class VirtualSwitchNodesInfoApi {
    private static final Logger log = LoggerFactory.getLogger(VirtualSwitchNodesInfoApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public VirtualSwitchNodesInfoApi() {
        this(new ApiClient());
    }

    @Autowired
    public VirtualSwitchNodesInfoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ListNodeSchedulableStatusesApiResponse listNodeSchedulableStatus(String xClusterId, Integer $page, Integer $limit, String $filter, String $orderby, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/networking/v4.0/config/node-schedulable-statuses").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$page", $page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$filter", $filter));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$orderby", $orderby));
        if (xClusterId != null) {
            headerParams.add("X-Cluster-Id", this.apiClient.parameterToString(xClusterId));
        }
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ListNodeSchedulableStatusesApiResponse> returnType = new ParameterizedTypeReference<ListNodeSchedulableStatusesApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

