/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.net.java.client.api;

import com.nutanix.dp1.net.networking.v4.config.GetVpnConnectionApiResponse;
import com.nutanix.dp1.net.networking.v4.config.ListVpnConnectionsApiResponse;
import com.nutanix.dp1.net.networking.v4.config.ListVpnVendorConfigsApiResponse;
import com.nutanix.dp1.net.networking.v4.config.TaskReferenceApiResponse;
import com.nutanix.dp1.net.networking.v4.config.VpnConnection;
import com.nutanix.net.java.client.ApiClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.net.java.client.api.VpnConnectionsApi")
public class VpnConnectionsApi {
    private static final Logger log = LoggerFactory.getLogger(VpnConnectionsApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public VpnConnectionsApi() {
        this(new ApiClient());
    }

    @Autowired
    public VpnConnectionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TaskReferenceApiResponse createVpnConnection(VpnConnection body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        VpnConnection postBody = body;
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling createVpnConnection");
        }
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/networking/v4.0/config/vpn-connections").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<TaskReferenceApiResponse> returnType = new ParameterizedTypeReference<TaskReferenceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public TaskReferenceApiResponse deleteVpnConnectionById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling deleteVpnConnectionById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/networking/v4.0/config/vpn-connections/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<TaskReferenceApiResponse> returnType = new ParameterizedTypeReference<TaskReferenceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.DELETE, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public String getVpnApplianceForVpnConnectionById(String vpnConnectionExtId, String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (vpnConnectionExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'vpnConnectionExtId' when calling getVpnApplianceForVpnConnectionById");
        }
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getVpnApplianceForVpnConnectionById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("vpnConnectionExtId", vpnConnectionExtId);
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/networking/v4.0/config/vpn-connections/{vpnConnectionExtId}/vpn-vendor-configs/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"text/plain", "application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<String> returnType = new ParameterizedTypeReference<String>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetVpnConnectionApiResponse getVpnConnectionById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getVpnConnectionById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/networking/v4.0/config/vpn-connections/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<GetVpnConnectionApiResponse> returnType = new ParameterizedTypeReference<GetVpnConnectionApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ListVpnVendorConfigsApiResponse listVpnAppliancesByVpnConnectionId(String vpnConnectionExtId, Integer $page, Integer $limit, String $filter, String $orderby, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (vpnConnectionExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'vpnConnectionExtId' when calling listVpnAppliancesByVpnConnectionId");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("vpnConnectionExtId", vpnConnectionExtId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/networking/v4.0/config/vpn-connections/{vpnConnectionExtId}/vpn-vendor-configs").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$page", $page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$filter", $filter));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$orderby", $orderby));
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ListVpnVendorConfigsApiResponse> returnType = new ParameterizedTypeReference<ListVpnVendorConfigsApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ListVpnConnectionsApiResponse listVpnConnections(Integer $page, Integer $limit, String $filter, String $orderby, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/networking/v4.0/config/vpn-connections").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$page", $page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$filter", $filter));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$orderby", $orderby));
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ListVpnConnectionsApiResponse> returnType = new ParameterizedTypeReference<ListVpnConnectionsApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public TaskReferenceApiResponse updateVpnConnectionById(String extId, VpnConnection body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        VpnConnection postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling updateVpnConnectionById");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling updateVpnConnectionById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/networking/v4.0/config/vpn-connections/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<TaskReferenceApiResponse> returnType = new ParameterizedTypeReference<TaskReferenceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.PUT, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

