/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.obj.objects.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.obj.common.v1.config.IPAddress;
import com.nutanix.dp1.obj.common.v1.config.Metadata;
import com.nutanix.dp1.obj.common.v1.response.ApiLink;
import com.nutanix.dp1.obj.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.obj.deserializers.ObjObjectTypeTypedObject;
import com.nutanix.dp1.obj.objects.v4.config.State;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStore
extends ExternalizableAbstractModel
implements Serializable,
ObjObjectTypeTypedObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectStore.class);
    private OffsetDateTime creationTime = null;
    private OffsetDateTime lastUpdateTime = null;
    @Size(min=1, max=100)
    private @Size(min=1, max=100) List<String> certificateExtIds = null;
    @JsonProperty(value="metadata")
    public Metadata metadata = null;
    @Pattern(regexp="^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9-]*[a-zA-Z0-9]))*([A-Za-z]|[A-Za-z][A-Za-z0-9-]*[A-Za-z0-9])$")
    @Size(min=1, max=50)
    @JsonProperty(value="name")
    public @Pattern(regexp="^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9-]*[a-zA-Z0-9]))*([A-Za-z]|[A-Za-z][A-Za-z0-9-]*[A-Za-z0-9])$") @Size(min=1, max=50) String name = null;
    @Size(min=0, max=1000)
    @JsonProperty(value="description")
    public @Size(min=0, max=1000) String description = null;
    @Pattern(regexp="^[a-zA-z0-9][a-zA-z0-9\\.]*[a-zA-Z0-9]?$")
    @Size(min=1, max=50)
    @JsonProperty(value="deploymentVersion")
    public @Pattern(regexp="^[a-zA-z0-9][a-zA-z0-9\\.]*[a-zA-Z0-9]?$") @Size(min=1, max=50) String deploymentVersion = null;
    @Pattern(regexp="^(([a-zA-Z0-9_\\-]{1,63})\\.)+([a-zA-Z0-9_\\-]{1,63})$")
    @Size(min=1, max=1000)
    @JsonProperty(value="domain")
    public @Pattern(regexp="^(([a-zA-Z0-9_\\-]{1,63})\\.)+([a-zA-Z0-9_\\-]{1,63})$") @Size(min=1, max=1000) String domain = null;
    @Pattern(regexp="^[a-z]+\\-[a-z]+\\-[0-9]$")
    @Size(min=1, max=50)
    @JsonProperty(value="region")
    public @Pattern(regexp="^[a-z]+\\-[a-z]+\\-[0-9]$") @Size(min=1, max=50) String region = null;
    @Max(value=1000L)
    @Min(value=1L)
    @JsonProperty(value="numWorkerNodes")
    public @Max(value=1000L) @Min(value=1L) Long numWorkerNodes = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterExtId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterExtId = null;
    @Size(min=0, max=1000)
    @JsonProperty(value="storageNetworkReference")
    public @Size(min=0, max=1000) String storageNetworkReference = null;
    @JsonProperty(value="storageNetworkVip")
    public IPAddress storageNetworkVip = null;
    @JsonProperty(value="storageNetworkDnsIp")
    public IPAddress storageNetworkDnsIp = null;
    @Size(min=0, max=1000)
    @JsonProperty(value="publicNetworkReference")
    public @Size(min=0, max=1000) String publicNetworkReference = null;
    @Size(min=1, max=1000)
    @JsonProperty(value="publicNetworkIps")
    public @Size(min=1, max=1000) List<IPAddress> publicNetworkIps = null;
    @Max(value=178814713856L)
    @Min(value=1L)
    @JsonProperty(value="totalCapacityGiB")
    public @Max(value=178814713856L) @Min(value=1L) Long totalCapacityGiB = null;
    @JsonProperty(value="state")
    public State state = null;

    public ObjectStore() {
    }

    public ObjectStore(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, OffsetDateTime creationTime, OffsetDateTime lastUpdateTime, String description, String deploymentVersion, String domain, String region, Long numWorkerNodes, String clusterExtId, String storageNetworkReference, IPAddress storageNetworkVip, IPAddress storageNetworkDnsIp, String publicNetworkReference, List<IPAddress> publicNetworkIps, Long totalCapacityGiB, State state, List<String> certificateExtIds) {
        super(tenantId, extId, links);
        this.setMetadata(metadata);
        this.setName(name);
        this.setCreationTime(creationTime);
        this.setLastUpdateTime(lastUpdateTime);
        this.setDescription(description);
        this.setDeploymentVersion(deploymentVersion);
        this.setDomain(domain);
        this.setRegion(region);
        this.setNumWorkerNodes(numWorkerNodes);
        this.setClusterExtId(clusterExtId);
        this.setStorageNetworkReference(storageNetworkReference);
        this.setStorageNetworkVip(storageNetworkVip);
        this.setStorageNetworkDnsIp(storageNetworkDnsIp);
        this.setPublicNetworkReference(publicNetworkReference);
        this.setPublicNetworkIps(publicNetworkIps);
        this.setTotalCapacityGiB(totalCapacityGiB);
        this.setState(state);
        this.setCertificateExtIds(certificateExtIds);
    }

    @Override
    protected String initialize$objectType() {
        return "objects.v4.config.ObjectStore";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreationTime(OffsetDateTime creationTime) {
        if (this.creationTime == null) {
            this.creationTime = creationTime;
        } else {
            log.warn("Read-only property creationTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        if (this.lastUpdateTime == null) {
            this.lastUpdateTime = lastUpdateTime;
        } else {
            log.warn("Read-only property lastUpdateTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCertificateExtIds(List<String> certificateExtIds) {
        if (this.certificateExtIds == null) {
            this.certificateExtIds = certificateExtIds;
        } else {
            log.warn("Read-only property certificateExtIds already contains a non-null value and cannot be set again");
        }
    }

    @Generated
    public static ObjectStoreBuilder ObjectStoreBuilder() {
        return new ObjectStoreBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectStore)) {
            return false;
        }
        ObjectStore other = (ObjectStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$numWorkerNodes = this.getNumWorkerNodes();
        Long other$numWorkerNodes = other.getNumWorkerNodes();
        if (this$numWorkerNodes == null ? other$numWorkerNodes != null : !((Object)this$numWorkerNodes).equals(other$numWorkerNodes)) {
            return false;
        }
        Long this$totalCapacityGiB = this.getTotalCapacityGiB();
        Long other$totalCapacityGiB = other.getTotalCapacityGiB();
        if (this$totalCapacityGiB == null ? other$totalCapacityGiB != null : !((Object)this$totalCapacityGiB).equals(other$totalCapacityGiB)) {
            return false;
        }
        OffsetDateTime this$creationTime = this.getCreationTime();
        OffsetDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdateTime = this.getLastUpdateTime();
        OffsetDateTime other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        List<String> this$certificateExtIds = this.getCertificateExtIds();
        List<String> other$certificateExtIds = other.getCertificateExtIds();
        if (this$certificateExtIds == null ? other$certificateExtIds != null : !((Object)this$certificateExtIds).equals(other$certificateExtIds)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deploymentVersion = this.getDeploymentVersion();
        String other$deploymentVersion = other.getDeploymentVersion();
        if (this$deploymentVersion == null ? other$deploymentVersion != null : !this$deploymentVersion.equals(other$deploymentVersion)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$clusterExtId = this.getClusterExtId();
        String other$clusterExtId = other.getClusterExtId();
        if (this$clusterExtId == null ? other$clusterExtId != null : !this$clusterExtId.equals(other$clusterExtId)) {
            return false;
        }
        String this$storageNetworkReference = this.getStorageNetworkReference();
        String other$storageNetworkReference = other.getStorageNetworkReference();
        if (this$storageNetworkReference == null ? other$storageNetworkReference != null : !this$storageNetworkReference.equals(other$storageNetworkReference)) {
            return false;
        }
        IPAddress this$storageNetworkVip = this.getStorageNetworkVip();
        IPAddress other$storageNetworkVip = other.getStorageNetworkVip();
        if (this$storageNetworkVip == null ? other$storageNetworkVip != null : !((Object)this$storageNetworkVip).equals(other$storageNetworkVip)) {
            return false;
        }
        IPAddress this$storageNetworkDnsIp = this.getStorageNetworkDnsIp();
        IPAddress other$storageNetworkDnsIp = other.getStorageNetworkDnsIp();
        if (this$storageNetworkDnsIp == null ? other$storageNetworkDnsIp != null : !((Object)this$storageNetworkDnsIp).equals(other$storageNetworkDnsIp)) {
            return false;
        }
        String this$publicNetworkReference = this.getPublicNetworkReference();
        String other$publicNetworkReference = other.getPublicNetworkReference();
        if (this$publicNetworkReference == null ? other$publicNetworkReference != null : !this$publicNetworkReference.equals(other$publicNetworkReference)) {
            return false;
        }
        List<IPAddress> this$publicNetworkIps = this.getPublicNetworkIps();
        List<IPAddress> other$publicNetworkIps = other.getPublicNetworkIps();
        if (this$publicNetworkIps == null ? other$publicNetworkIps != null : !((Object)this$publicNetworkIps).equals(other$publicNetworkIps)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ObjectStore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $numWorkerNodes = this.getNumWorkerNodes();
        result = result * 59 + ($numWorkerNodes == null ? 43 : ((Object)$numWorkerNodes).hashCode());
        Long $totalCapacityGiB = this.getTotalCapacityGiB();
        result = result * 59 + ($totalCapacityGiB == null ? 43 : ((Object)$totalCapacityGiB).hashCode());
        OffsetDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        OffsetDateTime $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        List<String> $certificateExtIds = this.getCertificateExtIds();
        result = result * 59 + ($certificateExtIds == null ? 43 : ((Object)$certificateExtIds).hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deploymentVersion = this.getDeploymentVersion();
        result = result * 59 + ($deploymentVersion == null ? 43 : $deploymentVersion.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $clusterExtId = this.getClusterExtId();
        result = result * 59 + ($clusterExtId == null ? 43 : $clusterExtId.hashCode());
        String $storageNetworkReference = this.getStorageNetworkReference();
        result = result * 59 + ($storageNetworkReference == null ? 43 : $storageNetworkReference.hashCode());
        IPAddress $storageNetworkVip = this.getStorageNetworkVip();
        result = result * 59 + ($storageNetworkVip == null ? 43 : ((Object)$storageNetworkVip).hashCode());
        IPAddress $storageNetworkDnsIp = this.getStorageNetworkDnsIp();
        result = result * 59 + ($storageNetworkDnsIp == null ? 43 : ((Object)$storageNetworkDnsIp).hashCode());
        String $publicNetworkReference = this.getPublicNetworkReference();
        result = result * 59 + ($publicNetworkReference == null ? 43 : $publicNetworkReference.hashCode());
        List<IPAddress> $publicNetworkIps = this.getPublicNetworkIps();
        result = result * 59 + ($publicNetworkIps == null ? 43 : ((Object)$publicNetworkIps).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    @Generated
    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public List<String> getCertificateExtIds() {
        return this.certificateExtIds;
    }

    @Generated
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDeploymentVersion() {
        return this.deploymentVersion;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public Long getNumWorkerNodes() {
        return this.numWorkerNodes;
    }

    @Generated
    public String getClusterExtId() {
        return this.clusterExtId;
    }

    @Generated
    public String getStorageNetworkReference() {
        return this.storageNetworkReference;
    }

    @Generated
    public IPAddress getStorageNetworkVip() {
        return this.storageNetworkVip;
    }

    @Generated
    public IPAddress getStorageNetworkDnsIp() {
        return this.storageNetworkDnsIp;
    }

    @Generated
    public String getPublicNetworkReference() {
        return this.publicNetworkReference;
    }

    @Generated
    public List<IPAddress> getPublicNetworkIps() {
        return this.publicNetworkIps;
    }

    @Generated
    public Long getTotalCapacityGiB() {
        return this.totalCapacityGiB;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @JsonProperty(value="metadata")
    @Generated
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="deploymentVersion")
    @Generated
    public void setDeploymentVersion(String deploymentVersion) {
        this.deploymentVersion = deploymentVersion;
    }

    @JsonProperty(value="domain")
    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty(value="region")
    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @JsonProperty(value="numWorkerNodes")
    @Generated
    public void setNumWorkerNodes(Long numWorkerNodes) {
        this.numWorkerNodes = numWorkerNodes;
    }

    @JsonProperty(value="clusterExtId")
    @Generated
    public void setClusterExtId(String clusterExtId) {
        this.clusterExtId = clusterExtId;
    }

    @JsonProperty(value="storageNetworkReference")
    @Generated
    public void setStorageNetworkReference(String storageNetworkReference) {
        this.storageNetworkReference = storageNetworkReference;
    }

    @JsonProperty(value="storageNetworkVip")
    @Generated
    public void setStorageNetworkVip(IPAddress storageNetworkVip) {
        this.storageNetworkVip = storageNetworkVip;
    }

    @JsonProperty(value="storageNetworkDnsIp")
    @Generated
    public void setStorageNetworkDnsIp(IPAddress storageNetworkDnsIp) {
        this.storageNetworkDnsIp = storageNetworkDnsIp;
    }

    @JsonProperty(value="publicNetworkReference")
    @Generated
    public void setPublicNetworkReference(String publicNetworkReference) {
        this.publicNetworkReference = publicNetworkReference;
    }

    @JsonProperty(value="publicNetworkIps")
    @Generated
    public void setPublicNetworkIps(List<IPAddress> publicNetworkIps) {
        this.publicNetworkIps = publicNetworkIps;
    }

    @JsonProperty(value="totalCapacityGiB")
    @Generated
    public void setTotalCapacityGiB(Long totalCapacityGiB) {
        this.totalCapacityGiB = totalCapacityGiB;
    }

    @JsonProperty(value="state")
    @Generated
    public void setState(State state) {
        this.state = state;
    }

    @Override
    @Generated
    public String toString() {
        return "ObjectStore(creationTime=" + this.getCreationTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", certificateExtIds=" + this.getCertificateExtIds() + ", metadata=" + this.getMetadata() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", deploymentVersion=" + this.getDeploymentVersion() + ", domain=" + this.getDomain() + ", region=" + this.getRegion() + ", numWorkerNodes=" + this.getNumWorkerNodes() + ", clusterExtId=" + this.getClusterExtId() + ", storageNetworkReference=" + this.getStorageNetworkReference() + ", storageNetworkVip=" + this.getStorageNetworkVip() + ", storageNetworkDnsIp=" + this.getStorageNetworkDnsIp() + ", publicNetworkReference=" + this.getPublicNetworkReference() + ", publicNetworkIps=" + this.getPublicNetworkIps() + ", totalCapacityGiB=" + this.getTotalCapacityGiB() + ", state=" + (Object)((Object)this.getState()) + ")";
    }

    public static class ObjectStoreBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String extId;
        @Generated
        private List<ApiLink> links;
        @Generated
        private Metadata metadata;
        @Generated
        private String name;
        @Generated
        private OffsetDateTime creationTime;
        @Generated
        private OffsetDateTime lastUpdateTime;
        @Generated
        private String description;
        @Generated
        private String deploymentVersion;
        @Generated
        private String domain;
        @Generated
        private String region;
        @Generated
        private Long numWorkerNodes;
        @Generated
        private String clusterExtId;
        @Generated
        private String storageNetworkReference;
        @Generated
        private IPAddress storageNetworkVip;
        @Generated
        private IPAddress storageNetworkDnsIp;
        @Generated
        private String publicNetworkReference;
        @Generated
        private List<IPAddress> publicNetworkIps;
        @Generated
        private Long totalCapacityGiB;
        @Generated
        private State state;
        @Generated
        private List<String> certificateExtIds;
        protected final Map<String, Object> $reserved = new LinkedHashMap<String, Object>();

        public ObjectStoreBuilder addToReservedMap(String key, Object value) {
            this.$reserved.put(key, value);
            return this;
        }

        public ObjectStore build() {
            ObjectStore obj = new ObjectStore(this.tenantId, this.extId, this.links, this.metadata, this.name, this.creationTime, this.lastUpdateTime, this.description, this.deploymentVersion, this.domain, this.region, this.numWorkerNodes, this.clusterExtId, this.storageNetworkReference, this.storageNetworkVip, this.storageNetworkDnsIp, this.publicNetworkReference, this.publicNetworkIps, this.totalCapacityGiB, this.state, this.certificateExtIds);
            obj.$reserved.putAll(this.$reserved);
            return obj;
        }

        @Generated
        ObjectStoreBuilder() {
        }

        @Generated
        public ObjectStoreBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public ObjectStoreBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        @Generated
        public ObjectStoreBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        @Generated
        public ObjectStoreBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public ObjectStoreBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ObjectStoreBuilder creationTime(OffsetDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Generated
        public ObjectStoreBuilder lastUpdateTime(OffsetDateTime lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public ObjectStoreBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ObjectStoreBuilder deploymentVersion(String deploymentVersion) {
            this.deploymentVersion = deploymentVersion;
            return this;
        }

        @Generated
        public ObjectStoreBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public ObjectStoreBuilder region(String region) {
            this.region = region;
            return this;
        }

        @Generated
        public ObjectStoreBuilder numWorkerNodes(Long numWorkerNodes) {
            this.numWorkerNodes = numWorkerNodes;
            return this;
        }

        @Generated
        public ObjectStoreBuilder clusterExtId(String clusterExtId) {
            this.clusterExtId = clusterExtId;
            return this;
        }

        @Generated
        public ObjectStoreBuilder storageNetworkReference(String storageNetworkReference) {
            this.storageNetworkReference = storageNetworkReference;
            return this;
        }

        @Generated
        public ObjectStoreBuilder storageNetworkVip(IPAddress storageNetworkVip) {
            this.storageNetworkVip = storageNetworkVip;
            return this;
        }

        @Generated
        public ObjectStoreBuilder storageNetworkDnsIp(IPAddress storageNetworkDnsIp) {
            this.storageNetworkDnsIp = storageNetworkDnsIp;
            return this;
        }

        @Generated
        public ObjectStoreBuilder publicNetworkReference(String publicNetworkReference) {
            this.publicNetworkReference = publicNetworkReference;
            return this;
        }

        @Generated
        public ObjectStoreBuilder publicNetworkIps(List<IPAddress> publicNetworkIps) {
            this.publicNetworkIps = publicNetworkIps;
            return this;
        }

        @Generated
        public ObjectStoreBuilder totalCapacityGiB(Long totalCapacityGiB) {
            this.totalCapacityGiB = totalCapacityGiB;
            return this;
        }

        @Generated
        public ObjectStoreBuilder state(State state) {
            this.state = state;
            return this;
        }

        @Generated
        public ObjectStoreBuilder certificateExtIds(List<String> certificateExtIds) {
            this.certificateExtIds = certificateExtIds;
            return this;
        }

        @Generated
        public String toString() {
            return "ObjectStore.ObjectStoreBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", creationTime=" + this.creationTime + ", lastUpdateTime=" + this.lastUpdateTime + ", description=" + this.description + ", deploymentVersion=" + this.deploymentVersion + ", domain=" + this.domain + ", region=" + this.region + ", numWorkerNodes=" + this.numWorkerNodes + ", clusterExtId=" + this.clusterExtId + ", storageNetworkReference=" + this.storageNetworkReference + ", storageNetworkVip=" + this.storageNetworkVip + ", storageNetworkDnsIp=" + this.storageNetworkDnsIp + ", publicNetworkReference=" + this.publicNetworkReference + ", publicNetworkIps=" + this.publicNetworkIps + ", totalCapacityGiB=" + this.totalCapacityGiB + ", state=" + (Object)((Object)this.state) + ", certificateExtIds=" + this.certificateExtIds + ")";
        }
    }
}

