/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.obj.java.client.api;

import com.nutanix.dp1.obj.common.v1.config.Flag;
import com.nutanix.dp1.obj.common.v1.response.ApiResponseMetadata;
import com.nutanix.dp1.obj.objects.v4.config.CreateCertificateApiResponse;
import com.nutanix.dp1.obj.objects.v4.config.CreateObjectstoreApiResponse;
import com.nutanix.dp1.obj.objects.v4.config.DeleteObjectstoreApiResponse;
import com.nutanix.dp1.obj.objects.v4.config.GetCaApiResponse;
import com.nutanix.dp1.obj.objects.v4.config.GetCertificateApiResponse;
import com.nutanix.dp1.obj.objects.v4.config.GetObjectstoreApiResponse;
import com.nutanix.dp1.obj.objects.v4.config.ListCertificatesApiResponse;
import com.nutanix.dp1.obj.objects.v4.config.ListObjectstoresApiResponse;
import com.nutanix.dp1.obj.objects.v4.config.ObjectStore;
import com.nutanix.dp1.obj.objects.v4.config.UpdateObjectstoreApiResponse;
import com.nutanix.obj.java.client.ApiClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.obj.java.client.api.ObjectStoresApi")
public class ObjectStoresApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectStoresApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public ObjectStoresApi() {
        this(new ApiClient());
    }

    @Autowired
    public ObjectStoresApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateCertificateApiResponse createCertificate(String objectStoreExtId, Path path, Map<String, Object> ... args) throws RestClientException, FileNotFoundException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Path postBody = path;
        if (objectStoreExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'objectStoreExtId' when calling createCertificate");
        }
        if (path == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'path' when calling createCertificate");
        }
        if (path instanceof Path) {
            Path filePath = path;
            File fileObject = filePath.toFile();
            argMap.put("Content-Length", fileObject.length());
            if (!argMap.containsKey("Content-Disposition")) {
                ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(filePath.getFileName().toString()).build();
                argMap.put("Content-Disposition", contentDisposition);
            }
            postBody = new InputStreamResource((InputStream)new FileInputStream(fileObject));
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("objectStoreExtId", objectStoreExtId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/objects/v4.0/config/object-stores/{objectStoreExtId}/certificates").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/octet-stream"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"basicAuthScheme"};
        ParameterizedTypeReference<CreateCertificateApiResponse> returnType = new ParameterizedTypeReference<CreateCertificateApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public CreateObjectstoreApiResponse createObjectstore(ObjectStore body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        ObjectStore postBody = body;
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling createObjectstore");
        }
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/objects/v4.0/config/object-stores").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"basicAuthScheme"};
        ParameterizedTypeReference<CreateObjectstoreApiResponse> returnType = new ParameterizedTypeReference<CreateObjectstoreApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public DeleteObjectstoreApiResponse deleteObjectstoreById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling deleteObjectstoreById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/objects/v4.0/config/object-stores/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"basicAuthScheme"};
        ParameterizedTypeReference<DeleteObjectstoreApiResponse> returnType = new ParameterizedTypeReference<DeleteObjectstoreApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.DELETE, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetCaApiResponse getCaByCertificateId(String objectStoreExtId, String certificateExtId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (objectStoreExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'objectStoreExtId' when calling getCaByCertificateId");
        }
        if (certificateExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'certificateExtId' when calling getCaByCertificateId");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("objectStoreExtId", objectStoreExtId);
        uriVariables.put("certificateExtId", certificateExtId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/objects/v4.0/config/object-stores/{objectStoreExtId}/certificates/{certificateExtId}/certificate-authority").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/octet-stream", "application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"basicAuthScheme"};
        ParameterizedTypeReference<ApiClient.OneOfBinaryResponseWrapper> returnType = new ParameterizedTypeReference<ApiClient.OneOfBinaryResponseWrapper>(){};
        ApiClient.OneOfBinaryResponseWrapper responseWrapper = this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
        try {
            if (responseWrapper.isBinary()) {
                Map<String, Object> pathObject = this.apiClient.getFileDownloadResponse(responseWrapper.getResourceObject(), responseWrapper.getResponseEntity().getHeaders());
                return GetCaApiResponse.GetCaApiResponseBuilder().data(pathObject).metadata(ApiResponseMetadata.ApiResponseMetadataBuilder().flags(Arrays.asList(new Flag("hasError", false))).build()).build();
            }
            GetCaApiResponse apiResponse = (GetCaApiResponse)ApiClient.OBJECT_MAPPER.readValue(responseWrapper.getJsonObject(), GetCaApiResponse.class);
            ResponseEntity responseEntity = new ResponseEntity((Object)apiResponse, (MultiValueMap)responseWrapper.getResponseEntity().getHeaders(), responseWrapper.getResponseEntity().getStatusCode().value());
            ParameterizedTypeReference<GetCaApiResponse> dtoTypeReference = new ParameterizedTypeReference<GetCaApiResponse>(){};
            return this.apiClient.getResponseBody(responseEntity, dtoTypeReference);
        }
        catch (Exception ex) {
            String message = "Unable to process wrapper response";
            log.error(message, (Throwable)ex);
            throw new RestClientException(String.format("%s: %s", message, ex.getMessage()));
        }
    }

    public GetCertificateApiResponse getCertificateById(String objectStoreExtId, String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (objectStoreExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'objectStoreExtId' when calling getCertificateById");
        }
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getCertificateById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("objectStoreExtId", objectStoreExtId);
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/objects/v4.0/config/object-stores/{objectStoreExtId}/certificates/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"basicAuthScheme"};
        ParameterizedTypeReference<GetCertificateApiResponse> returnType = new ParameterizedTypeReference<GetCertificateApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetObjectstoreApiResponse getObjectstoreById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getObjectstoreById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/objects/v4.0/config/object-stores/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"basicAuthScheme"};
        ParameterizedTypeReference<GetObjectstoreApiResponse> returnType = new ParameterizedTypeReference<GetObjectstoreApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ListCertificatesApiResponse listCertificatesByObjectstoreId(String objectStoreExtId, Integer $page, Integer $limit, String $filter, String $select, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (objectStoreExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'objectStoreExtId' when calling listCertificatesByObjectstoreId");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("objectStoreExtId", objectStoreExtId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/objects/v4.0/config/object-stores/{objectStoreExtId}/certificates").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$page", $page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$filter", $filter));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$select", $select));
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"basicAuthScheme"};
        ParameterizedTypeReference<ListCertificatesApiResponse> returnType = new ParameterizedTypeReference<ListCertificatesApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ListObjectstoresApiResponse listObjectstores(Integer $page, Integer $limit, String $filter, String $orderby, String $expand, String $select, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/objects/v4.0/config/object-stores").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$page", $page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$filter", $filter));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$orderby", $orderby));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$expand", $expand));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$select", $select));
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"basicAuthScheme"};
        ParameterizedTypeReference<ListObjectstoresApiResponse> returnType = new ParameterizedTypeReference<ListObjectstoresApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public UpdateObjectstoreApiResponse updateObjectstoreById(String extId, ObjectStore body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        ObjectStore postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling updateObjectstoreById");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling updateObjectstoreById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/objects/v4.0/config/object-stores/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"basicAuthScheme"};
        ParameterizedTypeReference<UpdateObjectstoreApiResponse> returnType = new ParameterizedTypeReference<UpdateObjectstoreApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.PUT, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

