/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.nutanix.dp1.sec.deserializers.SecDeserializerUtils;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecObjectTypeTypedObjectDeserializer
extends StdDeserializer<SecObjectTypeTypedObject> {
    private static final Logger log = LoggerFactory.getLogger(SecObjectTypeTypedObjectDeserializer.class);
    private final String packagePrefix = "com.nutanix.dp1.sec";

    public SecObjectTypeTypedObjectDeserializer() {
        super(SecObjectTypeTypedObject.class);
    }

    public SecObjectTypeTypedObject deserialize(JsonParser p, DeserializationContext ctxt) {
        ObjectCodec codec = p.getCodec();
        JsonNode targetNode = (JsonNode)codec.readTree(p);
        Class<?> clazz = SecDeserializerUtils.getObjectTypedType(targetNode, this.packagePrefix);
        log.debug("Deserializing json node into instance of {}", clazz);
        return (SecObjectTypeTypedObject)SecDeserializerUtils.readValue(codec, targetNode, clazz);
    }
}

