/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.nutanix.dp1.sec.deserializers.SecDeserializerUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecOneOfDeserializer<W>
extends StdDeserializer<W> {
    private static final Logger log = LoggerFactory.getLogger(SecOneOfDeserializer.class);

    public SecOneOfDeserializer(JavaType wrapperClass) {
        super(wrapperClass);
    }

    public W deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = jp.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jp);
        try {
            W oneOfObject = this.getObjectInstance();
            Object value = this.getObject(codec, node);
            this.setDataObject(oneOfObject, value);
            return oneOfObject;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("Class not found in classpath or could not be instantiated", (Throwable)e);
            throw new IOException("Class not found in classpath or could not be instantiated", e);
        }
    }

    protected abstract String getPackagePrefix();

    protected W getObjectInstance() throws InstantiationException, IllegalAccessException {
        return (W)this.handledType().newInstance();
    }

    protected Object getObject(ObjectCodec codec, JsonNode node) throws IOException, ClassNotFoundException {
        JsonNodeType nodeType = node.getNodeType();
        if (nodeType == JsonNodeType.ARRAY || nodeType == JsonNodeType.OBJECT || nodeType == JsonNodeType.NUMBER || nodeType == JsonNodeType.STRING || nodeType == JsonNodeType.BOOLEAN) {
            return SecDeserializerUtils.readValue(codec, node, this.getPackagePrefix(), null);
        }
        log.error("Unrecognized json node type: {}", (Object)nodeType);
        throw new IllegalArgumentException("Could not recognize json node type");
    }

    protected abstract void setDataObject(W var1, Object var2);
}

