/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.sec.common.v1.response.ApiLink;
import com.nutanix.dp1.sec.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.iam.v4.authn.BucketsAccessKeyStatusType;
import com.nutanix.dp1.sec.iam.v4.authn.CreationType;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketsAccessKey
extends ExternalizableAbstractModel
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BucketsAccessKey.class);
    private String secretAccessKey = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String userId = null;
    private OffsetDateTime createdTime = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String lastUpdatedBy = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String createdBy = null;
    private OffsetDateTime lastUpdatedTime = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="accessKeyName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String accessKeyName = null;
    @Size(min=3, max=255)
    @JsonProperty(value="assignedTo")
    public @Size(min=3, max=255) String assignedTo = null;
    @JsonProperty(value="creationType")
    public CreationType creationType = null;
    @JsonProperty(value="expiryTime")
    public OffsetDateTime expiryTime = null;
    @JsonProperty(value="status")
    public BucketsAccessKeyStatusType status = null;

    public BucketsAccessKey() {
    }

    public BucketsAccessKey(String tenantId, String extId, List<ApiLink> links, String accessKeyName, String secretAccessKey, String userId, OffsetDateTime createdTime, String lastUpdatedBy, String assignedTo, CreationType creationType, OffsetDateTime expiryTime, BucketsAccessKeyStatusType status, String createdBy, OffsetDateTime lastUpdatedTime) {
        super(tenantId, extId, links);
        this.setAccessKeyName(accessKeyName);
        this.setSecretAccessKey(secretAccessKey);
        this.setUserId(userId);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedBy(lastUpdatedBy);
        this.setAssignedTo(assignedTo);
        this.setCreationType(creationType);
        this.setExpiryTime(expiryTime);
        this.setStatus(status);
        this.setCreatedBy(createdBy);
        this.setLastUpdatedTime(lastUpdatedTime);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authn.BucketsAccessKey";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1.b1";
    }

    public void setSecretAccessKey(String secretAccessKey) {
        if (this.secretAccessKey == null) {
            this.secretAccessKey = secretAccessKey;
        } else {
            log.warn("Read-only property secretAccessKey already contains a non-null value and cannot be set again");
        }
    }

    public void setUserId(String userId) {
        if (this.userId == null) {
            this.userId = userId;
        } else {
            log.warn("Read-only property userId already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        if (this.lastUpdatedBy == null) {
            this.lastUpdatedBy = lastUpdatedBy;
        } else {
            log.warn("Read-only property lastUpdatedBy already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public static BucketsAccessKeyBuilder BucketsAccessKeyBuilder() {
        return new BucketsAccessKeyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketsAccessKey)) {
            return false;
        }
        BucketsAccessKey other = (BucketsAccessKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$secretAccessKey = this.getSecretAccessKey();
        String other$secretAccessKey = other.getSecretAccessKey();
        if (this$secretAccessKey == null ? other$secretAccessKey != null : !this$secretAccessKey.equals(other$secretAccessKey)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        String this$lastUpdatedBy = this.getLastUpdatedBy();
        String other$lastUpdatedBy = other.getLastUpdatedBy();
        if (this$lastUpdatedBy == null ? other$lastUpdatedBy != null : !this$lastUpdatedBy.equals(other$lastUpdatedBy)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$accessKeyName = this.getAccessKeyName();
        String other$accessKeyName = other.getAccessKeyName();
        if (this$accessKeyName == null ? other$accessKeyName != null : !this$accessKeyName.equals(other$accessKeyName)) {
            return false;
        }
        String this$assignedTo = this.getAssignedTo();
        String other$assignedTo = other.getAssignedTo();
        if (this$assignedTo == null ? other$assignedTo != null : !this$assignedTo.equals(other$assignedTo)) {
            return false;
        }
        CreationType this$creationType = this.getCreationType();
        CreationType other$creationType = other.getCreationType();
        if (this$creationType == null ? other$creationType != null : !((Object)((Object)this$creationType)).equals((Object)other$creationType)) {
            return false;
        }
        OffsetDateTime this$expiryTime = this.getExpiryTime();
        OffsetDateTime other$expiryTime = other.getExpiryTime();
        if (this$expiryTime == null ? other$expiryTime != null : !((Object)this$expiryTime).equals(other$expiryTime)) {
            return false;
        }
        BucketsAccessKeyStatusType this$status = this.getStatus();
        BucketsAccessKeyStatusType other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BucketsAccessKey;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $secretAccessKey = this.getSecretAccessKey();
        result = result * 59 + ($secretAccessKey == null ? 43 : $secretAccessKey.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        String $lastUpdatedBy = this.getLastUpdatedBy();
        result = result * 59 + ($lastUpdatedBy == null ? 43 : $lastUpdatedBy.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $accessKeyName = this.getAccessKeyName();
        result = result * 59 + ($accessKeyName == null ? 43 : $accessKeyName.hashCode());
        String $assignedTo = this.getAssignedTo();
        result = result * 59 + ($assignedTo == null ? 43 : $assignedTo.hashCode());
        CreationType $creationType = this.getCreationType();
        result = result * 59 + ($creationType == null ? 43 : ((Object)((Object)$creationType)).hashCode());
        OffsetDateTime $expiryTime = this.getExpiryTime();
        result = result * 59 + ($expiryTime == null ? 43 : ((Object)$expiryTime).hashCode());
        BucketsAccessKeyStatusType $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getAccessKeyName() {
        return this.accessKeyName;
    }

    public String getAssignedTo() {
        return this.assignedTo;
    }

    public CreationType getCreationType() {
        return this.creationType;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public BucketsAccessKeyStatusType getStatus() {
        return this.status;
    }

    @JsonProperty(value="accessKeyName")
    public void setAccessKeyName(String accessKeyName) {
        this.accessKeyName = accessKeyName;
    }

    @JsonProperty(value="assignedTo")
    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    @JsonProperty(value="creationType")
    public void setCreationType(CreationType creationType) {
        this.creationType = creationType;
    }

    @JsonProperty(value="expiryTime")
    public void setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
    }

    @JsonProperty(value="status")
    public void setStatus(BucketsAccessKeyStatusType status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "BucketsAccessKey(secretAccessKey=" + this.getSecretAccessKey() + ", userId=" + this.getUserId() + ", createdTime=" + this.getCreatedTime() + ", lastUpdatedBy=" + this.getLastUpdatedBy() + ", createdBy=" + this.getCreatedBy() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", accessKeyName=" + this.getAccessKeyName() + ", assignedTo=" + this.getAssignedTo() + ", creationType=" + (Object)((Object)this.getCreationType()) + ", expiryTime=" + this.getExpiryTime() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public static class BucketsAccessKeyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String accessKeyName;
        private String secretAccessKey;
        private String userId;
        private OffsetDateTime createdTime;
        private String lastUpdatedBy;
        private String assignedTo;
        private CreationType creationType;
        private OffsetDateTime expiryTime;
        private BucketsAccessKeyStatusType status;
        private String createdBy;
        private OffsetDateTime lastUpdatedTime;

        BucketsAccessKeyBuilder() {
        }

        public BucketsAccessKeyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BucketsAccessKeyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BucketsAccessKeyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BucketsAccessKeyBuilder accessKeyName(String accessKeyName) {
            this.accessKeyName = accessKeyName;
            return this;
        }

        public BucketsAccessKeyBuilder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public BucketsAccessKeyBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public BucketsAccessKeyBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public BucketsAccessKeyBuilder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public BucketsAccessKeyBuilder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        public BucketsAccessKeyBuilder creationType(CreationType creationType) {
            this.creationType = creationType;
            return this;
        }

        public BucketsAccessKeyBuilder expiryTime(OffsetDateTime expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public BucketsAccessKeyBuilder status(BucketsAccessKeyStatusType status) {
            this.status = status;
            return this;
        }

        public BucketsAccessKeyBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public BucketsAccessKeyBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public BucketsAccessKey build() {
            return new BucketsAccessKey(this.tenantId, this.extId, this.links, this.accessKeyName, this.secretAccessKey, this.userId, this.createdTime, this.lastUpdatedBy, this.assignedTo, this.creationType, this.expiryTime, this.status, this.createdBy, this.lastUpdatedTime);
        }

        public String toString() {
            return "BucketsAccessKey.BucketsAccessKeyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", accessKeyName=" + this.accessKeyName + ", secretAccessKey=" + this.secretAccessKey + ", userId=" + this.userId + ", createdTime=" + this.createdTime + ", lastUpdatedBy=" + this.lastUpdatedBy + ", assignedTo=" + this.assignedTo + ", creationType=" + (Object)((Object)this.creationType) + ", expiryTime=" + this.expiryTime + ", status=" + (Object)((Object)this.status) + ", createdBy=" + this.createdBy + ", lastUpdatedTime=" + this.lastUpdatedTime + ")";
        }
    }
}

