/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAccessInformation
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(AzureAccessInformation.class);
    @Size(min=8, max=256)
    private @Size(min=8, max=256) String truncatedClientSecret = null;
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    @Size(max=1024)
    @JsonProperty(value="endpointUrl")
    public @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") @Size(max=1024) String endpointUrl = null;
    @Size(max=256)
    @JsonProperty(value="keyId")
    public @Size(max=256) String keyId = null;
    @Size(max=256)
    @JsonProperty(value="tenantId")
    public @Size(max=256) String tenantId = null;
    @Size(max=256)
    @JsonProperty(value="clientId")
    public @Size(max=256) String clientId = null;
    @JsonProperty(value="clientSecret")
    public String clientSecret = null;
    @JsonProperty(value="credentialExpiryDate")
    public LocalDate credentialExpiryDate = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public AzureAccessInformation() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public AzureAccessInformation(String endpointUrl, String keyId, String tenantId, String clientId, String clientSecret, String truncatedClientSecret, LocalDate credentialExpiryDate) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setEndpointUrl(endpointUrl);
        this.setKeyId(keyId);
        this.setTenantId(tenantId);
        this.setClientId(clientId);
        this.setClientSecret(clientSecret);
        this.setTruncatedClientSecret(truncatedClientSecret);
        this.setCredentialExpiryDate(credentialExpiryDate);
    }

    protected String initialize$objectType() {
        return "security.v4.config.AzureAccessInformation";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setTruncatedClientSecret(String truncatedClientSecret) {
        if (this.truncatedClientSecret == null) {
            this.truncatedClientSecret = truncatedClientSecret;
        } else {
            log.warn("Read-only property truncatedClientSecret already contains a non-null value and cannot be set again");
        }
    }

    public static AzureAccessInformationBuilder AzureAccessInformationBuilder() {
        return new AzureAccessInformationBuilder();
    }

    public String getTruncatedClientSecret() {
        return this.truncatedClientSecret;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public LocalDate getCredentialExpiryDate() {
        return this.credentialExpiryDate;
    }

    @JsonProperty(value="endpointUrl")
    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    @JsonProperty(value="keyId")
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JsonProperty(value="clientSecret")
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @JsonProperty(value="credentialExpiryDate")
    public void setCredentialExpiryDate(LocalDate credentialExpiryDate) {
        this.credentialExpiryDate = credentialExpiryDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureAccessInformation)) {
            return false;
        }
        AzureAccessInformation other = (AzureAccessInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$truncatedClientSecret = this.getTruncatedClientSecret();
        String other$truncatedClientSecret = other.getTruncatedClientSecret();
        if (this$truncatedClientSecret == null ? other$truncatedClientSecret != null : !this$truncatedClientSecret.equals(other$truncatedClientSecret)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        LocalDate this$credentialExpiryDate = this.getCredentialExpiryDate();
        LocalDate other$credentialExpiryDate = other.getCredentialExpiryDate();
        return !(this$credentialExpiryDate == null ? other$credentialExpiryDate != null : !((Object)this$credentialExpiryDate).equals(other$credentialExpiryDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AzureAccessInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $truncatedClientSecret = this.getTruncatedClientSecret();
        result = result * 59 + ($truncatedClientSecret == null ? 43 : $truncatedClientSecret.hashCode());
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        LocalDate $credentialExpiryDate = this.getCredentialExpiryDate();
        result = result * 59 + ($credentialExpiryDate == null ? 43 : ((Object)$credentialExpiryDate).hashCode());
        return result;
    }

    public String toString() {
        return "AzureAccessInformation(truncatedClientSecret=" + this.getTruncatedClientSecret() + ", endpointUrl=" + this.getEndpointUrl() + ", keyId=" + this.getKeyId() + ", tenantId=" + this.getTenantId() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", credentialExpiryDate=" + this.getCredentialExpiryDate() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class AzureAccessInformationBuilder {
        private String endpointUrl;
        private String keyId;
        private String tenantId;
        private String clientId;
        private String clientSecret;
        private String truncatedClientSecret;
        private LocalDate credentialExpiryDate;

        AzureAccessInformationBuilder() {
        }

        public AzureAccessInformationBuilder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public AzureAccessInformationBuilder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public AzureAccessInformationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AzureAccessInformationBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AzureAccessInformationBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public AzureAccessInformationBuilder truncatedClientSecret(String truncatedClientSecret) {
            this.truncatedClientSecret = truncatedClientSecret;
            return this;
        }

        public AzureAccessInformationBuilder credentialExpiryDate(LocalDate credentialExpiryDate) {
            this.credentialExpiryDate = credentialExpiryDate;
            return this;
        }

        public AzureAccessInformation build() {
            return new AzureAccessInformation(this.endpointUrl, this.keyId, this.tenantId, this.clientId, this.clientSecret, this.truncatedClientSecret, this.credentialExpiryDate);
        }

        public String toString() {
            return "AzureAccessInformation.AzureAccessInformationBuilder(endpointUrl=" + this.endpointUrl + ", keyId=" + this.keyId + ", tenantId=" + this.tenantId + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", truncatedClientSecret=" + this.truncatedClientSecret + ", credentialExpiryDate=" + this.credentialExpiryDate + ")";
        }
    }
}

