/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.config;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.sec.annotations.SecJsonDeserializer;
import com.nutanix.dp1.sec.common.v1.response.ApiLink;
import com.nutanix.dp1.sec.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.deserializers.SecOneOfDeserializer;
import com.nutanix.dp1.sec.security.v4.config.BmcCredential;
import com.nutanix.dp1.sec.security.v4.config.IntersightCredential;
import com.nutanix.dp1.sec.security.v4.config.VcenterCredential;
import com.nutanix.dp1.sec.serializers.SecOneOfSerializer;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Credential
extends ExternalizableAbstractModel
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Credential.class);
    private Boolean isValid = null;
    @Size(min=1, max=256)
    @JsonProperty(value="name")
    public @Size(min=1, max=256) String name = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $credentialDetailsItemDiscriminator = null;
    private OneOfCredentialDetailsWrapper credentialDetails = null;

    public Credential() {
    }

    public Credential(String tenantId, String extId, List<ApiLink> links, String name, Object credentialDetails, Boolean isValid) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setCredentialDetailsInWrapper(credentialDetails);
        this.setIsValid(isValid);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.config.Credential";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setIsValid(Boolean isValid) {
        if (this.isValid == null) {
            this.isValid = isValid;
        } else {
            log.warn("Read-only property isValid already contains a non-null value and cannot be set again");
        }
    }

    public String get$credentialDetailsItemDiscriminator() {
        if (this.credentialDetails != null && this.$credentialDetailsItemDiscriminator == null) {
            this.$credentialDetailsItemDiscriminator = this.credentialDetails.getDiscriminator();
        }
        return this.$credentialDetailsItemDiscriminator;
    }

    @JsonIgnore
    public void setCredentialDetailsInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.credentialDetails == null) {
            this.credentialDetails = new OneOfCredentialDetailsWrapper();
        }
        this.credentialDetails.setValue(value);
        this.$credentialDetailsItemDiscriminator = this.credentialDetails.getDiscriminator();
    }

    @JsonSerialize(using=SecOneOfSerializer.class)
    public Object getCredentialDetails() {
        if (this.credentialDetails == null) {
            log.debug("OneOf property credentialDetails was never set. Returning null...");
            return null;
        }
        return this.credentialDetails.getValue();
    }

    public static CredentialBuilder CredentialBuilder() {
        return new CredentialBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Credential)) {
            return false;
        }
        Credential other = (Credential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isValid = this.getIsValid();
        Boolean other$isValid = other.getIsValid();
        if (this$isValid == null ? other$isValid != null : !((Object)this$isValid).equals(other$isValid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Object this$credentialDetails = this.getCredentialDetails();
        Object other$credentialDetails = other.getCredentialDetails();
        return !(this$credentialDetails == null ? other$credentialDetails != null : !this$credentialDetails.equals(other$credentialDetails));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Credential;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isValid = this.getIsValid();
        result = result * 59 + ($isValid == null ? 43 : ((Object)$isValid).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Object $credentialDetails = this.getCredentialDetails();
        result = result * 59 + ($credentialDetails == null ? 43 : $credentialDetails.hashCode());
        return result;
    }

    public Boolean getIsValid() {
        return this.isValid;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public void setCredentialDetails(OneOfCredentialDetailsWrapper credentialDetails) {
        this.credentialDetails = credentialDetails;
    }

    @Override
    public String toString() {
        return "Credential(isValid=" + this.getIsValid() + ", name=" + this.getName() + ", credentialDetails=" + this.getCredentialDetails() + ")";
    }

    public static class CredentialBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private Object credentialDetails;
        private Boolean isValid;

        CredentialBuilder() {
        }

        public CredentialBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public CredentialBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public CredentialBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public CredentialBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CredentialBuilder credentialDetails(Object credentialDetails) {
            this.credentialDetails = credentialDetails;
            return this;
        }

        public CredentialBuilder isValid(Boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        public Credential build() {
            return new Credential(this.tenantId, this.extId, this.links, this.name, this.credentialDetails, this.isValid);
        }

        public String toString() {
            return "Credential.CredentialBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", credentialDetails=" + this.credentialDetails + ", isValid=" + this.isValid + ")";
        }
    }

    @JsonDeserialize(using=OneOfCredentialDetailsWrapperJsonDeserializer.class)
    public static class OneOfCredentialDetailsWrapper {
        @JsonIgnore
        private BmcCredential oneOfType1001;
        @JsonIgnore
        private VcenterCredential oneOfType1002;
        @JsonIgnore
        private IntersightCredential oneOfType1003;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfCredentialDetailsWrapper() {
        }

        public OneOfCredentialDetailsWrapper(BmcCredential data) {
            this.oneOfType1001 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfCredentialDetailsWrapper(VcenterCredential data) {
            this.oneOfType1002 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfCredentialDetailsWrapper(IntersightCredential data) {
            this.oneOfType1003 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType1001 != null && this.oneOfType1001.get$objectType().equals(this.discriminator)) {
                return this.oneOfType1001;
            }
            if (this.oneOfType1002 != null && this.oneOfType1002.get$objectType().equals(this.discriminator)) {
                return this.oneOfType1002;
            }
            if (this.oneOfType1003 != null && this.oneOfType1003.get$objectType().equals(this.discriminator)) {
                return this.oneOfType1003;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof BmcCredential) {
                this.oneOfType1001 = (BmcCredential)value;
                this.discriminator = this.oneOfType1001.get$objectType();
                this.$objectType = this.oneOfType1001.get$objectType();
                return;
            }
            if (value instanceof VcenterCredential) {
                this.oneOfType1002 = (VcenterCredential)value;
                this.discriminator = this.oneOfType1002.get$objectType();
                this.$objectType = this.oneOfType1002.get$objectType();
                return;
            }
            if (value instanceof IntersightCredential) {
                this.oneOfType1003 = (IntersightCredential)value;
                this.discriminator = this.oneOfType1003.get$objectType();
                this.$objectType = this.oneOfType1003.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfCredentialDetailsWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfCredentialDetailsWrapper)) {
                return false;
            }
            OneOfCredentialDetailsWrapper other = (OneOfCredentialDetailsWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BmcCredential this$oneOfType1001 = this.oneOfType1001;
            BmcCredential other$oneOfType1001 = other.oneOfType1001;
            if (this$oneOfType1001 == null ? other$oneOfType1001 != null : !((Object)this$oneOfType1001).equals(other$oneOfType1001)) {
                return false;
            }
            VcenterCredential this$oneOfType1002 = this.oneOfType1002;
            VcenterCredential other$oneOfType1002 = other.oneOfType1002;
            if (this$oneOfType1002 == null ? other$oneOfType1002 != null : !((Object)this$oneOfType1002).equals(other$oneOfType1002)) {
                return false;
            }
            IntersightCredential this$oneOfType1003 = this.oneOfType1003;
            IntersightCredential other$oneOfType1003 = other.oneOfType1003;
            if (this$oneOfType1003 == null ? other$oneOfType1003 != null : !((Object)this$oneOfType1003).equals(other$oneOfType1003)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfCredentialDetailsWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BmcCredential $oneOfType1001 = this.oneOfType1001;
            result = result * 59 + ($oneOfType1001 == null ? 43 : ((Object)$oneOfType1001).hashCode());
            VcenterCredential $oneOfType1002 = this.oneOfType1002;
            result = result * 59 + ($oneOfType1002 == null ? 43 : ((Object)$oneOfType1002).hashCode());
            IntersightCredential $oneOfType1003 = this.oneOfType1003;
            result = result * 59 + ($oneOfType1003 == null ? 43 : ((Object)$oneOfType1003).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "Credential.OneOfCredentialDetailsWrapper(oneOfType1001=" + this.oneOfType1001 + ", oneOfType1002=" + this.oneOfType1002 + ", oneOfType1003=" + this.oneOfType1003 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @SecJsonDeserializer
        private static class OneOfCredentialDetailsWrapperJsonDeserializer
        extends SecOneOfDeserializer<OneOfCredentialDetailsWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE1001 = TYPE_FACTORY.constructType(BmcCredential.class);
            private static final JavaType ONE_OF_TYPE1002 = TYPE_FACTORY.constructType(VcenterCredential.class);
            private static final JavaType ONE_OF_TYPE1003 = TYPE_FACTORY.constructType(IntersightCredential.class);

            public OneOfCredentialDetailsWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfCredentialDetailsWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfCredentialDetailsWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfCredentialDetailsWrapper provided is null");
                }
                if (ONE_OF_TYPE1001.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE1002.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE1003.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfCredentialDetailsWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.sec";
            }
        }
    }
}

