/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.security.v4.config.IntersightConnectionType;
import com.nutanix.dp1.sec.security.v4.config.KeyBasedAuth;
import com.nutanix.dp1.sec.security.v4.config.KeyBasedAuthCredential;
import java.io.Serializable;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntersightCredential
extends KeyBasedAuthCredential
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IntersightCredential.class);
    private String type = null;
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    @JsonProperty(value="url")
    public @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") String url = null;
    @JsonProperty(value="deploymentType")
    public IntersightConnectionType deploymentType = null;

    public IntersightCredential() {
    }

    public IntersightCredential(KeyBasedAuth credential, String url, IntersightConnectionType deploymentType, String type) {
        super(credential);
        this.setUrl(url);
        this.setDeploymentType(deploymentType);
        this.setType(type);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.config.IntersightCredential";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setType(String type) {
        if (this.type == null) {
            this.type = type;
        } else {
            log.warn("Read-only property type already contains a non-null value and cannot be set again");
        }
    }

    public static IntersightCredentialBuilder IntersightCredentialBuilder() {
        return new IntersightCredentialBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntersightCredential)) {
            return false;
        }
        IntersightCredential other = (IntersightCredential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        IntersightConnectionType this$deploymentType = this.getDeploymentType();
        IntersightConnectionType other$deploymentType = other.getDeploymentType();
        return !(this$deploymentType == null ? other$deploymentType != null : !((Object)((Object)this$deploymentType)).equals((Object)other$deploymentType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IntersightCredential;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        IntersightConnectionType $deploymentType = this.getDeploymentType();
        result = result * 59 + ($deploymentType == null ? 43 : ((Object)((Object)$deploymentType)).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public IntersightConnectionType getDeploymentType() {
        return this.deploymentType;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="deploymentType")
    public void setDeploymentType(IntersightConnectionType deploymentType) {
        this.deploymentType = deploymentType;
    }

    @Override
    public String toString() {
        return "IntersightCredential(type=" + this.getType() + ", url=" + this.getUrl() + ", deploymentType=" + (Object)((Object)this.getDeploymentType()) + ")";
    }

    public static class IntersightCredentialBuilder {
        private KeyBasedAuth credential;
        private String url;
        private IntersightConnectionType deploymentType;
        private String type;

        IntersightCredentialBuilder() {
        }

        public IntersightCredentialBuilder credential(KeyBasedAuth credential) {
            this.credential = credential;
            return this;
        }

        public IntersightCredentialBuilder url(String url) {
            this.url = url;
            return this;
        }

        public IntersightCredentialBuilder deploymentType(IntersightConnectionType deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        public IntersightCredentialBuilder type(String type) {
            this.type = type;
            return this;
        }

        public IntersightCredential build() {
            return new IntersightCredential(this.credential, this.url, this.deploymentType, this.type);
        }

        public String toString() {
            return "IntersightCredential.IntersightCredentialBuilder(credential=" + this.credential + ", url=" + this.url + ", deploymentType=" + (Object)((Object)this.deploymentType) + ", type=" + this.type + ")";
        }
    }
}

