/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.sec.common.v1.response.ApiLink;
import com.nutanix.dp1.sec.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.security.v4.config.ScheduleType;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfig
extends ExternalizableAbstractModel
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterExtId = null;
    private Boolean isSecureBootEnabled = false;
    private Boolean isClusterLockdownEnabled = false;
    private Boolean isLogForwardingEnabled = false;
    @JsonProperty(value="isHighStrengthPasswordEnabled")
    public Boolean isHighStrengthPasswordEnabled = false;
    @JsonProperty(value="isAideEnabled")
    public Boolean isAideEnabled = false;
    @JsonProperty(value="clusterScmaSchedule")
    public ScheduleType clusterScmaSchedule = null;
    @JsonProperty(value="ahvScmaSchedule")
    public ScheduleType ahvScmaSchedule = null;
    @JsonProperty(value="isAhvDefenseConsentBannerEnabled")
    public Boolean isAhvDefenseConsentBannerEnabled = false;
    @JsonProperty(value="isClusterDefenseConsentBannerEnabled")
    public Boolean isClusterDefenseConsentBannerEnabled = false;

    public SecurityConfig() {
    }

    public SecurityConfig(String tenantId, String extId, List<ApiLink> links, String clusterExtId, Boolean isHighStrengthPasswordEnabled, Boolean isAideEnabled, Boolean isSecureBootEnabled, Boolean isClusterLockdownEnabled, Boolean isLogForwardingEnabled, ScheduleType clusterScmaSchedule, ScheduleType ahvScmaSchedule, Boolean isAhvDefenseConsentBannerEnabled, Boolean isClusterDefenseConsentBannerEnabled) {
        super(tenantId, extId, links);
        this.setClusterExtId(clusterExtId);
        this.setIsHighStrengthPasswordEnabled(isHighStrengthPasswordEnabled);
        this.setIsAideEnabled(isAideEnabled);
        this.setIsSecureBootEnabled(isSecureBootEnabled);
        this.setIsClusterLockdownEnabled(isClusterLockdownEnabled);
        this.setIsLogForwardingEnabled(isLogForwardingEnabled);
        this.setClusterScmaSchedule(clusterScmaSchedule);
        this.setAhvScmaSchedule(ahvScmaSchedule);
        this.setIsAhvDefenseConsentBannerEnabled(isAhvDefenseConsentBannerEnabled);
        this.setIsClusterDefenseConsentBannerEnabled(isClusterDefenseConsentBannerEnabled);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.config.SecurityConfig";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setClusterExtId(String clusterExtId) {
        if (this.clusterExtId == null) {
            this.clusterExtId = clusterExtId;
        } else {
            log.warn("Read-only property clusterExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setIsSecureBootEnabled(Boolean isSecureBootEnabled) {
        if (this.isSecureBootEnabled == null) {
            this.isSecureBootEnabled = isSecureBootEnabled;
        } else {
            log.warn("Read-only property isSecureBootEnabled already contains a non-null value and cannot be set again");
        }
    }

    public void setIsClusterLockdownEnabled(Boolean isClusterLockdownEnabled) {
        if (this.isClusterLockdownEnabled == null) {
            this.isClusterLockdownEnabled = isClusterLockdownEnabled;
        } else {
            log.warn("Read-only property isClusterLockdownEnabled already contains a non-null value and cannot be set again");
        }
    }

    public void setIsLogForwardingEnabled(Boolean isLogForwardingEnabled) {
        if (this.isLogForwardingEnabled == null) {
            this.isLogForwardingEnabled = isLogForwardingEnabled;
        } else {
            log.warn("Read-only property isLogForwardingEnabled already contains a non-null value and cannot be set again");
        }
    }

    public static SecurityConfigBuilder SecurityConfigBuilder() {
        return new SecurityConfigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityConfig)) {
            return false;
        }
        SecurityConfig other = (SecurityConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clusterExtId = this.getClusterExtId();
        String other$clusterExtId = other.getClusterExtId();
        if (this$clusterExtId == null ? other$clusterExtId != null : !this$clusterExtId.equals(other$clusterExtId)) {
            return false;
        }
        Boolean this$isSecureBootEnabled = this.getIsSecureBootEnabled();
        Boolean other$isSecureBootEnabled = other.getIsSecureBootEnabled();
        if (this$isSecureBootEnabled == null ? other$isSecureBootEnabled != null : !((Object)this$isSecureBootEnabled).equals(other$isSecureBootEnabled)) {
            return false;
        }
        Boolean this$isClusterLockdownEnabled = this.getIsClusterLockdownEnabled();
        Boolean other$isClusterLockdownEnabled = other.getIsClusterLockdownEnabled();
        if (this$isClusterLockdownEnabled == null ? other$isClusterLockdownEnabled != null : !((Object)this$isClusterLockdownEnabled).equals(other$isClusterLockdownEnabled)) {
            return false;
        }
        Boolean this$isLogForwardingEnabled = this.getIsLogForwardingEnabled();
        Boolean other$isLogForwardingEnabled = other.getIsLogForwardingEnabled();
        if (this$isLogForwardingEnabled == null ? other$isLogForwardingEnabled != null : !((Object)this$isLogForwardingEnabled).equals(other$isLogForwardingEnabled)) {
            return false;
        }
        Boolean this$isHighStrengthPasswordEnabled = this.getIsHighStrengthPasswordEnabled();
        Boolean other$isHighStrengthPasswordEnabled = other.getIsHighStrengthPasswordEnabled();
        if (this$isHighStrengthPasswordEnabled == null ? other$isHighStrengthPasswordEnabled != null : !((Object)this$isHighStrengthPasswordEnabled).equals(other$isHighStrengthPasswordEnabled)) {
            return false;
        }
        Boolean this$isAideEnabled = this.getIsAideEnabled();
        Boolean other$isAideEnabled = other.getIsAideEnabled();
        if (this$isAideEnabled == null ? other$isAideEnabled != null : !((Object)this$isAideEnabled).equals(other$isAideEnabled)) {
            return false;
        }
        ScheduleType this$clusterScmaSchedule = this.getClusterScmaSchedule();
        ScheduleType other$clusterScmaSchedule = other.getClusterScmaSchedule();
        if (this$clusterScmaSchedule == null ? other$clusterScmaSchedule != null : !((Object)((Object)this$clusterScmaSchedule)).equals((Object)other$clusterScmaSchedule)) {
            return false;
        }
        ScheduleType this$ahvScmaSchedule = this.getAhvScmaSchedule();
        ScheduleType other$ahvScmaSchedule = other.getAhvScmaSchedule();
        if (this$ahvScmaSchedule == null ? other$ahvScmaSchedule != null : !((Object)((Object)this$ahvScmaSchedule)).equals((Object)other$ahvScmaSchedule)) {
            return false;
        }
        Boolean this$isAhvDefenseConsentBannerEnabled = this.getIsAhvDefenseConsentBannerEnabled();
        Boolean other$isAhvDefenseConsentBannerEnabled = other.getIsAhvDefenseConsentBannerEnabled();
        if (this$isAhvDefenseConsentBannerEnabled == null ? other$isAhvDefenseConsentBannerEnabled != null : !((Object)this$isAhvDefenseConsentBannerEnabled).equals(other$isAhvDefenseConsentBannerEnabled)) {
            return false;
        }
        Boolean this$isClusterDefenseConsentBannerEnabled = this.getIsClusterDefenseConsentBannerEnabled();
        Boolean other$isClusterDefenseConsentBannerEnabled = other.getIsClusterDefenseConsentBannerEnabled();
        return !(this$isClusterDefenseConsentBannerEnabled == null ? other$isClusterDefenseConsentBannerEnabled != null : !((Object)this$isClusterDefenseConsentBannerEnabled).equals(other$isClusterDefenseConsentBannerEnabled));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SecurityConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clusterExtId = this.getClusterExtId();
        result = result * 59 + ($clusterExtId == null ? 43 : $clusterExtId.hashCode());
        Boolean $isSecureBootEnabled = this.getIsSecureBootEnabled();
        result = result * 59 + ($isSecureBootEnabled == null ? 43 : ((Object)$isSecureBootEnabled).hashCode());
        Boolean $isClusterLockdownEnabled = this.getIsClusterLockdownEnabled();
        result = result * 59 + ($isClusterLockdownEnabled == null ? 43 : ((Object)$isClusterLockdownEnabled).hashCode());
        Boolean $isLogForwardingEnabled = this.getIsLogForwardingEnabled();
        result = result * 59 + ($isLogForwardingEnabled == null ? 43 : ((Object)$isLogForwardingEnabled).hashCode());
        Boolean $isHighStrengthPasswordEnabled = this.getIsHighStrengthPasswordEnabled();
        result = result * 59 + ($isHighStrengthPasswordEnabled == null ? 43 : ((Object)$isHighStrengthPasswordEnabled).hashCode());
        Boolean $isAideEnabled = this.getIsAideEnabled();
        result = result * 59 + ($isAideEnabled == null ? 43 : ((Object)$isAideEnabled).hashCode());
        ScheduleType $clusterScmaSchedule = this.getClusterScmaSchedule();
        result = result * 59 + ($clusterScmaSchedule == null ? 43 : ((Object)((Object)$clusterScmaSchedule)).hashCode());
        ScheduleType $ahvScmaSchedule = this.getAhvScmaSchedule();
        result = result * 59 + ($ahvScmaSchedule == null ? 43 : ((Object)((Object)$ahvScmaSchedule)).hashCode());
        Boolean $isAhvDefenseConsentBannerEnabled = this.getIsAhvDefenseConsentBannerEnabled();
        result = result * 59 + ($isAhvDefenseConsentBannerEnabled == null ? 43 : ((Object)$isAhvDefenseConsentBannerEnabled).hashCode());
        Boolean $isClusterDefenseConsentBannerEnabled = this.getIsClusterDefenseConsentBannerEnabled();
        result = result * 59 + ($isClusterDefenseConsentBannerEnabled == null ? 43 : ((Object)$isClusterDefenseConsentBannerEnabled).hashCode());
        return result;
    }

    public String getClusterExtId() {
        return this.clusterExtId;
    }

    public Boolean getIsSecureBootEnabled() {
        return this.isSecureBootEnabled;
    }

    public Boolean getIsClusterLockdownEnabled() {
        return this.isClusterLockdownEnabled;
    }

    public Boolean getIsLogForwardingEnabled() {
        return this.isLogForwardingEnabled;
    }

    public Boolean getIsHighStrengthPasswordEnabled() {
        return this.isHighStrengthPasswordEnabled;
    }

    public Boolean getIsAideEnabled() {
        return this.isAideEnabled;
    }

    public ScheduleType getClusterScmaSchedule() {
        return this.clusterScmaSchedule;
    }

    public ScheduleType getAhvScmaSchedule() {
        return this.ahvScmaSchedule;
    }

    public Boolean getIsAhvDefenseConsentBannerEnabled() {
        return this.isAhvDefenseConsentBannerEnabled;
    }

    public Boolean getIsClusterDefenseConsentBannerEnabled() {
        return this.isClusterDefenseConsentBannerEnabled;
    }

    @JsonProperty(value="isHighStrengthPasswordEnabled")
    public void setIsHighStrengthPasswordEnabled(Boolean isHighStrengthPasswordEnabled) {
        this.isHighStrengthPasswordEnabled = isHighStrengthPasswordEnabled;
    }

    @JsonProperty(value="isAideEnabled")
    public void setIsAideEnabled(Boolean isAideEnabled) {
        this.isAideEnabled = isAideEnabled;
    }

    @JsonProperty(value="clusterScmaSchedule")
    public void setClusterScmaSchedule(ScheduleType clusterScmaSchedule) {
        this.clusterScmaSchedule = clusterScmaSchedule;
    }

    @JsonProperty(value="ahvScmaSchedule")
    public void setAhvScmaSchedule(ScheduleType ahvScmaSchedule) {
        this.ahvScmaSchedule = ahvScmaSchedule;
    }

    @JsonProperty(value="isAhvDefenseConsentBannerEnabled")
    public void setIsAhvDefenseConsentBannerEnabled(Boolean isAhvDefenseConsentBannerEnabled) {
        this.isAhvDefenseConsentBannerEnabled = isAhvDefenseConsentBannerEnabled;
    }

    @JsonProperty(value="isClusterDefenseConsentBannerEnabled")
    public void setIsClusterDefenseConsentBannerEnabled(Boolean isClusterDefenseConsentBannerEnabled) {
        this.isClusterDefenseConsentBannerEnabled = isClusterDefenseConsentBannerEnabled;
    }

    @Override
    public String toString() {
        return "SecurityConfig(clusterExtId=" + this.getClusterExtId() + ", isSecureBootEnabled=" + this.getIsSecureBootEnabled() + ", isClusterLockdownEnabled=" + this.getIsClusterLockdownEnabled() + ", isLogForwardingEnabled=" + this.getIsLogForwardingEnabled() + ", isHighStrengthPasswordEnabled=" + this.getIsHighStrengthPasswordEnabled() + ", isAideEnabled=" + this.getIsAideEnabled() + ", clusterScmaSchedule=" + (Object)((Object)this.getClusterScmaSchedule()) + ", ahvScmaSchedule=" + (Object)((Object)this.getAhvScmaSchedule()) + ", isAhvDefenseConsentBannerEnabled=" + this.getIsAhvDefenseConsentBannerEnabled() + ", isClusterDefenseConsentBannerEnabled=" + this.getIsClusterDefenseConsentBannerEnabled() + ")";
    }

    public static class SecurityConfigBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String clusterExtId;
        private Boolean isHighStrengthPasswordEnabled;
        private Boolean isAideEnabled;
        private Boolean isSecureBootEnabled;
        private Boolean isClusterLockdownEnabled;
        private Boolean isLogForwardingEnabled;
        private ScheduleType clusterScmaSchedule;
        private ScheduleType ahvScmaSchedule;
        private Boolean isAhvDefenseConsentBannerEnabled;
        private Boolean isClusterDefenseConsentBannerEnabled;

        SecurityConfigBuilder() {
        }

        public SecurityConfigBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SecurityConfigBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public SecurityConfigBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public SecurityConfigBuilder clusterExtId(String clusterExtId) {
            this.clusterExtId = clusterExtId;
            return this;
        }

        public SecurityConfigBuilder isHighStrengthPasswordEnabled(Boolean isHighStrengthPasswordEnabled) {
            this.isHighStrengthPasswordEnabled = isHighStrengthPasswordEnabled;
            return this;
        }

        public SecurityConfigBuilder isAideEnabled(Boolean isAideEnabled) {
            this.isAideEnabled = isAideEnabled;
            return this;
        }

        public SecurityConfigBuilder isSecureBootEnabled(Boolean isSecureBootEnabled) {
            this.isSecureBootEnabled = isSecureBootEnabled;
            return this;
        }

        public SecurityConfigBuilder isClusterLockdownEnabled(Boolean isClusterLockdownEnabled) {
            this.isClusterLockdownEnabled = isClusterLockdownEnabled;
            return this;
        }

        public SecurityConfigBuilder isLogForwardingEnabled(Boolean isLogForwardingEnabled) {
            this.isLogForwardingEnabled = isLogForwardingEnabled;
            return this;
        }

        public SecurityConfigBuilder clusterScmaSchedule(ScheduleType clusterScmaSchedule) {
            this.clusterScmaSchedule = clusterScmaSchedule;
            return this;
        }

        public SecurityConfigBuilder ahvScmaSchedule(ScheduleType ahvScmaSchedule) {
            this.ahvScmaSchedule = ahvScmaSchedule;
            return this;
        }

        public SecurityConfigBuilder isAhvDefenseConsentBannerEnabled(Boolean isAhvDefenseConsentBannerEnabled) {
            this.isAhvDefenseConsentBannerEnabled = isAhvDefenseConsentBannerEnabled;
            return this;
        }

        public SecurityConfigBuilder isClusterDefenseConsentBannerEnabled(Boolean isClusterDefenseConsentBannerEnabled) {
            this.isClusterDefenseConsentBannerEnabled = isClusterDefenseConsentBannerEnabled;
            return this;
        }

        public SecurityConfig build() {
            return new SecurityConfig(this.tenantId, this.extId, this.links, this.clusterExtId, this.isHighStrengthPasswordEnabled, this.isAideEnabled, this.isSecureBootEnabled, this.isClusterLockdownEnabled, this.isLogForwardingEnabled, this.clusterScmaSchedule, this.ahvScmaSchedule, this.isAhvDefenseConsentBannerEnabled, this.isClusterDefenseConsentBannerEnabled);
        }

        public String toString() {
            return "SecurityConfig.SecurityConfigBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", clusterExtId=" + this.clusterExtId + ", isHighStrengthPasswordEnabled=" + this.isHighStrengthPasswordEnabled + ", isAideEnabled=" + this.isAideEnabled + ", isSecureBootEnabled=" + this.isSecureBootEnabled + ", isClusterLockdownEnabled=" + this.isClusterLockdownEnabled + ", isLogForwardingEnabled=" + this.isLogForwardingEnabled + ", clusterScmaSchedule=" + (Object)((Object)this.clusterScmaSchedule) + ", ahvScmaSchedule=" + (Object)((Object)this.ahvScmaSchedule) + ", isAhvDefenseConsentBannerEnabled=" + this.isAhvDefenseConsentBannerEnabled + ", isClusterDefenseConsentBannerEnabled=" + this.isClusterDefenseConsentBannerEnabled + ")";
        }
    }
}

