/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.sec.common.v1.config.BasicAuth;
import com.nutanix.dp1.sec.common.v1.config.IPAddressOrFQDN;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.security.v4.config.BasicAuthCredential;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcenterCredential
extends BasicAuthCredential
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VcenterCredential.class);
    private String type = null;
    @JsonProperty(value="address")
    public IPAddressOrFQDN address = null;

    public VcenterCredential() {
    }

    public VcenterCredential(BasicAuth credential, IPAddressOrFQDN address, String type) {
        super(credential);
        this.setAddress(address);
        this.setType(type);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.config.VcenterCredential";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setType(String type) {
        if (this.type == null) {
            this.type = type;
        } else {
            log.warn("Read-only property type already contains a non-null value and cannot be set again");
        }
    }

    public static VcenterCredentialBuilder VcenterCredentialBuilder() {
        return new VcenterCredentialBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VcenterCredential)) {
            return false;
        }
        VcenterCredential other = (VcenterCredential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        IPAddressOrFQDN this$address = this.getAddress();
        IPAddressOrFQDN other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VcenterCredential;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        IPAddressOrFQDN $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    public IPAddressOrFQDN getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress(IPAddressOrFQDN address) {
        this.address = address;
    }

    @Override
    public String toString() {
        return "VcenterCredential(type=" + this.getType() + ", address=" + this.getAddress() + ")";
    }

    public static class VcenterCredentialBuilder {
        private BasicAuth credential;
        private IPAddressOrFQDN address;
        private String type;

        VcenterCredentialBuilder() {
        }

        public VcenterCredentialBuilder credential(BasicAuth credential) {
            this.credential = credential;
            return this;
        }

        public VcenterCredentialBuilder address(IPAddressOrFQDN address) {
            this.address = address;
            return this;
        }

        public VcenterCredentialBuilder type(String type) {
            this.type = type;
            return this;
        }

        public VcenterCredential build() {
            return new VcenterCredential(this.credential, this.address, this.type);
        }

        public String toString() {
            return "VcenterCredential.VcenterCredentialBuilder(credential=" + this.credential + ", address=" + this.address + ", type=" + this.type + ")";
        }
    }
}

