/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.management;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.sec.common.v1.response.ApiLink;
import com.nutanix.dp1.sec.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.security.v4.management.ApproverGroup;
import com.nutanix.dp1.sec.security.v4.management.SecuredPolicy;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalPolicy
extends ExternalizableAbstractModel
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(ApprovalPolicy.class);
    @Size(min=0, max=100)
    private @Size(min=0, max=100) List<SecuredPolicy> securedPolicies = null;
    private String lastUpdatedBy = null;
    private OffsetDateTime lastUpdateTime = null;
    private Boolean isUpdatePending = null;
    @Size(min=4, max=199)
    @JsonProperty(value="name")
    public @Size(min=4, max=199) String name = null;
    @Size(min=0, max=499)
    @JsonProperty(value="description")
    public @Size(min=0, max=499) String description = null;
    @Size(min=1, max=10)
    @JsonProperty(value="approverGroups")
    public @Size(min=1, max=10) List<ApproverGroup> approverGroups = null;

    public ApprovalPolicy() {
    }

    public ApprovalPolicy(String tenantId, String extId, List<ApiLink> links, String name, String description, List<ApproverGroup> approverGroups, List<SecuredPolicy> securedPolicies, String lastUpdatedBy, OffsetDateTime lastUpdateTime, Boolean isUpdatePending) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setDescription(description);
        this.setApproverGroups(approverGroups);
        this.setSecuredPolicies(securedPolicies);
        this.setLastUpdatedBy(lastUpdatedBy);
        this.setLastUpdateTime(lastUpdateTime);
        this.setIsUpdatePending(isUpdatePending);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.management.ApprovalPolicy";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setSecuredPolicies(List<SecuredPolicy> securedPolicies) {
        if (this.securedPolicies == null) {
            this.securedPolicies = securedPolicies;
        } else {
            log.warn("Read-only property securedPolicies already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        if (this.lastUpdatedBy == null) {
            this.lastUpdatedBy = lastUpdatedBy;
        } else {
            log.warn("Read-only property lastUpdatedBy already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        if (this.lastUpdateTime == null) {
            this.lastUpdateTime = lastUpdateTime;
        } else {
            log.warn("Read-only property lastUpdateTime already contains a non-null value and cannot be set again");
        }
    }

    public void setIsUpdatePending(Boolean isUpdatePending) {
        if (this.isUpdatePending == null) {
            this.isUpdatePending = isUpdatePending;
        } else {
            log.warn("Read-only property isUpdatePending already contains a non-null value and cannot be set again");
        }
    }

    public static ApprovalPolicyBuilder ApprovalPolicyBuilder() {
        return new ApprovalPolicyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApprovalPolicy)) {
            return false;
        }
        ApprovalPolicy other = (ApprovalPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<SecuredPolicy> this$securedPolicies = this.getSecuredPolicies();
        List<SecuredPolicy> other$securedPolicies = other.getSecuredPolicies();
        if (this$securedPolicies == null ? other$securedPolicies != null : !((Object)this$securedPolicies).equals(other$securedPolicies)) {
            return false;
        }
        String this$lastUpdatedBy = this.getLastUpdatedBy();
        String other$lastUpdatedBy = other.getLastUpdatedBy();
        if (this$lastUpdatedBy == null ? other$lastUpdatedBy != null : !this$lastUpdatedBy.equals(other$lastUpdatedBy)) {
            return false;
        }
        OffsetDateTime this$lastUpdateTime = this.getLastUpdateTime();
        OffsetDateTime other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        Boolean this$isUpdatePending = this.getIsUpdatePending();
        Boolean other$isUpdatePending = other.getIsUpdatePending();
        if (this$isUpdatePending == null ? other$isUpdatePending != null : !((Object)this$isUpdatePending).equals(other$isUpdatePending)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<ApproverGroup> this$approverGroups = this.getApproverGroups();
        List<ApproverGroup> other$approverGroups = other.getApproverGroups();
        return !(this$approverGroups == null ? other$approverGroups != null : !((Object)this$approverGroups).equals(other$approverGroups));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApprovalPolicy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<SecuredPolicy> $securedPolicies = this.getSecuredPolicies();
        result = result * 59 + ($securedPolicies == null ? 43 : ((Object)$securedPolicies).hashCode());
        String $lastUpdatedBy = this.getLastUpdatedBy();
        result = result * 59 + ($lastUpdatedBy == null ? 43 : $lastUpdatedBy.hashCode());
        OffsetDateTime $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        Boolean $isUpdatePending = this.getIsUpdatePending();
        result = result * 59 + ($isUpdatePending == null ? 43 : ((Object)$isUpdatePending).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<ApproverGroup> $approverGroups = this.getApproverGroups();
        result = result * 59 + ($approverGroups == null ? 43 : ((Object)$approverGroups).hashCode());
        return result;
    }

    public List<SecuredPolicy> getSecuredPolicies() {
        return this.securedPolicies;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Boolean getIsUpdatePending() {
        return this.isUpdatePending;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ApproverGroup> getApproverGroups() {
        return this.approverGroups;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="approverGroups")
    public void setApproverGroups(List<ApproverGroup> approverGroups) {
        this.approverGroups = approverGroups;
    }

    @Override
    public String toString() {
        return "ApprovalPolicy(securedPolicies=" + this.getSecuredPolicies() + ", lastUpdatedBy=" + this.getLastUpdatedBy() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", isUpdatePending=" + this.getIsUpdatePending() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", approverGroups=" + this.getApproverGroups() + ")";
    }

    public static class ApprovalPolicyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String description;
        private List<ApproverGroup> approverGroups;
        private List<SecuredPolicy> securedPolicies;
        private String lastUpdatedBy;
        private OffsetDateTime lastUpdateTime;
        private Boolean isUpdatePending;

        ApprovalPolicyBuilder() {
        }

        public ApprovalPolicyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ApprovalPolicyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ApprovalPolicyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ApprovalPolicyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ApprovalPolicyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ApprovalPolicyBuilder approverGroups(List<ApproverGroup> approverGroups) {
            this.approverGroups = approverGroups;
            return this;
        }

        public ApprovalPolicyBuilder securedPolicies(List<SecuredPolicy> securedPolicies) {
            this.securedPolicies = securedPolicies;
            return this;
        }

        public ApprovalPolicyBuilder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public ApprovalPolicyBuilder lastUpdateTime(OffsetDateTime lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public ApprovalPolicyBuilder isUpdatePending(Boolean isUpdatePending) {
            this.isUpdatePending = isUpdatePending;
            return this;
        }

        public ApprovalPolicy build() {
            return new ApprovalPolicy(this.tenantId, this.extId, this.links, this.name, this.description, this.approverGroups, this.securedPolicies, this.lastUpdatedBy, this.lastUpdateTime, this.isUpdatePending);
        }

        public String toString() {
            return "ApprovalPolicy.ApprovalPolicyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", description=" + this.description + ", approverGroups=" + this.approverGroups + ", securedPolicies=" + this.securedPolicies + ", lastUpdatedBy=" + this.lastUpdatedBy + ", lastUpdateTime=" + this.lastUpdateTime + ", isUpdatePending=" + this.isUpdatePending + ")";
        }
    }
}

