/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.report;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.sec.common.v1.response.ApiLink;
import com.nutanix.dp1.sec.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.security.v4.report.Severity;
import com.nutanix.dp1.sec.security.v4.report.StigStatus;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stig
extends ExternalizableAbstractModel
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Stig.class);
    @Size(max=199)
    private @Size(max=199) String title = null;
    @Pattern(regexp="^SV-\\d{6}r\\d{6}_rule$")
    private @Pattern(regexp="^SV-\\d{6}r\\d{6}_rule$") String ruleId = null;
    @Pattern(regexp="^RHEL-\\d{2}-\\d{6}$")
    private @Pattern(regexp="^RHEL-\\d{2}-\\d{6}$") String stigVersion = null;
    @Size(min=1, max=100)
    private @Size(min=1, max=100) List<String> identifiers = null;
    @Size(min=1, max=300)
    private @Size(min=1, max=300) List<String> affectedClusters = null;
    @Size(max=499)
    private @Size(max=499) String comments = null;
    @Size(max=499)
    private @Size(max=499) String fixText = null;
    @Pattern(regexp="^RHEL_\\d+_V\\d+R\\d+$")
    private @Pattern(regexp="^RHEL_\\d+_V\\d+R\\d+$") String benchmarkId = null;
    @JsonProperty(value="severity")
    public Severity severity = null;
    @JsonProperty(value="status")
    public StigStatus status = null;

    public Stig() {
    }

    public Stig(String tenantId, String extId, List<ApiLink> links, String title, String ruleId, String stigVersion, List<String> identifiers, List<String> affectedClusters, Severity severity, StigStatus status, String comments, String fixText, String benchmarkId) {
        super(tenantId, extId, links);
        this.setTitle(title);
        this.setRuleId(ruleId);
        this.setStigVersion(stigVersion);
        this.setIdentifiers(identifiers);
        this.setAffectedClusters(affectedClusters);
        this.setSeverity(severity);
        this.setStatus(status);
        this.setComments(comments);
        this.setFixText(fixText);
        this.setBenchmarkId(benchmarkId);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.report.Stig";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setTitle(String title) {
        if (this.title == null) {
            this.title = title;
        } else {
            log.warn("Read-only property title already contains a non-null value and cannot be set again");
        }
    }

    public void setRuleId(String ruleId) {
        if (this.ruleId == null) {
            this.ruleId = ruleId;
        } else {
            log.warn("Read-only property ruleId already contains a non-null value and cannot be set again");
        }
    }

    public void setStigVersion(String stigVersion) {
        if (this.stigVersion == null) {
            this.stigVersion = stigVersion;
        } else {
            log.warn("Read-only property stigVersion already contains a non-null value and cannot be set again");
        }
    }

    public void setIdentifiers(List<String> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = identifiers;
        } else {
            log.warn("Read-only property identifiers already contains a non-null value and cannot be set again");
        }
    }

    public void setAffectedClusters(List<String> affectedClusters) {
        if (this.affectedClusters == null) {
            this.affectedClusters = affectedClusters;
        } else {
            log.warn("Read-only property affectedClusters already contains a non-null value and cannot be set again");
        }
    }

    public void setComments(String comments) {
        if (this.comments == null) {
            this.comments = comments;
        } else {
            log.warn("Read-only property comments already contains a non-null value and cannot be set again");
        }
    }

    public void setFixText(String fixText) {
        if (this.fixText == null) {
            this.fixText = fixText;
        } else {
            log.warn("Read-only property fixText already contains a non-null value and cannot be set again");
        }
    }

    public void setBenchmarkId(String benchmarkId) {
        if (this.benchmarkId == null) {
            this.benchmarkId = benchmarkId;
        } else {
            log.warn("Read-only property benchmarkId already contains a non-null value and cannot be set again");
        }
    }

    public static StigBuilder StigBuilder() {
        return new StigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Stig)) {
            return false;
        }
        Stig other = (Stig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$ruleId = this.getRuleId();
        String other$ruleId = other.getRuleId();
        if (this$ruleId == null ? other$ruleId != null : !this$ruleId.equals(other$ruleId)) {
            return false;
        }
        String this$stigVersion = this.getStigVersion();
        String other$stigVersion = other.getStigVersion();
        if (this$stigVersion == null ? other$stigVersion != null : !this$stigVersion.equals(other$stigVersion)) {
            return false;
        }
        List<String> this$identifiers = this.getIdentifiers();
        List<String> other$identifiers = other.getIdentifiers();
        if (this$identifiers == null ? other$identifiers != null : !((Object)this$identifiers).equals(other$identifiers)) {
            return false;
        }
        List<String> this$affectedClusters = this.getAffectedClusters();
        List<String> other$affectedClusters = other.getAffectedClusters();
        if (this$affectedClusters == null ? other$affectedClusters != null : !((Object)this$affectedClusters).equals(other$affectedClusters)) {
            return false;
        }
        String this$comments = this.getComments();
        String other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !this$comments.equals(other$comments)) {
            return false;
        }
        String this$fixText = this.getFixText();
        String other$fixText = other.getFixText();
        if (this$fixText == null ? other$fixText != null : !this$fixText.equals(other$fixText)) {
            return false;
        }
        String this$benchmarkId = this.getBenchmarkId();
        String other$benchmarkId = other.getBenchmarkId();
        if (this$benchmarkId == null ? other$benchmarkId != null : !this$benchmarkId.equals(other$benchmarkId)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        StigStatus this$status = this.getStatus();
        StigStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Stig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $ruleId = this.getRuleId();
        result = result * 59 + ($ruleId == null ? 43 : $ruleId.hashCode());
        String $stigVersion = this.getStigVersion();
        result = result * 59 + ($stigVersion == null ? 43 : $stigVersion.hashCode());
        List<String> $identifiers = this.getIdentifiers();
        result = result * 59 + ($identifiers == null ? 43 : ((Object)$identifiers).hashCode());
        List<String> $affectedClusters = this.getAffectedClusters();
        result = result * 59 + ($affectedClusters == null ? 43 : ((Object)$affectedClusters).hashCode());
        String $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
        String $fixText = this.getFixText();
        result = result * 59 + ($fixText == null ? 43 : $fixText.hashCode());
        String $benchmarkId = this.getBenchmarkId();
        result = result * 59 + ($benchmarkId == null ? 43 : $benchmarkId.hashCode());
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        StigStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getStigVersion() {
        return this.stigVersion;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public List<String> getAffectedClusters() {
        return this.affectedClusters;
    }

    public String getComments() {
        return this.comments;
    }

    public String getFixText() {
        return this.fixText;
    }

    public String getBenchmarkId() {
        return this.benchmarkId;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public StigStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="severity")
    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    @JsonProperty(value="status")
    public void setStatus(StigStatus status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "Stig(title=" + this.getTitle() + ", ruleId=" + this.getRuleId() + ", stigVersion=" + this.getStigVersion() + ", identifiers=" + this.getIdentifiers() + ", affectedClusters=" + this.getAffectedClusters() + ", comments=" + this.getComments() + ", fixText=" + this.getFixText() + ", benchmarkId=" + this.getBenchmarkId() + ", severity=" + (Object)((Object)this.getSeverity()) + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public static class StigBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String title;
        private String ruleId;
        private String stigVersion;
        private List<String> identifiers;
        private List<String> affectedClusters;
        private Severity severity;
        private StigStatus status;
        private String comments;
        private String fixText;
        private String benchmarkId;

        StigBuilder() {
        }

        public StigBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public StigBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public StigBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public StigBuilder title(String title) {
            this.title = title;
            return this;
        }

        public StigBuilder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public StigBuilder stigVersion(String stigVersion) {
            this.stigVersion = stigVersion;
            return this;
        }

        public StigBuilder identifiers(List<String> identifiers) {
            this.identifiers = identifiers;
            return this;
        }

        public StigBuilder affectedClusters(List<String> affectedClusters) {
            this.affectedClusters = affectedClusters;
            return this;
        }

        public StigBuilder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public StigBuilder status(StigStatus status) {
            this.status = status;
            return this;
        }

        public StigBuilder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public StigBuilder fixText(String fixText) {
            this.fixText = fixText;
            return this;
        }

        public StigBuilder benchmarkId(String benchmarkId) {
            this.benchmarkId = benchmarkId;
            return this;
        }

        public Stig build() {
            return new Stig(this.tenantId, this.extId, this.links, this.title, this.ruleId, this.stigVersion, this.identifiers, this.affectedClusters, this.severity, this.status, this.comments, this.fixText, this.benchmarkId);
        }

        public String toString() {
            return "Stig.StigBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", title=" + this.title + ", ruleId=" + this.ruleId + ", stigVersion=" + this.stigVersion + ", identifiers=" + this.identifiers + ", affectedClusters=" + this.affectedClusters + ", severity=" + (Object)((Object)this.severity) + ", status=" + (Object)((Object)this.status) + ", comments=" + this.comments + ", fixText=" + this.fixText + ", benchmarkId=" + this.benchmarkId + ")";
        }
    }
}

