/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.report;

import com.nutanix.dp1.sec.common.v1.response.ApiLink;
import com.nutanix.dp1.sec.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StigSummary
extends ExternalizableAbstractModel
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(StigSummary.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterExtId = null;
    private Integer passedCount = null;
    private Integer failedCount = null;
    private Integer notApplicableCount = null;

    public StigSummary() {
    }

    public StigSummary(String tenantId, String extId, List<ApiLink> links, String clusterExtId, Integer passedCount, Integer failedCount, Integer notApplicableCount) {
        super(tenantId, extId, links);
        this.setClusterExtId(clusterExtId);
        this.setPassedCount(passedCount);
        this.setFailedCount(failedCount);
        this.setNotApplicableCount(notApplicableCount);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.report.StigSummary";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setClusterExtId(String clusterExtId) {
        if (this.clusterExtId == null) {
            this.clusterExtId = clusterExtId;
        } else {
            log.warn("Read-only property clusterExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setPassedCount(Integer passedCount) {
        if (this.passedCount == null) {
            this.passedCount = passedCount;
        } else {
            log.warn("Read-only property passedCount already contains a non-null value and cannot be set again");
        }
    }

    public void setFailedCount(Integer failedCount) {
        if (this.failedCount == null) {
            this.failedCount = failedCount;
        } else {
            log.warn("Read-only property failedCount already contains a non-null value and cannot be set again");
        }
    }

    public void setNotApplicableCount(Integer notApplicableCount) {
        if (this.notApplicableCount == null) {
            this.notApplicableCount = notApplicableCount;
        } else {
            log.warn("Read-only property notApplicableCount already contains a non-null value and cannot be set again");
        }
    }

    public static StigSummaryBuilder StigSummaryBuilder() {
        return new StigSummaryBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StigSummary)) {
            return false;
        }
        StigSummary other = (StigSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clusterExtId = this.getClusterExtId();
        String other$clusterExtId = other.getClusterExtId();
        if (this$clusterExtId == null ? other$clusterExtId != null : !this$clusterExtId.equals(other$clusterExtId)) {
            return false;
        }
        Integer this$passedCount = this.getPassedCount();
        Integer other$passedCount = other.getPassedCount();
        if (this$passedCount == null ? other$passedCount != null : !((Object)this$passedCount).equals(other$passedCount)) {
            return false;
        }
        Integer this$failedCount = this.getFailedCount();
        Integer other$failedCount = other.getFailedCount();
        if (this$failedCount == null ? other$failedCount != null : !((Object)this$failedCount).equals(other$failedCount)) {
            return false;
        }
        Integer this$notApplicableCount = this.getNotApplicableCount();
        Integer other$notApplicableCount = other.getNotApplicableCount();
        return !(this$notApplicableCount == null ? other$notApplicableCount != null : !((Object)this$notApplicableCount).equals(other$notApplicableCount));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StigSummary;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clusterExtId = this.getClusterExtId();
        result = result * 59 + ($clusterExtId == null ? 43 : $clusterExtId.hashCode());
        Integer $passedCount = this.getPassedCount();
        result = result * 59 + ($passedCount == null ? 43 : ((Object)$passedCount).hashCode());
        Integer $failedCount = this.getFailedCount();
        result = result * 59 + ($failedCount == null ? 43 : ((Object)$failedCount).hashCode());
        Integer $notApplicableCount = this.getNotApplicableCount();
        result = result * 59 + ($notApplicableCount == null ? 43 : ((Object)$notApplicableCount).hashCode());
        return result;
    }

    public String getClusterExtId() {
        return this.clusterExtId;
    }

    public Integer getPassedCount() {
        return this.passedCount;
    }

    public Integer getFailedCount() {
        return this.failedCount;
    }

    public Integer getNotApplicableCount() {
        return this.notApplicableCount;
    }

    @Override
    public String toString() {
        return "StigSummary(clusterExtId=" + this.getClusterExtId() + ", passedCount=" + this.getPassedCount() + ", failedCount=" + this.getFailedCount() + ", notApplicableCount=" + this.getNotApplicableCount() + ")";
    }

    public static class StigSummaryBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String clusterExtId;
        private Integer passedCount;
        private Integer failedCount;
        private Integer notApplicableCount;

        StigSummaryBuilder() {
        }

        public StigSummaryBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public StigSummaryBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public StigSummaryBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public StigSummaryBuilder clusterExtId(String clusterExtId) {
            this.clusterExtId = clusterExtId;
            return this;
        }

        public StigSummaryBuilder passedCount(Integer passedCount) {
            this.passedCount = passedCount;
            return this;
        }

        public StigSummaryBuilder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public StigSummaryBuilder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            return this;
        }

        public StigSummary build() {
            return new StigSummary(this.tenantId, this.extId, this.links, this.clusterExtId, this.passedCount, this.failedCount, this.notApplicableCount);
        }

        public String toString() {
            return "StigSummary.StigSummaryBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", clusterExtId=" + this.clusterExtId + ", passedCount=" + this.passedCount + ", failedCount=" + this.failedCount + ", notApplicableCount=" + this.notApplicableCount + ")";
        }
    }
}

