/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.report;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.sec.common.v1.response.ApiLink;
import com.nutanix.dp1.sec.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.security.v4.common.Timescale;
import com.nutanix.dp1.sec.security.v4.report.IssueSummary;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Summary
extends ExternalizableAbstractModel
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Summary.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterExtId = null;
    @JsonProperty(value="securityConfigSummary")
    public IssueSummary securityConfigSummary = null;
    @JsonProperty(value="stigSummary")
    public IssueSummary stigSummary = null;
    @JsonProperty(value="vulnerabilitiesSummary")
    public IssueSummary vulnerabilitiesSummary = null;
    @JsonProperty(value="passwordSummary")
    public IssueSummary passwordSummary = null;
    @JsonProperty(value="trendType")
    public Timescale trendType = null;
    @JsonProperty(value="lastRefreshTime")
    public OffsetDateTime lastRefreshTime = null;

    public Summary() {
    }

    public Summary(String tenantId, String extId, List<ApiLink> links, String clusterExtId, IssueSummary securityConfigSummary, IssueSummary stigSummary, IssueSummary vulnerabilitiesSummary, IssueSummary passwordSummary, Timescale trendType, OffsetDateTime lastRefreshTime) {
        super(tenantId, extId, links);
        this.setClusterExtId(clusterExtId);
        this.setSecurityConfigSummary(securityConfigSummary);
        this.setStigSummary(stigSummary);
        this.setVulnerabilitiesSummary(vulnerabilitiesSummary);
        this.setPasswordSummary(passwordSummary);
        this.setTrendType(trendType);
        this.setLastRefreshTime(lastRefreshTime);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.report.Summary";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setClusterExtId(String clusterExtId) {
        if (this.clusterExtId == null) {
            this.clusterExtId = clusterExtId;
        } else {
            log.warn("Read-only property clusterExtId already contains a non-null value and cannot be set again");
        }
    }

    public static SummaryBuilder SummaryBuilder() {
        return new SummaryBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Summary)) {
            return false;
        }
        Summary other = (Summary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clusterExtId = this.getClusterExtId();
        String other$clusterExtId = other.getClusterExtId();
        if (this$clusterExtId == null ? other$clusterExtId != null : !this$clusterExtId.equals(other$clusterExtId)) {
            return false;
        }
        IssueSummary this$securityConfigSummary = this.getSecurityConfigSummary();
        IssueSummary other$securityConfigSummary = other.getSecurityConfigSummary();
        if (this$securityConfigSummary == null ? other$securityConfigSummary != null : !((Object)this$securityConfigSummary).equals(other$securityConfigSummary)) {
            return false;
        }
        IssueSummary this$stigSummary = this.getStigSummary();
        IssueSummary other$stigSummary = other.getStigSummary();
        if (this$stigSummary == null ? other$stigSummary != null : !((Object)this$stigSummary).equals(other$stigSummary)) {
            return false;
        }
        IssueSummary this$vulnerabilitiesSummary = this.getVulnerabilitiesSummary();
        IssueSummary other$vulnerabilitiesSummary = other.getVulnerabilitiesSummary();
        if (this$vulnerabilitiesSummary == null ? other$vulnerabilitiesSummary != null : !((Object)this$vulnerabilitiesSummary).equals(other$vulnerabilitiesSummary)) {
            return false;
        }
        IssueSummary this$passwordSummary = this.getPasswordSummary();
        IssueSummary other$passwordSummary = other.getPasswordSummary();
        if (this$passwordSummary == null ? other$passwordSummary != null : !((Object)this$passwordSummary).equals(other$passwordSummary)) {
            return false;
        }
        Timescale this$trendType = this.getTrendType();
        Timescale other$trendType = other.getTrendType();
        if (this$trendType == null ? other$trendType != null : !((Object)((Object)this$trendType)).equals((Object)other$trendType)) {
            return false;
        }
        OffsetDateTime this$lastRefreshTime = this.getLastRefreshTime();
        OffsetDateTime other$lastRefreshTime = other.getLastRefreshTime();
        return !(this$lastRefreshTime == null ? other$lastRefreshTime != null : !((Object)this$lastRefreshTime).equals(other$lastRefreshTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Summary;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clusterExtId = this.getClusterExtId();
        result = result * 59 + ($clusterExtId == null ? 43 : $clusterExtId.hashCode());
        IssueSummary $securityConfigSummary = this.getSecurityConfigSummary();
        result = result * 59 + ($securityConfigSummary == null ? 43 : ((Object)$securityConfigSummary).hashCode());
        IssueSummary $stigSummary = this.getStigSummary();
        result = result * 59 + ($stigSummary == null ? 43 : ((Object)$stigSummary).hashCode());
        IssueSummary $vulnerabilitiesSummary = this.getVulnerabilitiesSummary();
        result = result * 59 + ($vulnerabilitiesSummary == null ? 43 : ((Object)$vulnerabilitiesSummary).hashCode());
        IssueSummary $passwordSummary = this.getPasswordSummary();
        result = result * 59 + ($passwordSummary == null ? 43 : ((Object)$passwordSummary).hashCode());
        Timescale $trendType = this.getTrendType();
        result = result * 59 + ($trendType == null ? 43 : ((Object)((Object)$trendType)).hashCode());
        OffsetDateTime $lastRefreshTime = this.getLastRefreshTime();
        result = result * 59 + ($lastRefreshTime == null ? 43 : ((Object)$lastRefreshTime).hashCode());
        return result;
    }

    public String getClusterExtId() {
        return this.clusterExtId;
    }

    public IssueSummary getSecurityConfigSummary() {
        return this.securityConfigSummary;
    }

    public IssueSummary getStigSummary() {
        return this.stigSummary;
    }

    public IssueSummary getVulnerabilitiesSummary() {
        return this.vulnerabilitiesSummary;
    }

    public IssueSummary getPasswordSummary() {
        return this.passwordSummary;
    }

    public Timescale getTrendType() {
        return this.trendType;
    }

    public OffsetDateTime getLastRefreshTime() {
        return this.lastRefreshTime;
    }

    @JsonProperty(value="securityConfigSummary")
    public void setSecurityConfigSummary(IssueSummary securityConfigSummary) {
        this.securityConfigSummary = securityConfigSummary;
    }

    @JsonProperty(value="stigSummary")
    public void setStigSummary(IssueSummary stigSummary) {
        this.stigSummary = stigSummary;
    }

    @JsonProperty(value="vulnerabilitiesSummary")
    public void setVulnerabilitiesSummary(IssueSummary vulnerabilitiesSummary) {
        this.vulnerabilitiesSummary = vulnerabilitiesSummary;
    }

    @JsonProperty(value="passwordSummary")
    public void setPasswordSummary(IssueSummary passwordSummary) {
        this.passwordSummary = passwordSummary;
    }

    @JsonProperty(value="trendType")
    public void setTrendType(Timescale trendType) {
        this.trendType = trendType;
    }

    @JsonProperty(value="lastRefreshTime")
    public void setLastRefreshTime(OffsetDateTime lastRefreshTime) {
        this.lastRefreshTime = lastRefreshTime;
    }

    @Override
    public String toString() {
        return "Summary(clusterExtId=" + this.getClusterExtId() + ", securityConfigSummary=" + this.getSecurityConfigSummary() + ", stigSummary=" + this.getStigSummary() + ", vulnerabilitiesSummary=" + this.getVulnerabilitiesSummary() + ", passwordSummary=" + this.getPasswordSummary() + ", trendType=" + (Object)((Object)this.getTrendType()) + ", lastRefreshTime=" + this.getLastRefreshTime() + ")";
    }

    public static class SummaryBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String clusterExtId;
        private IssueSummary securityConfigSummary;
        private IssueSummary stigSummary;
        private IssueSummary vulnerabilitiesSummary;
        private IssueSummary passwordSummary;
        private Timescale trendType;
        private OffsetDateTime lastRefreshTime;

        SummaryBuilder() {
        }

        public SummaryBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SummaryBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public SummaryBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public SummaryBuilder clusterExtId(String clusterExtId) {
            this.clusterExtId = clusterExtId;
            return this;
        }

        public SummaryBuilder securityConfigSummary(IssueSummary securityConfigSummary) {
            this.securityConfigSummary = securityConfigSummary;
            return this;
        }

        public SummaryBuilder stigSummary(IssueSummary stigSummary) {
            this.stigSummary = stigSummary;
            return this;
        }

        public SummaryBuilder vulnerabilitiesSummary(IssueSummary vulnerabilitiesSummary) {
            this.vulnerabilitiesSummary = vulnerabilitiesSummary;
            return this;
        }

        public SummaryBuilder passwordSummary(IssueSummary passwordSummary) {
            this.passwordSummary = passwordSummary;
            return this;
        }

        public SummaryBuilder trendType(Timescale trendType) {
            this.trendType = trendType;
            return this;
        }

        public SummaryBuilder lastRefreshTime(OffsetDateTime lastRefreshTime) {
            this.lastRefreshTime = lastRefreshTime;
            return this;
        }

        public Summary build() {
            return new Summary(this.tenantId, this.extId, this.links, this.clusterExtId, this.securityConfigSummary, this.stigSummary, this.vulnerabilitiesSummary, this.passwordSummary, this.trendType, this.lastRefreshTime);
        }

        public String toString() {
            return "Summary.SummaryBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", clusterExtId=" + this.clusterExtId + ", securityConfigSummary=" + this.securityConfigSummary + ", stigSummary=" + this.stigSummary + ", vulnerabilitiesSummary=" + this.vulnerabilitiesSummary + ", passwordSummary=" + this.passwordSummary + ", trendType=" + (Object)((Object)this.trendType) + ", lastRefreshTime=" + this.lastRefreshTime + ")";
        }
    }
}

