/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.report;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.sec.common.v1.response.ApiLink;
import com.nutanix.dp1.sec.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.security.v4.report.Severity;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vulnerability
extends ExternalizableAbstractModel
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Vulnerability.class);
    @Size(max=199)
    private @Size(max=199) String cesaId = null;
    @Size(min=0, max=1024)
    private @Size(min=0, max=1024) List<String> cveIds = null;
    private Boolean isCritical = null;
    @Size(max=499)
    private @Size(max=499) String description = null;
    @Size(min=0, max=50)
    private @Size(min=0, max=50) List<String> fixVersions = null;
    @Size(max=199)
    private @Size(max=199) String nxvdVersion = null;
    private OffsetDateTime nxvdCreatedTime = null;
    @JsonProperty(value="severity")
    public Severity severity = null;

    public Vulnerability() {
    }

    public Vulnerability(String tenantId, String extId, List<ApiLink> links, String cesaId, List<String> cveIds, Boolean isCritical, String description, List<String> fixVersions, Severity severity, String nxvdVersion, OffsetDateTime nxvdCreatedTime) {
        super(tenantId, extId, links);
        this.setCesaId(cesaId);
        this.setCveIds(cveIds);
        this.setIsCritical(isCritical);
        this.setDescription(description);
        this.setFixVersions(fixVersions);
        this.setSeverity(severity);
        this.setNxvdVersion(nxvdVersion);
        this.setNxvdCreatedTime(nxvdCreatedTime);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.report.Vulnerability";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCesaId(String cesaId) {
        if (this.cesaId == null) {
            this.cesaId = cesaId;
        } else {
            log.warn("Read-only property cesaId already contains a non-null value and cannot be set again");
        }
    }

    public void setCveIds(List<String> cveIds) {
        if (this.cveIds == null) {
            this.cveIds = cveIds;
        } else {
            log.warn("Read-only property cveIds already contains a non-null value and cannot be set again");
        }
    }

    public void setIsCritical(Boolean isCritical) {
        if (this.isCritical == null) {
            this.isCritical = isCritical;
        } else {
            log.warn("Read-only property isCritical already contains a non-null value and cannot be set again");
        }
    }

    public void setDescription(String description) {
        if (this.description == null) {
            this.description = description;
        } else {
            log.warn("Read-only property description already contains a non-null value and cannot be set again");
        }
    }

    public void setFixVersions(List<String> fixVersions) {
        if (this.fixVersions == null) {
            this.fixVersions = fixVersions;
        } else {
            log.warn("Read-only property fixVersions already contains a non-null value and cannot be set again");
        }
    }

    public void setNxvdVersion(String nxvdVersion) {
        if (this.nxvdVersion == null) {
            this.nxvdVersion = nxvdVersion;
        } else {
            log.warn("Read-only property nxvdVersion already contains a non-null value and cannot be set again");
        }
    }

    public void setNxvdCreatedTime(OffsetDateTime nxvdCreatedTime) {
        if (this.nxvdCreatedTime == null) {
            this.nxvdCreatedTime = nxvdCreatedTime;
        } else {
            log.warn("Read-only property nxvdCreatedTime already contains a non-null value and cannot be set again");
        }
    }

    public static VulnerabilityBuilder VulnerabilityBuilder() {
        return new VulnerabilityBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$cesaId = this.getCesaId();
        String other$cesaId = other.getCesaId();
        if (this$cesaId == null ? other$cesaId != null : !this$cesaId.equals(other$cesaId)) {
            return false;
        }
        List<String> this$cveIds = this.getCveIds();
        List<String> other$cveIds = other.getCveIds();
        if (this$cveIds == null ? other$cveIds != null : !((Object)this$cveIds).equals(other$cveIds)) {
            return false;
        }
        Boolean this$isCritical = this.getIsCritical();
        Boolean other$isCritical = other.getIsCritical();
        if (this$isCritical == null ? other$isCritical != null : !((Object)this$isCritical).equals(other$isCritical)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$fixVersions = this.getFixVersions();
        List<String> other$fixVersions = other.getFixVersions();
        if (this$fixVersions == null ? other$fixVersions != null : !((Object)this$fixVersions).equals(other$fixVersions)) {
            return false;
        }
        String this$nxvdVersion = this.getNxvdVersion();
        String other$nxvdVersion = other.getNxvdVersion();
        if (this$nxvdVersion == null ? other$nxvdVersion != null : !this$nxvdVersion.equals(other$nxvdVersion)) {
            return false;
        }
        OffsetDateTime this$nxvdCreatedTime = this.getNxvdCreatedTime();
        OffsetDateTime other$nxvdCreatedTime = other.getNxvdCreatedTime();
        if (this$nxvdCreatedTime == null ? other$nxvdCreatedTime != null : !((Object)this$nxvdCreatedTime).equals(other$nxvdCreatedTime)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        return !(this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Vulnerability;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $cesaId = this.getCesaId();
        result = result * 59 + ($cesaId == null ? 43 : $cesaId.hashCode());
        List<String> $cveIds = this.getCveIds();
        result = result * 59 + ($cveIds == null ? 43 : ((Object)$cveIds).hashCode());
        Boolean $isCritical = this.getIsCritical();
        result = result * 59 + ($isCritical == null ? 43 : ((Object)$isCritical).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $fixVersions = this.getFixVersions();
        result = result * 59 + ($fixVersions == null ? 43 : ((Object)$fixVersions).hashCode());
        String $nxvdVersion = this.getNxvdVersion();
        result = result * 59 + ($nxvdVersion == null ? 43 : $nxvdVersion.hashCode());
        OffsetDateTime $nxvdCreatedTime = this.getNxvdCreatedTime();
        result = result * 59 + ($nxvdCreatedTime == null ? 43 : ((Object)$nxvdCreatedTime).hashCode());
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        return result;
    }

    public String getCesaId() {
        return this.cesaId;
    }

    public List<String> getCveIds() {
        return this.cveIds;
    }

    public Boolean getIsCritical() {
        return this.isCritical;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getFixVersions() {
        return this.fixVersions;
    }

    public String getNxvdVersion() {
        return this.nxvdVersion;
    }

    public OffsetDateTime getNxvdCreatedTime() {
        return this.nxvdCreatedTime;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    @JsonProperty(value="severity")
    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    @Override
    public String toString() {
        return "Vulnerability(cesaId=" + this.getCesaId() + ", cveIds=" + this.getCveIds() + ", isCritical=" + this.getIsCritical() + ", description=" + this.getDescription() + ", fixVersions=" + this.getFixVersions() + ", nxvdVersion=" + this.getNxvdVersion() + ", nxvdCreatedTime=" + this.getNxvdCreatedTime() + ", severity=" + (Object)((Object)this.getSeverity()) + ")";
    }

    public static class VulnerabilityBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String cesaId;
        private List<String> cveIds;
        private Boolean isCritical;
        private String description;
        private List<String> fixVersions;
        private Severity severity;
        private String nxvdVersion;
        private OffsetDateTime nxvdCreatedTime;

        VulnerabilityBuilder() {
        }

        public VulnerabilityBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VulnerabilityBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VulnerabilityBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VulnerabilityBuilder cesaId(String cesaId) {
            this.cesaId = cesaId;
            return this;
        }

        public VulnerabilityBuilder cveIds(List<String> cveIds) {
            this.cveIds = cveIds;
            return this;
        }

        public VulnerabilityBuilder isCritical(Boolean isCritical) {
            this.isCritical = isCritical;
            return this;
        }

        public VulnerabilityBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VulnerabilityBuilder fixVersions(List<String> fixVersions) {
            this.fixVersions = fixVersions;
            return this;
        }

        public VulnerabilityBuilder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public VulnerabilityBuilder nxvdVersion(String nxvdVersion) {
            this.nxvdVersion = nxvdVersion;
            return this;
        }

        public VulnerabilityBuilder nxvdCreatedTime(OffsetDateTime nxvdCreatedTime) {
            this.nxvdCreatedTime = nxvdCreatedTime;
            return this;
        }

        public Vulnerability build() {
            return new Vulnerability(this.tenantId, this.extId, this.links, this.cesaId, this.cveIds, this.isCritical, this.description, this.fixVersions, this.severity, this.nxvdVersion, this.nxvdCreatedTime);
        }

        public String toString() {
            return "Vulnerability.VulnerabilityBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", cesaId=" + this.cesaId + ", cveIds=" + this.cveIds + ", isCritical=" + this.isCritical + ", description=" + this.description + ", fixVersions=" + this.fixVersions + ", severity=" + (Object)((Object)this.severity) + ", nxvdVersion=" + this.nxvdVersion + ", nxvdCreatedTime=" + this.nxvdCreatedTime + ")";
        }
    }
}

