/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.security.v4.report;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.sec.common.v1.response.ApiLink;
import com.nutanix.dp1.sec.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import com.nutanix.dp1.sec.security.v4.report.SoftwareType;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilitySummary
extends ExternalizableAbstractModel
implements Serializable,
SecObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VulnerabilitySummary.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterExtId = null;
    @Size(max=199)
    private @Size(max=199) String installedVersion = null;
    @Size(min=0, max=1024)
    private @Size(min=0, max=1024) List<String> cveIds = null;
    @JsonProperty(value="softwareType")
    public SoftwareType softwareType = null;

    public VulnerabilitySummary() {
    }

    public VulnerabilitySummary(String tenantId, String extId, List<ApiLink> links, String clusterExtId, String installedVersion, List<String> cveIds, SoftwareType softwareType) {
        super(tenantId, extId, links);
        this.setClusterExtId(clusterExtId);
        this.setInstalledVersion(installedVersion);
        this.setCveIds(cveIds);
        this.setSoftwareType(softwareType);
    }

    @Override
    protected String initialize$objectType() {
        return "security.v4.report.VulnerabilitySummary";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setClusterExtId(String clusterExtId) {
        if (this.clusterExtId == null) {
            this.clusterExtId = clusterExtId;
        } else {
            log.warn("Read-only property clusterExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setInstalledVersion(String installedVersion) {
        if (this.installedVersion == null) {
            this.installedVersion = installedVersion;
        } else {
            log.warn("Read-only property installedVersion already contains a non-null value and cannot be set again");
        }
    }

    public void setCveIds(List<String> cveIds) {
        if (this.cveIds == null) {
            this.cveIds = cveIds;
        } else {
            log.warn("Read-only property cveIds already contains a non-null value and cannot be set again");
        }
    }

    public static VulnerabilitySummaryBuilder VulnerabilitySummaryBuilder() {
        return new VulnerabilitySummaryBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VulnerabilitySummary)) {
            return false;
        }
        VulnerabilitySummary other = (VulnerabilitySummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clusterExtId = this.getClusterExtId();
        String other$clusterExtId = other.getClusterExtId();
        if (this$clusterExtId == null ? other$clusterExtId != null : !this$clusterExtId.equals(other$clusterExtId)) {
            return false;
        }
        String this$installedVersion = this.getInstalledVersion();
        String other$installedVersion = other.getInstalledVersion();
        if (this$installedVersion == null ? other$installedVersion != null : !this$installedVersion.equals(other$installedVersion)) {
            return false;
        }
        List<String> this$cveIds = this.getCveIds();
        List<String> other$cveIds = other.getCveIds();
        if (this$cveIds == null ? other$cveIds != null : !((Object)this$cveIds).equals(other$cveIds)) {
            return false;
        }
        SoftwareType this$softwareType = this.getSoftwareType();
        SoftwareType other$softwareType = other.getSoftwareType();
        return !(this$softwareType == null ? other$softwareType != null : !((Object)((Object)this$softwareType)).equals((Object)other$softwareType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VulnerabilitySummary;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clusterExtId = this.getClusterExtId();
        result = result * 59 + ($clusterExtId == null ? 43 : $clusterExtId.hashCode());
        String $installedVersion = this.getInstalledVersion();
        result = result * 59 + ($installedVersion == null ? 43 : $installedVersion.hashCode());
        List<String> $cveIds = this.getCveIds();
        result = result * 59 + ($cveIds == null ? 43 : ((Object)$cveIds).hashCode());
        SoftwareType $softwareType = this.getSoftwareType();
        result = result * 59 + ($softwareType == null ? 43 : ((Object)((Object)$softwareType)).hashCode());
        return result;
    }

    public String getClusterExtId() {
        return this.clusterExtId;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public List<String> getCveIds() {
        return this.cveIds;
    }

    public SoftwareType getSoftwareType() {
        return this.softwareType;
    }

    @JsonProperty(value="softwareType")
    public void setSoftwareType(SoftwareType softwareType) {
        this.softwareType = softwareType;
    }

    @Override
    public String toString() {
        return "VulnerabilitySummary(clusterExtId=" + this.getClusterExtId() + ", installedVersion=" + this.getInstalledVersion() + ", cveIds=" + this.getCveIds() + ", softwareType=" + (Object)((Object)this.getSoftwareType()) + ")";
    }

    public static class VulnerabilitySummaryBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String clusterExtId;
        private String installedVersion;
        private List<String> cveIds;
        private SoftwareType softwareType;

        VulnerabilitySummaryBuilder() {
        }

        public VulnerabilitySummaryBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VulnerabilitySummaryBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VulnerabilitySummaryBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VulnerabilitySummaryBuilder clusterExtId(String clusterExtId) {
            this.clusterExtId = clusterExtId;
            return this;
        }

        public VulnerabilitySummaryBuilder installedVersion(String installedVersion) {
            this.installedVersion = installedVersion;
            return this;
        }

        public VulnerabilitySummaryBuilder cveIds(List<String> cveIds) {
            this.cveIds = cveIds;
            return this;
        }

        public VulnerabilitySummaryBuilder softwareType(SoftwareType softwareType) {
            this.softwareType = softwareType;
            return this;
        }

        public VulnerabilitySummary build() {
            return new VulnerabilitySummary(this.tenantId, this.extId, this.links, this.clusterExtId, this.installedVersion, this.cveIds, this.softwareType);
        }

        public String toString() {
            return "VulnerabilitySummary.VulnerabilitySummaryBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", clusterExtId=" + this.clusterExtId + ", installedVersion=" + this.installedVersion + ", cveIds=" + this.cveIds + ", softwareType=" + (Object)((Object)this.softwareType) + ")";
        }
    }
}

