/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.sec.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.sec.deserializers.SecObjectTypeTypedObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSerializerUtils {
    private static final Logger log = LoggerFactory.getLogger(SecSerializerUtils.class);
    public static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();

    private SecSerializerUtils() {
    }

    public static void serializeListWithoutHiddenFields(List<SecObjectTypeTypedObject> objectTypeTypedObjectList, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (objectTypeTypedObjectList.isEmpty()) {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeEndArray();
            return;
        }
        Class<?> clazz = objectTypeTypedObjectList.get(0).getClass();
        log.debug("Custom serializing complex list of type " + clazz + " to omit platform fields from items except first");
        jsonGenerator.writeStartArray();
        serializerProvider.defaultSerializeValue((Object)objectTypeTypedObjectList.get(0), jsonGenerator);
        log.debug("Serialized first item of complex list of type " + clazz + " normally");
        for (int i = 1; i < objectTypeTypedObjectList.size(); ++i) {
            SecSerializerUtils.serializeListItemsWithoutHiddenFields(objectTypeTypedObjectList.get(i), clazz, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
        log.debug("Custom serialization for complex list of type " + clazz + " is complete");
    }

    public static void serializeListItemsWithoutHiddenFields(SecObjectTypeTypedObject object, Class clazz, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (object != null) {
            try {
                String objectTypeValue = object.get$objectType();
                Map<String, Object> reservedValue = object.get$reserved();
                Field objectType = FieldUtils.getField((Class)clazz, (String)"$objectType", (boolean)true);
                objectType.setAccessible(true);
                objectType.set(object, null);
                Field unknownFields = FieldUtils.getField((Class)clazz, (String)"$unknownFields", (boolean)true);
                unknownFields.setAccessible(true);
                Map unknownFieldsValue = (Map)unknownFields.get(object);
                unknownFields.set(object, null);
                object.get$reserved().clear();
                serializerProvider.defaultSerializeValue((Object)object, jsonGenerator);
                objectType.set(object, objectTypeValue);
                object.get$reserved().putAll(reservedValue);
                unknownFields.set(object, unknownFieldsValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to remove platform generated fields ($objectType, $reserved, $unknownFields) failed with error :" + e);
            }
        }
    }

    public static ArrayList<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != SecObjectTypeTypedObject.class && clazz.getSuperclass() != null) {
            allFields.addAll(SecSerializerUtils.getAllFields(clazz.getSuperclass()));
        }
        return allFields;
    }
}

