/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.sec.java.client.api;

import com.nutanix.dp1.sec.security.v4.config.CreateKeyManagementServerApiResponse;
import com.nutanix.dp1.sec.security.v4.config.DeleteKeyManagementServerApiResponse;
import com.nutanix.dp1.sec.security.v4.config.GetKeyManagementServerApiResponse;
import com.nutanix.dp1.sec.security.v4.config.KeyManagementServer;
import com.nutanix.dp1.sec.security.v4.config.ListKeyManagementServersApiResponse;
import com.nutanix.dp1.sec.security.v4.config.UpdateKeyManagementServerApiResponse;
import com.nutanix.sec.java.client.ApiClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.sec.java.client.api.KeyManagementServersApi")
public class KeyManagementServersApi {
    private static final Logger log = LoggerFactory.getLogger(KeyManagementServersApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public KeyManagementServersApi() {
        this(new ApiClient());
    }

    @Autowired
    public KeyManagementServersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateKeyManagementServerApiResponse createKeyManagementServer(KeyManagementServer body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        KeyManagementServer postBody = body;
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling createKeyManagementServer");
        }
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/security/v4.0/config/key-management-servers").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<CreateKeyManagementServerApiResponse> returnType = new ParameterizedTypeReference<CreateKeyManagementServerApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public DeleteKeyManagementServerApiResponse deleteKeyManagementServerById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling deleteKeyManagementServerById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/security/v4.0/config/key-management-servers/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<DeleteKeyManagementServerApiResponse> returnType = new ParameterizedTypeReference<DeleteKeyManagementServerApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.DELETE, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetKeyManagementServerApiResponse getKeyManagementServerById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getKeyManagementServerById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/security/v4.0/config/key-management-servers/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<GetKeyManagementServerApiResponse> returnType = new ParameterizedTypeReference<GetKeyManagementServerApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ListKeyManagementServersApiResponse listKeyManagementServers(Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/security/v4.0/config/key-management-servers").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ListKeyManagementServersApiResponse> returnType = new ParameterizedTypeReference<ListKeyManagementServersApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public UpdateKeyManagementServerApiResponse updateKeyManagementServerById(String extId, KeyManagementServer body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        KeyManagementServer postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling updateKeyManagementServerById");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling updateKeyManagementServerById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/security/v4.0/config/key-management-servers/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<UpdateKeyManagementServerApiResponse> returnType = new ParameterizedTypeReference<UpdateKeyManagementServerApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.PUT, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

