/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal;

import com.nvidia.cuvs.CagraCompressionParams;
import com.nvidia.cuvs.CagraIndex;
import com.nvidia.cuvs.CagraIndexParams;
import com.nvidia.cuvs.CagraMergeParams;
import com.nvidia.cuvs.CagraQuery;
import com.nvidia.cuvs.CagraSearchParams;
import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.Dataset;
import com.nvidia.cuvs.SearchResults;
import com.nvidia.cuvs.internal.CagraSearchResults;
import com.nvidia.cuvs.internal.CuVSResourcesImpl;
import com.nvidia.cuvs.internal.DatasetImpl;
import com.nvidia.cuvs.internal.common.LinkerHelper;
import com.nvidia.cuvs.internal.common.Util;
import com.nvidia.cuvs.internal.panama.cuvsCagraCompressionParams;
import com.nvidia.cuvs.internal.panama.cuvsCagraIndex;
import com.nvidia.cuvs.internal.panama.cuvsCagraIndexParams;
import com.nvidia.cuvs.internal.panama.cuvsCagraMergeParams;
import com.nvidia.cuvs.internal.panama.cuvsCagraSearchParams;
import com.nvidia.cuvs.internal.panama.cuvsIvfPqIndexParams;
import com.nvidia.cuvs.internal.panama.cuvsIvfPqParams;
import com.nvidia.cuvs.internal.panama.cuvsIvfPqSearchParams;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.UUID;

public class CagraIndexImpl
implements CagraIndex {
    private static final MethodHandle indexMethodHandle = LinkerHelper.downcallHandle("build_cagra_index", FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, LinkerHelper.C_LONG, LinkerHelper.C_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, LinkerHelper.C_INT), new Linker.Option[0]);
    private static final MethodHandle searchMethodHandle = LinkerHelper.downcallHandle("search_cagra_index", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS, LinkerHelper.C_INT, LinkerHelper.C_LONG, LinkerHelper.C_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, LinkerHelper.C_LONG), new Linker.Option[0]);
    private static final MethodHandle serializeMethodHandle = LinkerHelper.downcallHandle("serialize_cagra_index", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
    private static final MethodHandle deserializeMethodHandle = LinkerHelper.downcallHandle("deserialize_cagra_index", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
    private static final MethodHandle destroyIndexMethodHandle = LinkerHelper.downcallHandle("destroy_cagra_index", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
    private static final MethodHandle serializeCAGRAIndexToHNSWMethodHandle = LinkerHelper.downcallHandle("serialize_cagra_index_to_hnsw", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
    private static final MethodHandle mergeMethodHandle = LinkerHelper.downcallHandle("merge_cagra_indexes", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, LinkerHelper.C_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
    private final float[][] vectors;
    private final Dataset dataset;
    private final CuVSResourcesImpl resources;
    private final CagraIndexParams cagraIndexParameters;
    private final CagraCompressionParams cagraCompressionParams;
    private final IndexReference cagraIndexReference;
    private boolean destroyed;

    private CagraIndexImpl(CagraIndexParams indexParameters, CagraCompressionParams cagraCompressionParams, float[][] vectors, Dataset dataset, CuVSResourcesImpl resources) throws Throwable {
        this.cagraIndexParameters = indexParameters;
        this.cagraCompressionParams = cagraCompressionParams;
        this.vectors = vectors;
        this.dataset = dataset;
        this.resources = resources;
        this.cagraIndexReference = this.build();
    }

    private CagraIndexImpl(InputStream inputStream, CuVSResourcesImpl resources) throws Throwable {
        this.cagraIndexParameters = null;
        this.cagraCompressionParams = null;
        this.vectors = null;
        this.dataset = null;
        this.resources = resources;
        this.cagraIndexReference = this.deserialize(inputStream);
    }

    private CagraIndexImpl(IndexReference indexReference, CuVSResourcesImpl resources) {
        this.vectors = null;
        this.cagraIndexParameters = null;
        this.cagraCompressionParams = null;
        this.dataset = null;
        this.resources = resources;
        this.cagraIndexReference = indexReference;
        this.destroyed = false;
    }

    private void checkNotDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("destroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyIndex() throws Throwable {
        this.checkNotDestroyed();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment returnValue = arena.allocate(LinkerHelper.C_INT);
            destroyIndexMethodHandle.invokeExact(this.cagraIndexReference.getMemorySegment(), returnValue);
            Util.checkError(returnValue.get(LinkerHelper.C_INT, 0L), "destroyIndexMethodHandle");
        }
        finally {
            this.destroyed = true;
        }
        if (this.dataset != null) {
            this.dataset.close();
        }
    }

    private IndexReference build() throws Throwable {
        long rows;
        long l = rows = this.dataset != null ? (long)this.dataset.size() : (long)this.vectors.length;
        long cols = this.dataset != null ? (long)this.dataset.dimensions() : (long)(rows > 0L ? this.vectors[0].length : 0);
        MemorySegment indexParamsMemorySegment = this.cagraIndexParameters != null ? CagraIndexImpl.segmentFromIndexParams(this.resources, this.cagraIndexParameters) : MemorySegment.NULL;
        int numWriterThreads = this.cagraIndexParameters != null ? this.cagraIndexParameters.getNumWriterThreads() : 1;
        MemorySegment compressionParamsMemorySegment = this.cagraCompressionParams != null ? this.segmentFromCompressionParams(this.cagraCompressionParams) : MemorySegment.NULL;
        MemorySegment dataSeg = this.dataset != null ? ((DatasetImpl)this.dataset).seg : Util.buildMemorySegment(this.resources.getArena(), this.vectors);
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment returnValue = localArena.allocate(LinkerHelper.C_INT);
            MemorySegment indexSeg = indexMethodHandle.invokeExact(dataSeg, rows, cols, this.resources.getMemorySegment(), returnValue, indexParamsMemorySegment, compressionParamsMemorySegment, numWriterThreads);
            Util.checkError(returnValue.get(LinkerHelper.C_INT, 0L), "indexMethodHandle");
            IndexReference indexReference = new IndexReference(indexSeg);
            return indexReference;
        }
    }

    @Override
    public SearchResults search(CagraQuery query) throws Throwable {
        this.checkNotDestroyed();
        int topK = query.getMapping() != null ? Math.min(query.getMapping().size(), query.getTopK()) : query.getTopK();
        long numQueries = query.getQueryVectors().length;
        long numBlocks = (long)topK * numQueries;
        int vectorDimension = numQueries > 0L ? query.getQueryVectors()[0].length : 0;
        SequenceLayout neighborsSequenceLayout = MemoryLayout.sequenceLayout(numBlocks, LinkerHelper.C_INT);
        SequenceLayout distancesSequenceLayout = MemoryLayout.sequenceLayout(numBlocks, LinkerHelper.C_FLOAT);
        MemorySegment neighborsMemorySegment = this.resources.getArena().allocate(neighborsSequenceLayout);
        MemorySegment distancesMemorySegment = this.resources.getArena().allocate(distancesSequenceLayout);
        MemorySegment floatsSeg = Util.buildMemorySegment(this.resources.getArena(), query.getQueryVectors());
        long prefilterDataLength = 0L;
        MemorySegment prefilterData = MemorySegment.NULL;
        if (query.getPrefilter() != null) {
            long[] longArray = query.getPrefilter().toLongArray();
            prefilterData = Util.buildMemorySegment(this.resources.getArena(), longArray);
            prefilterDataLength = query.getNumDocs();
        }
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment returnValue = localArena.allocate(LinkerHelper.C_INT);
            searchMethodHandle.invokeExact(this.cagraIndexReference.getMemorySegment(), floatsSeg, topK, numQueries, vectorDimension, this.resources.getMemorySegment(), neighborsMemorySegment, distancesMemorySegment, returnValue, this.segmentFromSearchParams(query.getCagraSearchParameters()), prefilterData, prefilterDataLength);
            Util.checkError(returnValue.get(LinkerHelper.C_INT, 0L), "searchMethodHandle");
        }
        return new CagraSearchResults(neighborsSequenceLayout, distancesSequenceLayout, neighborsMemorySegment, distancesMemorySegment, topK, query.getMapping(), numQueries);
    }

    @Override
    public void serialize(OutputStream outputStream) throws Throwable {
        Path p = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".cag", new FileAttribute[0]);
        this.serialize(outputStream, p, 1024);
    }

    @Override
    public void serialize(OutputStream outputStream, int bufferLength) throws Throwable {
        Path p = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".cag", new FileAttribute[0]);
        this.serialize(outputStream, p, bufferLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream outputStream, Path tempFile, int bufferLength) throws Throwable {
        this.checkNotDestroyed();
        tempFile = tempFile.toAbsolutePath();
        MemorySegment pathSeg = Util.buildMemorySegment(this.resources.getArena(), tempFile.toString());
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment returnValue = localArena.allocate(LinkerHelper.C_INT);
            serializeMethodHandle.invokeExact(this.resources.getMemorySegment(), this.cagraIndexReference.getMemorySegment(), returnValue, pathSeg);
            Util.checkError(returnValue.get(LinkerHelper.C_INT, 0L), "serializeMethodHandle");
            try (FileInputStream fileInputStream = new FileInputStream(tempFile.toFile());){
                byte[] chunk = new byte[bufferLength];
                int chunkLength = 0;
                while ((chunkLength = fileInputStream.read(chunk)) != -1) {
                    outputStream.write(chunk, 0, chunkLength);
                }
            }
            finally {
                Files.deleteIfExists(tempFile);
            }
        }
    }

    @Override
    public void serializeToHNSW(OutputStream outputStream) throws Throwable {
        Path p = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".hnsw", new FileAttribute[0]);
        this.serializeToHNSW(outputStream, p, 1024);
    }

    @Override
    public void serializeToHNSW(OutputStream outputStream, int bufferLength) throws Throwable {
        Path p = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".hnsw", new FileAttribute[0]);
        this.serializeToHNSW(outputStream, p, bufferLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeToHNSW(OutputStream outputStream, Path tempFile, int bufferLength) throws Throwable {
        this.checkNotDestroyed();
        tempFile = tempFile.toAbsolutePath();
        MemorySegment pathSeg = Util.buildMemorySegment(this.resources.getArena(), tempFile.toString());
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment returnValue = localArena.allocate(LinkerHelper.C_INT);
            serializeCAGRAIndexToHNSWMethodHandle.invokeExact(this.resources.getMemorySegment(), pathSeg, this.cagraIndexReference.getMemorySegment(), returnValue);
            Util.checkError(returnValue.get(LinkerHelper.C_INT, 0L), "serializeCAGRAIndexToHNSWMethodHandle");
            try (FileInputStream fileInputStream = new FileInputStream(tempFile.toFile());){
                int chunkLength;
                byte[] chunk = new byte[bufferLength];
                while ((chunkLength = fileInputStream.read(chunk)) != -1) {
                    outputStream.write(chunk, 0, chunkLength);
                }
            }
            finally {
                Files.deleteIfExists(tempFile);
            }
        }
    }

    private IndexReference deserialize(InputStream inputStream) throws Throwable {
        return this.deserialize(inputStream, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReference deserialize(InputStream inputStream, int bufferLength) throws Throwable {
        Path tmpIndexFile = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".cag", new FileAttribute[0]);
        tmpIndexFile = tmpIndexFile.toAbsolutePath();
        IndexReference indexReference = new IndexReference(this.resources);
        try (InputStream in = inputStream;
             FileOutputStream fileOutputStream = new FileOutputStream(tmpIndexFile.toFile());){
            in.transferTo(fileOutputStream);
            MemorySegment pathSeg = Util.buildMemorySegment(this.resources.getArena(), tmpIndexFile.toString());
            try (Arena localArena = Arena.ofConfined();){
                MemorySegment returnValue = localArena.allocate(LinkerHelper.C_INT);
                deserializeMethodHandle.invokeExact(this.resources.getMemorySegment(), indexReference.getMemorySegment(), returnValue, pathSeg);
                Util.checkError(returnValue.get(LinkerHelper.C_INT, 0L), "deserializeMethodHandle");
            }
        }
        finally {
            Files.deleteIfExists(tmpIndexFile);
        }
        return indexReference;
    }

    @Override
    public CagraIndexParams getCagraIndexParameters() {
        return this.cagraIndexParameters;
    }

    @Override
    public CuVSResourcesImpl getCuVSResources() {
        return this.resources;
    }

    private MemorySegment segmentFromCompressionParams(CagraCompressionParams params2) {
        MemorySegment seg = cuvsCagraCompressionParams.allocate(this.resources.getArena());
        cuvsCagraCompressionParams.pq_bits(seg, params2.getPqBits());
        cuvsCagraCompressionParams.pq_dim(seg, params2.getPqDim());
        cuvsCagraCompressionParams.vq_n_centers(seg, params2.getVqNCenters());
        cuvsCagraCompressionParams.kmeans_n_iters(seg, params2.getKmeansNIters());
        cuvsCagraCompressionParams.vq_kmeans_trainset_fraction(seg, params2.getVqKmeansTrainsetFraction());
        cuvsCagraCompressionParams.pq_kmeans_trainset_fraction(seg, params2.getPqKmeansTrainsetFraction());
        return seg;
    }

    private static MemorySegment segmentFromIndexParams(CuVSResourcesImpl resources, CagraIndexParams params2) {
        MemorySegment seg = cuvsCagraIndexParams.allocate(resources.getArena());
        cuvsCagraIndexParams.intermediate_graph_degree(seg, params2.getIntermediateGraphDegree());
        cuvsCagraIndexParams.graph_degree(seg, params2.getGraphDegree());
        cuvsCagraIndexParams.build_algo(seg, params2.getCagraGraphBuildAlgo().value);
        cuvsCagraIndexParams.nn_descent_niter(seg, params2.getNNDescentNumIterations());
        cuvsCagraIndexParams.metric(seg, params2.getCuvsDistanceType().value);
        if (params2.getCagraGraphBuildAlgo().equals((Object)CagraIndexParams.CagraGraphBuildAlgo.IVF_PQ)) {
            MemorySegment ivfpqIndexParamsMemorySegment = cuvsIvfPqIndexParams.allocate(resources.getArena());
            cuvsIvfPqIndexParams.metric(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().getMetric().value);
            cuvsIvfPqIndexParams.metric_arg(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().getMetricArg());
            cuvsIvfPqIndexParams.add_data_on_build(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().isAddDataOnBuild());
            cuvsIvfPqIndexParams.n_lists(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().getnLists());
            cuvsIvfPqIndexParams.kmeans_n_iters(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().getKmeansNIters());
            cuvsIvfPqIndexParams.kmeans_trainset_fraction(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().getKmeansTrainsetFraction());
            cuvsIvfPqIndexParams.pq_bits(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().getPqBits());
            cuvsIvfPqIndexParams.pq_dim(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().getPqDim());
            cuvsIvfPqIndexParams.codebook_kind(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().getCodebookKind().value);
            cuvsIvfPqIndexParams.force_random_rotation(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().isForceRandomRotation());
            cuvsIvfPqIndexParams.conservative_memory_allocation(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().isConservativeMemoryAllocation());
            cuvsIvfPqIndexParams.max_train_points_per_pq_code(ivfpqIndexParamsMemorySegment, params2.getCuVSIvfPqParams().getIndexParams().getMaxTrainPointsPerPqCode());
            MemorySegment ivfpqSearchParamsMemorySegment = cuvsIvfPqSearchParams.allocate(resources.getArena());
            cuvsIvfPqSearchParams.n_probes(ivfpqSearchParamsMemorySegment, params2.getCuVSIvfPqParams().getSearchParams().getnProbes());
            cuvsIvfPqSearchParams.lut_dtype(ivfpqSearchParamsMemorySegment, params2.getCuVSIvfPqParams().getSearchParams().getLutDtype().value);
            cuvsIvfPqSearchParams.internal_distance_dtype(ivfpqSearchParamsMemorySegment, params2.getCuVSIvfPqParams().getSearchParams().getInternalDistanceDtype().value);
            cuvsIvfPqSearchParams.preferred_shmem_carveout(ivfpqSearchParamsMemorySegment, params2.getCuVSIvfPqParams().getSearchParams().getPreferredShmemCarveout());
            MemorySegment cuvsIvfPqParamsMemorySegment = cuvsIvfPqParams.allocate(resources.getArena());
            cuvsIvfPqParams.ivf_pq_build_params(cuvsIvfPqParamsMemorySegment, ivfpqIndexParamsMemorySegment);
            cuvsIvfPqParams.ivf_pq_search_params(cuvsIvfPqParamsMemorySegment, ivfpqSearchParamsMemorySegment);
            cuvsIvfPqParams.refinement_rate(cuvsIvfPqParamsMemorySegment, params2.getCuVSIvfPqParams().getRefinementRate());
            cuvsCagraIndexParams.graph_build_params(seg, cuvsIvfPqParamsMemorySegment);
        }
        return seg;
    }

    private MemorySegment segmentFromSearchParams(CagraSearchParams params2) {
        MemorySegment seg = cuvsCagraSearchParams.allocate(this.resources.getArena());
        cuvsCagraSearchParams.max_queries(seg, params2.getMaxQueries());
        cuvsCagraSearchParams.itopk_size(seg, params2.getITopKSize());
        cuvsCagraSearchParams.max_iterations(seg, params2.getMaxIterations());
        if (params2.getCagraSearchAlgo() != null) {
            cuvsCagraSearchParams.algo(seg, params2.getCagraSearchAlgo().value);
        }
        cuvsCagraSearchParams.team_size(seg, params2.getTeamSize());
        cuvsCagraSearchParams.search_width(seg, params2.getSearchWidth());
        cuvsCagraSearchParams.min_iterations(seg, params2.getMinIterations());
        cuvsCagraSearchParams.thread_block_size(seg, params2.getThreadBlockSize());
        if (params2.getHashMapMode() != null) {
            cuvsCagraSearchParams.hashmap_mode(seg, params2.getHashMapMode().value);
        }
        cuvsCagraSearchParams.hashmap_max_fill_rate(seg, params2.getHashMapMaxFillRate());
        cuvsCagraSearchParams.num_random_samplings(seg, params2.getNumRandomSamplings());
        cuvsCagraSearchParams.rand_xor_mask(seg, params2.getRandXORMask());
        return seg;
    }

    public static CagraIndex.Builder newBuilder(CuVSResources cuvsResources) {
        Objects.requireNonNull(cuvsResources);
        if (!(cuvsResources instanceof CuVSResourcesImpl)) {
            throw new IllegalArgumentException("Unsupported " + String.valueOf(cuvsResources));
        }
        return new Builder((CuVSResourcesImpl)cuvsResources);
    }

    public static CagraIndex merge(CagraIndex[] indexes) throws Throwable {
        return CagraIndexImpl.merge(indexes, null);
    }

    public static CagraIndex merge(CagraIndex[] indexes, CagraMergeParams mergeParams) throws Throwable {
        CuVSResourcesImpl resources = (CuVSResourcesImpl)indexes[0].getCuVSResources();
        IndexReference mergedIndexReference = new IndexReference(resources);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment indexesSegment = arena.allocate((long)indexes.length * ValueLayout.ADDRESS.byteSize());
            for (int i = 0; i < indexes.length; ++i) {
                CagraIndexImpl indexImpl = (CagraIndexImpl)indexes[i];
                indexesSegment.setAtIndex(ValueLayout.ADDRESS, (long)i, indexImpl.cagraIndexReference.getMemorySegment());
            }
            MemorySegment returnValue = arena.allocate(LinkerHelper.C_INT);
            MemorySegment mergeParamsSegment = MemorySegment.NULL;
            if (mergeParams != null) {
                mergeParamsSegment = CagraIndexImpl.createMergeParamsSegment(mergeParams, resources);
            }
            mergeMethodHandle.invokeExact(resources.getMemorySegment(), indexesSegment, mergedIndexReference.getMemorySegment(), indexes.length, returnValue, mergeParamsSegment);
            Util.checkError(returnValue.get(LinkerHelper.C_INT, 0L), "mergeMethodHandle");
        }
        return new CagraIndexImpl(mergedIndexReference, resources);
    }

    private static MemorySegment createMergeParamsSegment(CagraMergeParams mergeParams, CuVSResourcesImpl resources) {
        MemorySegment seg = cuvsCagraMergeParams.allocate(resources.getArena());
        if (mergeParams.getOutputIndexParams() != null) {
            MemorySegment outputIndexParamsSeg = CagraIndexImpl.segmentFromIndexParams(resources, mergeParams.getOutputIndexParams());
            cuvsCagraMergeParams.output_index_params(seg, outputIndexParamsSeg);
        } else {
            cuvsCagraMergeParams.output_index_params(seg, MemorySegment.NULL);
        }
        cuvsCagraMergeParams.strategy(seg, mergeParams.getStrategy().value);
        return seg;
    }

    public static class IndexReference {
        private final MemorySegment memorySegment;

        protected IndexReference(CuVSResourcesImpl resources) {
            this.memorySegment = cuvsCagraIndex.allocate(resources.getArena());
        }

        protected IndexReference(MemorySegment indexMemorySegment) {
            this.memorySegment = indexMemorySegment;
        }

        protected MemorySegment getMemorySegment() {
            return this.memorySegment;
        }
    }

    public static class Builder
    implements CagraIndex.Builder {
        private float[][] vectors;
        private Dataset dataset;
        private CagraIndexParams cagraIndexParams;
        private CagraCompressionParams cagraCompressionParams;
        private CuVSResourcesImpl cuvsResources;
        private InputStream inputStream;

        public Builder(CuVSResourcesImpl cuvsResources) {
            this.cuvsResources = cuvsResources;
        }

        @Override
        public Builder from(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        @Override
        public Builder withDataset(float[][] vectors) {
            this.vectors = vectors;
            return this;
        }

        @Override
        public Builder withDataset(Dataset dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public Builder withIndexParams(CagraIndexParams cagraIndexParameters) {
            this.cagraIndexParams = cagraIndexParameters;
            return this;
        }

        @Override
        public Builder withCompressionParams(CagraCompressionParams cagraCompressionParams) {
            this.cagraCompressionParams = cagraCompressionParams;
            return this;
        }

        @Override
        public CagraIndexImpl build() throws Throwable {
            if (this.inputStream != null) {
                return new CagraIndexImpl(this.inputStream, this.cuvsResources);
            }
            if (this.vectors != null && this.dataset != null) {
                throw new IllegalArgumentException("Please specify only one type of dataset (a float[] or a Dataset instance)");
            }
            return new CagraIndexImpl(this.cagraIndexParams, this.cagraCompressionParams, this.vectors, this.dataset, this.cuvsResources);
        }
    }
}

