/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal;

import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.internal.common.LinkerHelper;
import com.nvidia.cuvs.internal.common.Util;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.file.Path;

public class CuVSResourcesImpl
implements CuVSResources {
    static final MethodHandle createResourcesMethodHandle = LinkerHelper.downcallHandle("create_resources", FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
    private static final MethodHandle destroyResourcesMethodHandle = LinkerHelper.downcallHandle("destroy_resources", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
    private final Path tempDirectory;
    private final Arena arena;
    private final MemorySegment resourcesMemorySegment;
    private boolean destroyed;

    public CuVSResourcesImpl(Path tempDirectory) throws Throwable {
        this.tempDirectory = tempDirectory;
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment returnValue = localArena.allocate(LinkerHelper.C_INT);
            this.resourcesMemorySegment = createResourcesMethodHandle.invokeExact(returnValue);
            Util.checkError(returnValue.get(LinkerHelper.C_INT, 0L), "createResourcesMethodHandle");
        }
        this.arena = Arena.ofShared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.checkNotDestroyed();
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment returnValue = localArena.allocate(LinkerHelper.C_INT);
            destroyResourcesMethodHandle.invokeExact(this.resourcesMemorySegment, returnValue);
            Util.checkError(returnValue.get(LinkerHelper.C_INT, 0L), "destroyResourcesMethodHandle");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.destroyed = true;
        }
        if (!this.arena.scope().isAlive()) {
            this.arena.close();
        }
    }

    @Override
    public Path tempDirectory() {
        return this.tempDirectory;
    }

    private void checkNotDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("destroyed");
        }
    }

    protected MemorySegment getMemorySegment() {
        this.checkNotDestroyed();
        return this.resourcesMemorySegment;
    }

    protected Arena getArena() {
        this.checkNotDestroyed();
        return this.arena;
    }

    public class GPUInfo {
        private final int gpuId;
        private final long freeMemory;
        private final long totalMemory;
        private final float computeCapability;

        public GPUInfo(CuVSResourcesImpl this$0, int gpuId, long freeMemory, long totalMemory, float computeCapability) {
            this.gpuId = gpuId;
            this.freeMemory = freeMemory;
            this.totalMemory = totalMemory;
            this.computeCapability = computeCapability;
        }

        public int getGpuId() {
            return this.gpuId;
        }

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public float getComputeCapability() {
            return this.computeCapability;
        }

        public String toString() {
            return "GPUInfo [gpuId=" + this.gpuId + ", freeMemory=" + this.freeMemory + ", totalMemory=" + this.totalMemory + ", computeCapability=" + this.computeCapability + "]";
        }
    }
}

