/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal;

import com.nvidia.cuvs.Dataset;
import com.nvidia.cuvs.internal.common.LinkerHelper;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SequenceLayout;

public class DatasetImpl
implements Dataset {
    private final Arena arena;
    protected final MemorySegment seg;
    private final int size;
    private final int dimensions;
    private int current = 0;

    public DatasetImpl(int size, int dimensions) {
        this.size = size;
        this.dimensions = dimensions;
        SequenceLayout dataMemoryLayout = MemoryLayout.sequenceLayout(size * dimensions, LinkerHelper.C_FLOAT);
        this.arena = Arena.ofShared();
        this.seg = this.arena.allocate(dataMemoryLayout);
    }

    @Override
    public void addVector(float[] vector) {
        if (this.current >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        MemorySegment.copy(vector, 0, this.seg, LinkerHelper.C_FLOAT, (long)(this.current++ * this.dimensions) * LinkerHelper.C_FLOAT.byteSize(), this.dimensions);
    }

    @Override
    public void close() {
        if (!this.arena.scope().isAlive()) {
            this.arena.close();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int dimensions() {
        return this.dimensions;
    }
}

