/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal.common;

import com.nvidia.cuvs.internal.common.LoaderUtils;
import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.file.Path;

public class LinkerHelper {
    private static final Linker LINKER = Linker.nativeLinker();
    private static final SymbolLookup SYMBOL_LOOKUP;
    public static final ValueLayout.OfByte C_CHAR;
    public static final ValueLayout.OfInt C_INT;
    public static final ValueLayout.OfLong C_LONG;
    public static final ValueLayout.OfFloat C_FLOAT;
    public static final AddressLayout C_POINTER;

    static MemorySegment functionAddress(String function) {
        return SYMBOL_LOOKUP.find(function).orElseThrow(() -> new LinkageError("Native function " + function + " could not be found"));
    }

    public static MethodHandle downcallHandle(String function, FunctionDescriptor functionDescriptor, Linker.Option ... options) {
        return LINKER.downcallHandle(LinkerHelper.functionAddress(function), functionDescriptor, options);
    }

    private LinkerHelper() {
    }

    static {
        C_CHAR = (ValueLayout.OfByte)LINKER.canonicalLayouts().get("char");
        C_INT = (ValueLayout.OfInt)LINKER.canonicalLayouts().get("int");
        C_LONG = (ValueLayout.OfLong)LINKER.canonicalLayouts().get("long");
        C_FLOAT = (ValueLayout.OfFloat)LINKER.canonicalLayouts().get("float");
        C_POINTER = ((AddressLayout)LINKER.canonicalLayouts().get("void*")).withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, C_CHAR));
        Path nativeLibrary = LoaderUtils.loadNativeLibrary();
        SYMBOL_LOOKUP = SymbolLookup.libraryLookup(nativeLibrary.toAbsolutePath(), Arena.global());
    }
}

