/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal.common;

import com.nvidia.cuvs.LibraryException;
import com.nvidia.cuvs.internal.common.Util;
import com.nvidia.cuvs.spi.CuVSProvider;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

class LoaderUtils {
    private LoaderUtils() {
    }

    static Path loadNativeLibrary() throws LibraryException {
        String libraryPathFromEnvironment = System.getenv("CUVS_JAVA_SO_PATH");
        if (libraryPathFromEnvironment != null) {
            Path file = Path.of(libraryPathFromEnvironment, new String[0]).toAbsolutePath();
            if (Files.notExists(file, new LinkOption[0])) {
                throw new LibraryException("Environment variable CUVS_JAVA_SO_PATH points to non-existent file: " + libraryPathFromEnvironment);
            }
            if (Files.isDirectory(file, new LinkOption[0])) {
                throw new LibraryException("Environment variable CUVS_JAVA_SO_PATH points to a directory: " + libraryPathFromEnvironment);
            }
            return file;
        }
        return LoaderUtils.loadLibraryFromJar("/META-INF/native/linux_x64/libcuvs_java.so");
    }

    static Path loadLibraryFromJar(String path) throws LibraryException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String filename = path.substring(path.lastIndexOf("/") + 1);
        String[] parts = filename.split("\\.", 2);
        String prefix = parts[0];
        String suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        try {
            Path temp = Files.createTempFile(LoaderUtils.nativeLibraryPath(), prefix, suffix, new FileAttribute[0]);
            temp.toFile().deleteOnExit();
            InputStream libraryStream = Util.class.getModule().getResourceAsStream(path);
            if (libraryStream == null) {
                throw new LibraryException("CuVS Library Not Found in ClassPath");
            }
            LoaderUtils.streamCopy(libraryStream, new FileOutputStream(temp.toFile()));
            return temp;
        }
        catch (IOException ioe) {
            throw new LibraryException(ioe);
        }
    }

    static void streamCopy(InputStream is, OutputStream os) throws IOException {
        Objects.requireNonNull(is);
        try (InputStream in = is;
             OutputStream out = os;){
            in.transferTo(out);
        }
    }

    static Path nativeLibraryPath() {
        Path p = CuVSProvider.provider().nativeLibraryPath().toAbsolutePath();
        if (Files.notExists(p, new LinkOption[0])) {
            throw new LibraryException("non-existent path: " + String.valueOf(p));
        }
        if (!Files.isDirectory(p, new LinkOption[0])) {
            throw new LibraryException("not a directory: " + String.valueOf(p));
        }
        return p;
    }
}

