/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.spi;

import com.nvidia.cuvs.BruteForceIndex;
import com.nvidia.cuvs.CagraIndex;
import com.nvidia.cuvs.CagraMergeParams;
import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.Dataset;
import com.nvidia.cuvs.HnswIndex;
import com.nvidia.cuvs.internal.BruteForceIndexImpl;
import com.nvidia.cuvs.internal.CagraIndexImpl;
import com.nvidia.cuvs.internal.CuVSResourcesImpl;
import com.nvidia.cuvs.internal.DatasetImpl;
import com.nvidia.cuvs.internal.HnswIndexImpl;
import com.nvidia.cuvs.spi.CuVSProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

final class JDKProvider
implements CuVSProvider {
    JDKProvider() {
    }

    @Override
    public CuVSResources newCuVSResources(Path tempDirectory) throws Throwable {
        Objects.requireNonNull(tempDirectory);
        if (Files.notExists(tempDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("does not exist:" + String.valueOf(tempDirectory));
        }
        if (!Files.isDirectory(tempDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("not a directory:" + String.valueOf(tempDirectory));
        }
        return new CuVSResourcesImpl(tempDirectory);
    }

    @Override
    public BruteForceIndex.Builder newBruteForceIndexBuilder(CuVSResources cuVSResources) {
        return BruteForceIndexImpl.newBuilder(Objects.requireNonNull(cuVSResources));
    }

    @Override
    public CagraIndex.Builder newCagraIndexBuilder(CuVSResources cuVSResources) {
        return CagraIndexImpl.newBuilder(Objects.requireNonNull(cuVSResources));
    }

    @Override
    public HnswIndex.Builder newHnswIndexBuilder(CuVSResources cuVSResources) {
        return HnswIndexImpl.newBuilder(Objects.requireNonNull(cuVSResources));
    }

    @Override
    public CagraIndex mergeCagraIndexes(CagraIndex[] indexes) throws Throwable {
        if (indexes == null || indexes.length == 0) {
            throw new IllegalArgumentException("At least one index must be provided for merging");
        }
        return CagraIndexImpl.merge(indexes);
    }

    @Override
    public CagraIndex mergeCagraIndexes(CagraIndex[] indexes, CagraMergeParams mergeParams) throws Throwable {
        if (indexes == null || indexes.length == 0) {
            throw new IllegalArgumentException("At least one index must be provided for merging");
        }
        return CagraIndexImpl.merge(indexes, mergeParams);
    }

    @Override
    public Dataset newDataset(int size, int dimensions) throws UnsupportedOperationException {
        return new DatasetImpl(size, dimensions);
    }
}

