/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class BruteForceQuery {
    private List<Integer> mapping;
    private float[][] queryVectors;
    private BitSet[] prefilters;
    private int numDocs = -1;
    private int topK;

    public BruteForceQuery(float[][] queryVectors, List<Integer> mapping, int topK, BitSet[] prefilters, int numDocs) {
        this.queryVectors = queryVectors;
        this.mapping = mapping;
        this.topK = topK;
        this.prefilters = prefilters;
        this.numDocs = numDocs;
    }

    public float[][] getQueryVectors() {
        return this.queryVectors;
    }

    public List<Integer> getMapping() {
        return this.mapping;
    }

    public int getTopK() {
        return this.topK;
    }

    public BitSet[] getPrefilters() {
        return this.prefilters;
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    public String toString() {
        return "BruteForceQuery [mapping=" + String.valueOf(this.mapping) + ", queryVectors=" + Arrays.toString((Object[])this.queryVectors) + ", prefilter=" + Arrays.toString(this.prefilters) + ", topK=" + this.topK + "]";
    }

    public static class Builder {
        private float[][] queryVectors;
        private BitSet[] prefilters;
        private int numDocs;
        private List<Integer> mapping;
        private int topK = 2;

        public Builder withQueryVectors(float[][] queryVectors) {
            this.queryVectors = queryVectors;
            return this;
        }

        public Builder withMapping(List<Integer> mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder withPrefilters(BitSet[] prefilters, int numDocs) {
            this.prefilters = prefilters;
            this.numDocs = numDocs;
            return this;
        }

        public BruteForceQuery build() {
            return new BruteForceQuery(this.queryVectors, this.mapping, this.topK, this.prefilters, this.numDocs);
        }
    }
}

