/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CuVSResources;

public class CagraCompressionParams {
    private CuVSResources resources;
    private final int pqBits;
    private final int pqDim;
    private final int vqNCenters;
    private final int kmeansNIters;
    private final double vqKmeansTrainsetFraction;
    private final double pqKmeansTrainsetFraction;

    private CagraCompressionParams(CuVSResources resources, int pqBits, int pqDim, int vqNCenters, int kmeansNIters, double vqKmeansTrainsetFraction, double pqKmeansTrainsetFraction) {
        this.resources = resources;
        this.pqBits = pqBits;
        this.pqDim = pqDim;
        this.vqNCenters = vqNCenters;
        this.kmeansNIters = kmeansNIters;
        this.vqKmeansTrainsetFraction = vqKmeansTrainsetFraction;
        this.pqKmeansTrainsetFraction = pqKmeansTrainsetFraction;
    }

    public int getPqBits() {
        return this.pqBits;
    }

    public int getPqDim() {
        return this.pqDim;
    }

    public int getVqNCenters() {
        return this.vqNCenters;
    }

    public int getKmeansNIters() {
        return this.kmeansNIters;
    }

    public double getVqKmeansTrainsetFraction() {
        return this.vqKmeansTrainsetFraction;
    }

    public double getPqKmeansTrainsetFraction() {
        return this.pqKmeansTrainsetFraction;
    }

    public String toString() {
        return "CagraCompressionParams [pqBits=" + this.pqBits + ", pqDim=" + this.pqDim + ", vqNCenters=" + this.vqNCenters + ", kmeansNIters=" + this.kmeansNIters + ", vqKmeansTrainsetFraction=" + this.vqKmeansTrainsetFraction + ", pqKmeansTrainsetFraction=" + this.pqKmeansTrainsetFraction + "]";
    }

    public static class Builder {
        private CuVSResources resources;
        private int pqBits = 8;
        private int pqDim = 0;
        private int vqNCenters = 0;
        private int kmeansNIters = 25;
        private double vqKmeansTrainsetFraction = 0.0;
        private double pqKmeansTrainsetFraction = 0.0;

        public Builder(CuVSResources resources) {
            this.resources = resources;
        }

        public Builder withPqBits(int pqBits) {
            this.pqBits = pqBits;
            return this;
        }

        public Builder withPqDim(int pqDim) {
            this.pqDim = pqDim;
            return this;
        }

        public Builder withVqNCenters(int vqNCenters) {
            this.vqNCenters = vqNCenters;
            return this;
        }

        public Builder withKmeansNIters(int kmeansNIters) {
            this.kmeansNIters = kmeansNIters;
            return this;
        }

        public Builder withVqKmeansTrainsetFraction(double vqKmeansTrainsetFraction) {
            this.vqKmeansTrainsetFraction = vqKmeansTrainsetFraction;
            return this;
        }

        public Builder withPqKmeansTrainsetFraction(double pqKmeansTrainsetFraction) {
            this.pqKmeansTrainsetFraction = pqKmeansTrainsetFraction;
            return this;
        }

        public CagraCompressionParams build() {
            return new CagraCompressionParams(this.resources, this.pqBits, this.pqDim, this.vqNCenters, this.kmeansNIters, this.vqKmeansTrainsetFraction, this.pqKmeansTrainsetFraction);
        }
    }
}

