/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CagraSearchParams;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class CagraQuery {
    private CagraSearchParams cagraSearchParameters;
    private List<Integer> mapping;
    private float[][] queryVectors;
    private int topK;
    private BitSet prefilter;
    private int numDocs;

    public CagraQuery(CagraSearchParams cagraSearchParameters, float[][] queryVectors, List<Integer> mapping, int topK, BitSet prefilter, int numDocs) {
        this.cagraSearchParameters = cagraSearchParameters;
        this.queryVectors = queryVectors;
        this.mapping = mapping;
        this.topK = topK;
        this.prefilter = prefilter;
        this.numDocs = numDocs;
    }

    public CagraSearchParams getCagraSearchParameters() {
        return this.cagraSearchParameters;
    }

    public float[][] getQueryVectors() {
        return this.queryVectors;
    }

    public List<Integer> getMapping() {
        return this.mapping;
    }

    public int getTopK() {
        return this.topK;
    }

    public BitSet getPrefilter() {
        return this.prefilter;
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    public String toString() {
        return "CuVSQuery [cagraSearchParameters=" + String.valueOf(this.cagraSearchParameters) + ", queryVectors=" + Arrays.toString((Object[])this.queryVectors) + ", mapping=" + String.valueOf(this.mapping) + ", topK=" + this.topK + "]";
    }

    public static class Builder {
        private CagraSearchParams cagraSearchParams;
        private float[][] queryVectors;
        private List<Integer> mapping;
        private int topK = 2;
        private BitSet prefilter;
        private int numDocs;

        public Builder withSearchParams(CagraSearchParams cagraSearchParams) {
            this.cagraSearchParams = cagraSearchParams;
            return this;
        }

        public Builder withQueryVectors(float[][] queryVectors) {
            this.queryVectors = queryVectors;
            return this;
        }

        public Builder withMapping(List<Integer> mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder withPrefilter(BitSet prefilter, int numDocs) {
            this.prefilter = prefilter;
            this.numDocs = numDocs;
            return this;
        }

        public CagraQuery build() {
            return new CagraQuery(this.cagraSearchParams, this.queryVectors, this.mapping, this.topK, this.prefilter, this.numDocs);
        }
    }
}

