/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.HnswSearchParams;
import java.util.Arrays;
import java.util.List;

public class HnswQuery {
    private HnswSearchParams hnswSearchParams;
    private List<Integer> mapping;
    private float[][] queryVectors;
    private int topK;

    private HnswQuery(HnswSearchParams hnswSearchParams, float[][] queryVectors, List<Integer> mapping, int topK) {
        this.hnswSearchParams = hnswSearchParams;
        this.queryVectors = queryVectors;
        this.mapping = mapping;
        this.topK = topK;
    }

    public HnswSearchParams getHnswSearchParams() {
        return this.hnswSearchParams;
    }

    public float[][] getQueryVectors() {
        return this.queryVectors;
    }

    public List<Integer> getMapping() {
        return this.mapping;
    }

    public int getTopK() {
        return this.topK;
    }

    public String toString() {
        return "HnswQuery [mapping=" + String.valueOf(this.mapping) + ", queryVectors=" + Arrays.toString((Object[])this.queryVectors) + ", topK=" + this.topK + "]";
    }

    public static class Builder {
        private HnswSearchParams hnswSearchParams;
        private float[][] queryVectors;
        private List<Integer> mapping;
        private int topK = 2;

        public Builder withSearchParams(HnswSearchParams hnswSearchParams) {
            this.hnswSearchParams = hnswSearchParams;
            return this;
        }

        public Builder withQueryVectors(float[][] queryVectors) {
            this.queryVectors = queryVectors;
            return this;
        }

        public Builder withMapping(List<Integer> mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public HnswQuery build() {
            return new HnswQuery(this.hnswSearchParams, this.queryVectors, this.mapping, this.topK);
        }
    }
}

