/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal;

import com.nvidia.cuvs.CagraCompressionParams;
import com.nvidia.cuvs.CagraIndex;
import com.nvidia.cuvs.CagraIndexParams;
import com.nvidia.cuvs.CagraMergeParams;
import com.nvidia.cuvs.CagraQuery;
import com.nvidia.cuvs.CagraSearchParams;
import com.nvidia.cuvs.CuVSIvfPqIndexParams;
import com.nvidia.cuvs.CuVSIvfPqSearchParams;
import com.nvidia.cuvs.CuVSMatrix;
import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.SearchResults;
import com.nvidia.cuvs.internal.CagraSearchResults;
import com.nvidia.cuvs.internal.CuVSMatrixBaseImpl;
import com.nvidia.cuvs.internal.CuVSParamsHelper;
import com.nvidia.cuvs.internal.common.CloseableHandle;
import com.nvidia.cuvs.internal.common.CompositeCloseableHandle;
import com.nvidia.cuvs.internal.common.LinkerHelper;
import com.nvidia.cuvs.internal.common.Util;
import com.nvidia.cuvs.internal.panama.cuvsCagraCompressionParams;
import com.nvidia.cuvs.internal.panama.cuvsCagraIndexParams;
import com.nvidia.cuvs.internal.panama.cuvsCagraMergeParams;
import com.nvidia.cuvs.internal.panama.cuvsCagraSearchParams;
import com.nvidia.cuvs.internal.panama.cuvsFilter;
import com.nvidia.cuvs.internal.panama.cuvsIvfPqIndexParams;
import com.nvidia.cuvs.internal.panama.cuvsIvfPqParams;
import com.nvidia.cuvs.internal.panama.cuvsIvfPqSearchParams;
import com.nvidia.cuvs.internal.panama.headers_h;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.ValueLayout;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class CagraIndexImpl
implements CagraIndex {
    private final CuVSResources resources;
    private final IndexReference cagraIndexReference;
    private boolean destroyed;

    private CagraIndexImpl(CagraIndexParams indexParameters, CuVSMatrix dataset, CuVSResources resources) {
        Objects.requireNonNull(dataset);
        this.resources = resources;
        assert (dataset instanceof CuVSMatrixBaseImpl);
        this.cagraIndexReference = this.build(indexParameters, (CuVSMatrixBaseImpl)dataset);
    }

    private CagraIndexImpl(InputStream inputStream, CuVSResources resources) throws Throwable {
        this.resources = resources;
        this.cagraIndexReference = this.deserialize(inputStream);
    }

    private CagraIndexImpl(IndexReference indexReference, CuVSResources resources) {
        this.resources = resources;
        this.cagraIndexReference = indexReference;
        this.destroyed = false;
    }

    private void checkNotDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("destroyed");
        }
    }

    @Override
    public void destroyIndex() throws Throwable {
        this.checkNotDestroyed();
        try {
            int returnValue = headers_h.cuvsCagraIndexDestroy(this.cagraIndexReference.getMemorySegment());
            Util.checkCuVSError(returnValue, "cuvsCagraIndexDestroy");
            if (this.cagraIndexReference.dataset != null) {
                this.cagraIndexReference.dataset.close();
            }
        }
        finally {
            this.destroyed = true;
        }
    }

    private IndexReference build(CagraIndexParams indexParameters, CuVSMatrixBaseImpl dataset) {
        long rows = dataset.size();
        long cols = dataset.columns();
        try (CloseableHandle indexParams = CagraIndexImpl.segmentFromIndexParams(indexParameters);){
            Arena localArena = Arena.ofConfined();
            try {
                MemorySegment indexParamsMemorySegment = indexParams.handle();
                int numWriterThreads = indexParameters != null ? indexParameters.getNumWriterThreads() : 1;
                headers_h.omp_set_num_threads(numWriterThreads);
                MemorySegment dataSeg = dataset.memorySegment();
                long[] datasetShape = new long[]{rows, cols};
                MemorySegment datasetTensor = Util.prepareTensor(localArena, dataSeg, datasetShape, 2, 32, 2, 1);
                MemorySegment index = CagraIndexImpl.createCagraIndex();
                if (cuvsCagraIndexParams.build_algo(indexParamsMemorySegment) == 1) {
                    MemorySegment cuvsIvfPqIndexParamsMS;
                    int n_lists = cuvsIvfPqIndexParams.n_lists(cuvsIvfPqIndexParamsMS = cuvsIvfPqParams.ivf_pq_build_params(cuvsCagraIndexParams.graph_build_params(indexParamsMemorySegment)));
                    cuvsIvfPqIndexParams.n_lists(cuvsIvfPqIndexParamsMS, (int)(rows < (long)n_lists ? rows : (long)n_lists));
                }
                try (CuVSResources.ScopedAccess resourcesAccessor = this.resources.access();){
                    long cuvsRes = resourcesAccessor.handle();
                    int returnValue = headers_h.cuvsStreamSync(cuvsRes);
                    Util.checkCuVSError(returnValue, "cuvsStreamSync");
                    returnValue = headers_h.cuvsCagraBuild(cuvsRes, indexParamsMemorySegment, datasetTensor, index);
                    Util.checkCuVSError(returnValue, "cuvsCagraBuild");
                    returnValue = headers_h.cuvsStreamSync(cuvsRes);
                    Util.checkCuVSError(returnValue, "cuvsStreamSync");
                }
                headers_h.omp_set_num_threads(1);
                IndexReference indexReference = new IndexReference(index, dataset);
                if (localArena != null) {
                    localArena.close();
                }
                return indexReference;
            }
            catch (Throwable throwable) {
                if (localArena != null) {
                    try {
                        localArena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static MemorySegment createCagraIndex() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment indexPtrPtr = localArena.allocate(headers_h.cuvsCagraIndex_t);
            int returnValue = headers_h.cuvsCagraIndexCreate(indexPtrPtr);
            Util.checkCuVSError(returnValue, "cuvsCagraIndexCreate");
            MemorySegment memorySegment = indexPtrPtr.get(headers_h.cuvsCagraIndex_t, 0L);
            return memorySegment;
        }
    }

    @Override
    public SearchResults search(CagraQuery query) throws Throwable {
        try (Arena localArena = Arena.ofConfined();){
            this.checkNotDestroyed();
            int topK = query.getTopK();
            long numQueries = query.getQueryVectors().length;
            long numBlocks = (long)topK * numQueries;
            int vectorDimension = numQueries > 0L ? query.getQueryVectors()[0].length : 0;
            SequenceLayout neighborsSequenceLayout = MemoryLayout.sequenceLayout(numBlocks, LinkerHelper.C_INT);
            SequenceLayout distancesSequenceLayout = MemoryLayout.sequenceLayout(numBlocks, LinkerHelper.C_FLOAT);
            MemorySegment neighborsMemorySegment = localArena.allocate(neighborsSequenceLayout);
            MemorySegment distancesMemorySegment = localArena.allocate(distancesSequenceLayout);
            MemorySegment floatsSeg = Util.buildMemorySegment(localArena, query.getQueryVectors());
            long queriesBytes = LinkerHelper.C_FLOAT_BYTE_SIZE * numQueries * (long)vectorDimension;
            long neighborsBytes = LinkerHelper.C_INT_BYTE_SIZE * numQueries * (long)topK;
            long distancesBytes = LinkerHelper.C_FLOAT_BYTE_SIZE * numQueries * (long)topK;
            try (CuVSResources.ScopedAccess resourcesAccessor = this.resources.access();){
                long prefilterBytes;
                long cuvsRes = resourcesAccessor.handle();
                MemorySegment queriesDP = Util.allocateRMMSegment(cuvsRes, queriesBytes);
                MemorySegment neighborsDP = Util.allocateRMMSegment(cuvsRes, neighborsBytes);
                MemorySegment distancesDP = Util.allocateRMMSegment(cuvsRes, distancesBytes);
                MemorySegment prefilterDP = MemorySegment.NULL;
                long prefilterLen = 0L;
                Util.cudaMemcpy(queriesDP, floatsSeg, queriesBytes, Util.CudaMemcpyKind.INFER_DIRECTION);
                long[] queriesShape = new long[]{numQueries, vectorDimension};
                MemorySegment queriesTensor = Util.prepareTensor(localArena, queriesDP, queriesShape, 2, 32, 2, 1);
                long[] neighborsShape = new long[]{numQueries, topK};
                MemorySegment neighborsTensor = Util.prepareTensor(localArena, neighborsDP, neighborsShape, 1, 32, 2, 1);
                long[] distancesShape = new long[]{numQueries, topK};
                MemorySegment distancesTensor = Util.prepareTensor(localArena, distancesDP, distancesShape, 2, 32, 2, 1);
                int returnValue = headers_h.cuvsStreamSync(cuvsRes);
                Util.checkCuVSError(returnValue, "cuvsStreamSync");
                long prefilterDataLength = 0L;
                MemorySegment prefilterDataMemorySegment = MemorySegment.NULL;
                if (query.getPrefilter() != null) {
                    BitSet[] prefilters = new BitSet[]{query.getPrefilter()};
                    BitSet concatenatedFilters = Util.concatenate(prefilters, query.getNumDocs());
                    long[] filters = concatenatedFilters.toLongArray();
                    prefilterDataMemorySegment = Util.buildMemorySegment(localArena, filters);
                    prefilterDataLength = query.getNumDocs() * prefilters.length;
                }
                MemorySegment prefilter = cuvsFilter.allocate(localArena);
                if (prefilterDataMemorySegment == MemorySegment.NULL) {
                    cuvsFilter.type(prefilter, 0);
                    cuvsFilter.addr(prefilter, 0L);
                    prefilterBytes = 0L;
                } else {
                    long[] prefilterShape = new long[]{(prefilterDataLength + 31L) / 32L};
                    prefilterLen = prefilterShape[0];
                    prefilterBytes = LinkerHelper.C_INT_BYTE_SIZE * prefilterLen;
                    prefilterDP = Util.allocateRMMSegment(cuvsRes, prefilterBytes);
                    Util.cudaMemcpy(prefilterDP, prefilterDataMemorySegment, prefilterBytes, Util.CudaMemcpyKind.HOST_TO_DEVICE);
                    MemorySegment prefilterTensor = Util.prepareTensor(localArena, prefilterDP, prefilterShape, 1, 32, 2, 1);
                    cuvsFilter.type(prefilter, 1);
                    cuvsFilter.addr(prefilter, prefilterTensor.address());
                }
                returnValue = headers_h.cuvsStreamSync(cuvsRes);
                Util.checkCuVSError(returnValue, "cuvsStreamSync");
                returnValue = headers_h.cuvsCagraSearch(cuvsRes, this.segmentFromSearchParams(localArena, query.getCagraSearchParameters()), this.cagraIndexReference.getMemorySegment(), queriesTensor, neighborsTensor, distancesTensor, prefilter);
                Util.checkCuVSError(returnValue, "cuvsCagraSearch");
                returnValue = headers_h.cuvsStreamSync(cuvsRes);
                Util.checkCuVSError(returnValue, "cuvsStreamSync");
                Util.cudaMemcpy(neighborsMemorySegment, neighborsDP, neighborsBytes, Util.CudaMemcpyKind.INFER_DIRECTION);
                Util.cudaMemcpy(distancesMemorySegment, distancesDP, distancesBytes, Util.CudaMemcpyKind.INFER_DIRECTION);
                returnValue = headers_h.cuvsRMMFree(cuvsRes, distancesDP, distancesBytes);
                Util.checkCuVSError(returnValue, "cuvsRMMFree");
                returnValue = headers_h.cuvsRMMFree(cuvsRes, neighborsDP, neighborsBytes);
                Util.checkCuVSError(returnValue, "cuvsRMMFree");
                returnValue = headers_h.cuvsRMMFree(cuvsRes, queriesDP, queriesBytes);
                Util.checkCuVSError(returnValue, "cuvsRMMFree");
                if (prefilterLen > 0L) {
                    returnValue = headers_h.cuvsRMMFree(cuvsRes, prefilterDP, LinkerHelper.C_INT_BYTE_SIZE * prefilterBytes);
                    Util.checkCuVSError(returnValue, "cuvsRMMFree");
                }
            }
            SearchResults searchResults = CagraSearchResults.create(neighborsSequenceLayout, distancesSequenceLayout, neighborsMemorySegment, distancesMemorySegment, topK, query.getMapping(), numQueries);
            return searchResults;
        }
    }

    @Override
    public void serialize(OutputStream outputStream) throws Throwable {
        Path path = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".cag", new FileAttribute[0]);
        this.serialize(outputStream, path, 1024);
    }

    @Override
    public void serialize(OutputStream outputStream, int bufferLength) throws Throwable {
        Path path = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".cag", new FileAttribute[0]);
        this.serialize(outputStream, path, bufferLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream outputStream, Path tempFile, int bufferLength) throws Throwable {
        this.checkNotDestroyed();
        Path tempFilePath = tempFile.toAbsolutePath();
        try (Arena localArena = Arena.ofConfined();
             CuVSResources.ScopedAccess resourcesAccessor = this.resources.access();){
            long cuvsRes = resourcesAccessor.handle();
            int returnValue = headers_h.cuvsCagraSerialize(cuvsRes, localArena.allocateFrom(tempFilePath.toString()), this.cagraIndexReference.getMemorySegment(), true);
            Util.checkCuVSError(returnValue, "cuvsCagraSerialize");
            try (InputStream fileInputStream = Files.newInputStream(tempFilePath, new OpenOption[0]);){
                byte[] chunk = new byte[bufferLength];
                int chunkLength = 0;
                while ((chunkLength = fileInputStream.read(chunk)) != -1) {
                    outputStream.write(chunk, 0, chunkLength);
                }
            }
            finally {
                Files.deleteIfExists(tempFilePath);
            }
        }
    }

    @Override
    public void serializeToHNSW(OutputStream outputStream) throws Throwable {
        Path path = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".hnsw", new FileAttribute[0]);
        this.serializeToHNSW(outputStream, path, 1024);
    }

    @Override
    public void serializeToHNSW(OutputStream outputStream, int bufferLength) throws Throwable {
        Path path = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".hnsw", new FileAttribute[0]);
        this.serializeToHNSW(outputStream, path, bufferLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeToHNSW(OutputStream outputStream, Path tempFile, int bufferLength) throws Throwable {
        this.checkNotDestroyed();
        Path tempFilePath = tempFile.toAbsolutePath();
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment pathSeg = Util.buildMemorySegment(localArena, tempFile.toString());
            try (CuVSResources.ScopedAccess resourcesAccessor = this.resources.access();){
                Util.checkCuVSError(headers_h.cuvsCagraSerializeToHnswlib(resourcesAccessor.handle(), pathSeg, this.cagraIndexReference.getMemorySegment()), "cuvsCagraSerializeToHnswlib");
            }
        }
        try (FileInputStream fileInputStream = new FileInputStream(tempFilePath.toFile());){
            int chunkLength;
            byte[] chunk = new byte[bufferLength];
            while ((chunkLength = fileInputStream.read(chunk)) != -1) {
                outputStream.write(chunk, 0, chunkLength);
            }
        }
        finally {
            Files.deleteIfExists(tempFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReference deserialize(InputStream inputStream) throws Throwable {
        Path tmpIndexFile = Files.createTempFile(this.resources.tempDirectory(), UUID.randomUUID().toString(), ".cag", new FileAttribute[0]).toAbsolutePath();
        MemorySegment index = CagraIndexImpl.createCagraIndex();
        try (InputStream inputStream2 = inputStream;
             OutputStream outputStream = Files.newOutputStream(tmpIndexFile, new OpenOption[0]);
             Arena arena = Arena.ofConfined();){
            inputStream.transferTo(outputStream);
            try (CuVSResources.ScopedAccess resourcesAccessor = this.resources.access();){
                long cuvsRes = resourcesAccessor.handle();
                int returnValue = headers_h.cuvsCagraDeserialize(cuvsRes, arena.allocateFrom(tmpIndexFile.toString()), index);
                Util.checkCuVSError(returnValue, "cuvsCagraDeserialize");
            }
        }
        finally {
            Files.deleteIfExists(tmpIndexFile);
        }
        return new IndexReference(index, null);
    }

    @Override
    public CuVSResources getCuVSResources() {
        return this.resources;
    }

    private static CloseableHandle segmentFromIndexParams(CagraIndexParams params) {
        if (params == null) {
            return CloseableHandle.NULL;
        }
        ArrayList<CloseableHandle> handles = new ArrayList<CloseableHandle>();
        CloseableHandle indexParams = CuVSParamsHelper.createCagraIndexParams();
        handles.add(indexParams);
        MemorySegment indexPtr = indexParams.handle();
        CagraIndexImpl.populateNativeIndexParams(indexPtr, params, handles);
        return new CompositeCloseableHandle(indexPtr, handles);
    }

    private static void populateNativeIndexParams(MemorySegment indexPtr, CagraIndexParams params, List<CloseableHandle> handles) {
        cuvsCagraIndexParams.intermediate_graph_degree(indexPtr, params.getIntermediateGraphDegree());
        cuvsCagraIndexParams.graph_degree(indexPtr, params.getGraphDegree());
        cuvsCagraIndexParams.build_algo(indexPtr, params.getCagraGraphBuildAlgo().value);
        cuvsCagraIndexParams.nn_descent_niter(indexPtr, params.getNNDescentNumIterations());
        cuvsCagraIndexParams.metric(indexPtr, params.getCuvsDistanceType().value);
        CagraCompressionParams cagraCompressionParams = params.getCagraCompressionParams();
        if (cagraCompressionParams != null) {
            CloseableHandle compressionParams = CuVSParamsHelper.createCagraCompressionParams();
            handles.add(compressionParams);
            MemorySegment cuvsCagraCompressionParamsMemorySegment = compressionParams.handle();
            cuvsCagraCompressionParams.pq_bits(cuvsCagraCompressionParamsMemorySegment, cagraCompressionParams.getPqBits());
            cuvsCagraCompressionParams.pq_dim(cuvsCagraCompressionParamsMemorySegment, cagraCompressionParams.getPqDim());
            cuvsCagraCompressionParams.vq_n_centers(cuvsCagraCompressionParamsMemorySegment, cagraCompressionParams.getVqNCenters());
            cuvsCagraCompressionParams.kmeans_n_iters(cuvsCagraCompressionParamsMemorySegment, cagraCompressionParams.getKmeansNIters());
            cuvsCagraCompressionParams.vq_kmeans_trainset_fraction(cuvsCagraCompressionParamsMemorySegment, cagraCompressionParams.getVqKmeansTrainsetFraction());
            cuvsCagraCompressionParams.pq_kmeans_trainset_fraction(cuvsCagraCompressionParamsMemorySegment, cagraCompressionParams.getPqKmeansTrainsetFraction());
            cuvsCagraIndexParams.compression(indexPtr, cuvsCagraCompressionParamsMemorySegment);
        }
        if (params.getCagraGraphBuildAlgo().equals((Object)CagraIndexParams.CagraGraphBuildAlgo.IVF_PQ)) {
            CloseableHandle ivfPqIndexParams = CuVSParamsHelper.createIvfPqIndexParams();
            handles.add(ivfPqIndexParams);
            MemorySegment ivfpqIndexParamsMemorySegment = ivfPqIndexParams.handle();
            CuVSIvfPqIndexParams cuVSIvfPqIndexParams = params.getCuVSIvfPqParams().getIndexParams();
            cuvsIvfPqIndexParams.metric(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.getMetric().value);
            cuvsIvfPqIndexParams.metric_arg(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.getMetricArg());
            cuvsIvfPqIndexParams.add_data_on_build(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.isAddDataOnBuild());
            cuvsIvfPqIndexParams.n_lists(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.getnLists());
            cuvsIvfPqIndexParams.kmeans_n_iters(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.getKmeansNIters());
            cuvsIvfPqIndexParams.kmeans_trainset_fraction(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.getKmeansTrainsetFraction());
            cuvsIvfPqIndexParams.pq_bits(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.getPqBits());
            cuvsIvfPqIndexParams.pq_dim(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.getPqDim());
            cuvsIvfPqIndexParams.codebook_kind(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.getCodebookKind().value);
            cuvsIvfPqIndexParams.force_random_rotation(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.isForceRandomRotation());
            cuvsIvfPqIndexParams.conservative_memory_allocation(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.isConservativeMemoryAllocation());
            cuvsIvfPqIndexParams.max_train_points_per_pq_code(ivfpqIndexParamsMemorySegment, cuVSIvfPqIndexParams.getMaxTrainPointsPerPqCode());
            CloseableHandle ivfPqSearchParams = CuVSParamsHelper.createIvfPqSearchParams();
            handles.add(ivfPqSearchParams);
            MemorySegment ivfpqSearchParamsMemorySegment = ivfPqSearchParams.handle();
            CuVSIvfPqSearchParams cuVSIvfPqSearchParams = params.getCuVSIvfPqParams().getSearchParams();
            cuvsIvfPqSearchParams.n_probes(ivfpqSearchParamsMemorySegment, cuVSIvfPqSearchParams.getnProbes());
            cuvsIvfPqSearchParams.lut_dtype(ivfpqSearchParamsMemorySegment, cuVSIvfPqSearchParams.getLutDtype().value);
            cuvsIvfPqSearchParams.internal_distance_dtype(ivfpqSearchParamsMemorySegment, cuVSIvfPqSearchParams.getInternalDistanceDtype().value);
            cuvsIvfPqSearchParams.preferred_shmem_carveout(ivfpqSearchParamsMemorySegment, cuVSIvfPqSearchParams.getPreferredShmemCarveout());
            MemorySegment cuvsIvfPqParamsMemorySegment = cuvsCagraIndexParams.graph_build_params(indexPtr);
            cuvsIvfPqParams.ivf_pq_build_params(cuvsIvfPqParamsMemorySegment, ivfpqIndexParamsMemorySegment);
            cuvsIvfPqParams.ivf_pq_search_params(cuvsIvfPqParamsMemorySegment, ivfpqSearchParamsMemorySegment);
            cuvsIvfPqParams.refinement_rate(cuvsIvfPqParamsMemorySegment, params.getCuVSIvfPqParams().getRefinementRate());
            cuvsCagraIndexParams.graph_build_params(indexPtr, cuvsIvfPqParamsMemorySegment);
        }
    }

    private MemorySegment segmentFromSearchParams(Arena arena, CagraSearchParams params) {
        MemorySegment seg = cuvsCagraSearchParams.allocate(arena);
        cuvsCagraSearchParams.max_queries(seg, params.getMaxQueries());
        cuvsCagraSearchParams.itopk_size(seg, params.getITopKSize());
        cuvsCagraSearchParams.max_iterations(seg, params.getMaxIterations());
        if (params.getCagraSearchAlgo() != null) {
            cuvsCagraSearchParams.algo(seg, params.getCagraSearchAlgo().value);
        }
        cuvsCagraSearchParams.team_size(seg, params.getTeamSize());
        cuvsCagraSearchParams.search_width(seg, params.getSearchWidth());
        cuvsCagraSearchParams.min_iterations(seg, params.getMinIterations());
        cuvsCagraSearchParams.thread_block_size(seg, params.getThreadBlockSize());
        if (params.getHashMapMode() != null) {
            cuvsCagraSearchParams.hashmap_mode(seg, params.getHashMapMode().value);
        }
        cuvsCagraSearchParams.hashmap_max_fill_rate(seg, params.getHashMapMaxFillRate());
        cuvsCagraSearchParams.num_random_samplings(seg, params.getNumRandomSamplings());
        cuvsCagraSearchParams.rand_xor_mask(seg, params.getRandXORMask());
        return seg;
    }

    public static CagraIndex.Builder newBuilder(CuVSResources cuvsResources) {
        return new Builder(Objects.requireNonNull(cuvsResources));
    }

    public static CagraIndex merge(CagraIndex[] indexes) {
        return CagraIndexImpl.merge(indexes, null);
    }

    public static CagraIndex merge(CagraIndex[] indexes, CagraMergeParams mergeParams) {
        CuVSResources resources = indexes[0].getCuVSResources();
        MemorySegment mergedIndex = CagraIndexImpl.createCagraIndex();
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment indexesSegment = localArena.allocate((long)indexes.length * ValueLayout.ADDRESS.byteSize());
            for (int i = 0; i < indexes.length; ++i) {
                CagraIndexImpl indexImpl = (CagraIndexImpl)indexes[i];
                indexesSegment.setAtIndex(ValueLayout.ADDRESS, (long)i, indexImpl.cagraIndexReference.getMemorySegment());
            }
            try (CloseableHandle nativeMergeParams = CagraIndexImpl.createMergeParamsSegment(mergeParams);
                 CuVSResources.ScopedAccess resourcesAccessor = resources.access();){
                long cuvsRes = resourcesAccessor.handle();
                Util.checkCuVSError(headers_h.cuvsCagraMerge(cuvsRes, nativeMergeParams.handle(), indexesSegment, indexes.length, mergedIndex), "cuvsCagraMerge");
            }
        }
        return new CagraIndexImpl(new IndexReference(mergedIndex, null), resources);
    }

    private static CloseableHandle createMergeParamsSegment(CagraMergeParams mergeParams) {
        ArrayList<CloseableHandle> handles = new ArrayList<CloseableHandle>();
        CloseableHandle nativeMergeParams = CuVSParamsHelper.createCagraMergeParams();
        handles.add(nativeMergeParams);
        MemorySegment seg = nativeMergeParams.handle();
        MemorySegment outputIndexParamsPtr = cuvsCagraMergeParams.output_index_params(seg);
        if (mergeParams != null) {
            CagraIndexImpl.populateNativeIndexParams(outputIndexParamsPtr, mergeParams.getOutputIndexParams(), handles);
            cuvsCagraMergeParams.strategy(seg, mergeParams.getStrategy().value);
        } else {
            CagraIndexImpl.populateNativeIndexParams(outputIndexParamsPtr, new CagraIndexParams.Builder().build(), handles);
        }
        return new CompositeCloseableHandle(seg, handles);
    }

    public static class IndexReference {
        private final MemorySegment memorySegment;
        private final CuVSMatrix dataset;

        private IndexReference(MemorySegment indexMemorySegment, CuVSMatrix dataset) {
            this.memorySegment = indexMemorySegment;
            this.dataset = dataset;
        }

        protected MemorySegment getMemorySegment() {
            return this.memorySegment;
        }
    }

    public static class Builder
    implements CagraIndex.Builder {
        private CuVSMatrix dataset;
        private CagraIndexParams cagraIndexParams;
        private final CuVSResources cuvsResources;
        private InputStream inputStream;

        public Builder(CuVSResources cuvsResources) {
            this.cuvsResources = cuvsResources;
        }

        @Override
        public Builder from(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        @Override
        public Builder withDataset(float[][] vectors) {
            this.dataset = CuVSMatrix.ofArray(vectors);
            return this;
        }

        @Override
        public Builder withDataset(CuVSMatrix dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public Builder withIndexParams(CagraIndexParams cagraIndexParameters) {
            this.cagraIndexParams = cagraIndexParameters;
            return this;
        }

        @Override
        public CagraIndexImpl build() throws Throwable {
            if (this.inputStream != null) {
                return new CagraIndexImpl(this.inputStream, this.cuvsResources);
            }
            return new CagraIndexImpl(this.cagraIndexParams, this.dataset, this.cuvsResources);
        }
    }
}

