/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.spi;

import com.nvidia.cuvs.BruteForceIndex;
import com.nvidia.cuvs.CagraIndex;
import com.nvidia.cuvs.CagraMergeParams;
import com.nvidia.cuvs.CuVSMatrix;
import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.HnswIndex;
import com.nvidia.cuvs.TieredIndex;
import com.nvidia.cuvs.internal.BruteForceIndexImpl;
import com.nvidia.cuvs.internal.CagraIndexImpl;
import com.nvidia.cuvs.internal.CuVSHostMatrixArenaImpl;
import com.nvidia.cuvs.internal.CuVSHostMatrixImpl;
import com.nvidia.cuvs.internal.CuVSResourcesImpl;
import com.nvidia.cuvs.internal.HnswIndexImpl;
import com.nvidia.cuvs.internal.TieredIndexImpl;
import com.nvidia.cuvs.internal.common.Util;
import com.nvidia.cuvs.spi.CuVSProvider;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

final class JDKProvider
implements CuVSProvider {
    private static final MethodHandle createNativeDataset$mh = JDKProvider.createNativeDatasetBuilder();

    JDKProvider() {
    }

    static MethodHandle createNativeDatasetBuilder() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType mt = MethodType.methodType(CuVSMatrix.class, MemorySegment.class, Integer.TYPE, Integer.TYPE, CuVSMatrix.DataType.class);
            return lookup.findStatic(JDKProvider.class, "createNativeDataset", mt);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static CuVSMatrix createNativeDataset(MemorySegment memorySegment, int size, int dimensions, CuVSMatrix.DataType dataType) {
        return new CuVSHostMatrixImpl(memorySegment, size, (long)dimensions, dataType);
    }

    @Override
    public CuVSResources newCuVSResources(Path tempDirectory) {
        Objects.requireNonNull(tempDirectory);
        if (Files.notExists(tempDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("does not exist:" + String.valueOf(tempDirectory));
        }
        if (!Files.isDirectory(tempDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("not a directory:" + String.valueOf(tempDirectory));
        }
        return new CuVSResourcesImpl(tempDirectory);
    }

    @Override
    public BruteForceIndex.Builder newBruteForceIndexBuilder(CuVSResources cuVSResources) {
        return BruteForceIndexImpl.newBuilder(Objects.requireNonNull(cuVSResources));
    }

    @Override
    public CagraIndex.Builder newCagraIndexBuilder(CuVSResources cuVSResources) {
        return CagraIndexImpl.newBuilder(Objects.requireNonNull(cuVSResources));
    }

    @Override
    public HnswIndex.Builder newHnswIndexBuilder(CuVSResources cuVSResources) {
        return HnswIndexImpl.newBuilder(Objects.requireNonNull(cuVSResources));
    }

    @Override
    public TieredIndex.Builder newTieredIndexBuilder(CuVSResources cuVSResources) {
        return TieredIndexImpl.newBuilder(Objects.requireNonNull(cuVSResources));
    }

    @Override
    public CagraIndex mergeCagraIndexes(CagraIndex[] indexes) throws Throwable {
        if (indexes == null || indexes.length == 0) {
            throw new IllegalArgumentException("At least one index must be provided for merging");
        }
        return CagraIndexImpl.merge(indexes);
    }

    @Override
    public CagraIndex mergeCagraIndexes(CagraIndex[] indexes, CagraMergeParams mergeParams) throws Throwable {
        if (indexes == null || indexes.length == 0) {
            throw new IllegalArgumentException("At least one index must be provided for merging");
        }
        return CagraIndexImpl.merge(indexes, mergeParams);
    }

    @Override
    public CuVSMatrix.Builder newMatrixBuilder(final int size, final int dimensions, CuVSMatrix.DataType dataType) throws UnsupportedOperationException {
        final CuVSHostMatrixArenaImpl dataset = new CuVSHostMatrixArenaImpl(size, dimensions, dataType);
        return new CuVSMatrix.Builder(){
            int current = 0;

            @Override
            public void addVector(float[] vector) {
                this.internalAddVector(vector);
            }

            @Override
            public void addVector(byte[] vector) {
                this.internalAddVector(vector);
            }

            @Override
            public void addVector(int[] vector) {
                this.internalAddVector(vector);
            }

            private void internalAddVector(Object vector) {
                if (this.current >= size) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                MemorySegment.copy(vector, 0, dataset.memorySegment(), dataset.valueLayout(), (long)(this.current++ * dimensions) * dataset.valueLayout().byteSize(), dimensions);
            }

            @Override
            public CuVSMatrix build() {
                return dataset;
            }
        };
    }

    @Override
    public MethodHandle newNativeMatrixBuilder() {
        return createNativeDataset$mh;
    }

    @Override
    public CuVSMatrix newMatrixFromArray(float[][] vectors) {
        Objects.requireNonNull(vectors);
        if (vectors.length == 0) {
            throw new IllegalArgumentException("vectors should not be empty");
        }
        int size = vectors.length;
        int columns = vectors[0].length;
        CuVSHostMatrixArenaImpl dataset = new CuVSHostMatrixArenaImpl(size, columns, CuVSMatrix.DataType.FLOAT);
        Util.copy(dataset.memorySegment(), vectors);
        return dataset;
    }

    @Override
    public CuVSMatrix newMatrixFromArray(int[][] vectors) {
        Objects.requireNonNull(vectors);
        if (vectors.length == 0) {
            throw new IllegalArgumentException("vectors should not be empty");
        }
        int size = vectors.length;
        int columns = vectors[0].length;
        CuVSHostMatrixArenaImpl dataset = new CuVSHostMatrixArenaImpl(size, columns, CuVSMatrix.DataType.INT);
        Util.copy(dataset.memorySegment(), vectors);
        return dataset;
    }

    @Override
    public CuVSMatrix newMatrixFromArray(byte[][] vectors) {
        Objects.requireNonNull(vectors);
        if (vectors.length == 0) {
            throw new IllegalArgumentException("vectors should not be empty");
        }
        int size = vectors.length;
        int columns = vectors[0].length;
        CuVSHostMatrixArenaImpl dataset = new CuVSHostMatrixArenaImpl(size, columns, CuVSMatrix.DataType.BYTE);
        Util.copy(dataset.memorySegment(), vectors);
        return dataset;
    }
}

