/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CagraIndexParams;
import com.nvidia.cuvs.CagraMergeParams;
import com.nvidia.cuvs.CagraQuery;
import com.nvidia.cuvs.CuVSMatrix;
import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.SearchResults;
import com.nvidia.cuvs.spi.CuVSProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;

public interface CagraIndex {
    public void destroyIndex() throws Throwable;

    public SearchResults search(CagraQuery var1) throws Throwable;

    public void serialize(OutputStream var1) throws Throwable;

    public void serialize(OutputStream var1, int var2) throws Throwable;

    default public void serialize(OutputStream outputStream, Path tempFile) throws Throwable {
        this.serialize(outputStream, tempFile, 1024);
    }

    public void serialize(OutputStream var1, Path var2, int var3) throws Throwable;

    public void serializeToHNSW(OutputStream var1) throws Throwable;

    public void serializeToHNSW(OutputStream var1, int var2) throws Throwable;

    default public void serializeToHNSW(OutputStream outputStream, Path tempFile) throws Throwable {
        this.serializeToHNSW(outputStream, tempFile, 1024);
    }

    public void serializeToHNSW(OutputStream var1, Path var2, int var3) throws Throwable;

    public CuVSResources getCuVSResources();

    public static Builder newBuilder(CuVSResources cuvsResources) {
        Objects.requireNonNull(cuvsResources);
        return CuVSProvider.provider().newCagraIndexBuilder(cuvsResources);
    }

    public static CagraIndex merge(CagraIndex[] indexes) throws Throwable {
        return CagraIndex.merge(indexes, null);
    }

    public static CagraIndex merge(CagraIndex[] indexes, CagraMergeParams mergeParams) throws Throwable {
        if (indexes == null || indexes.length == 0) {
            throw new IllegalArgumentException("At least one index must be provided for merging");
        }
        CuVSResources resources = indexes[0].getCuVSResources();
        for (int i = 1; i < indexes.length; ++i) {
            if (resources.equals(indexes[i].getCuVSResources())) continue;
            throw new IllegalArgumentException("All indexes must use the same CuVSResources instance");
        }
        return CuVSProvider.provider().mergeCagraIndexes(indexes, mergeParams);
    }

    public static interface Builder {
        public Builder from(InputStream var1);

        public Builder withDataset(float[][] var1);

        public Builder withDataset(CuVSMatrix var1);

        public Builder withIndexParams(CagraIndexParams var1);

        public CagraIndex build() throws Throwable;
    }
}

