/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.RowView;
import com.nvidia.cuvs.spi.CuVSProvider;

public interface CuVSMatrix
extends AutoCloseable {
    public static CuVSMatrix ofArray(float[][] vectors) {
        return CuVSProvider.provider().newMatrixFromArray(vectors);
    }

    public static CuVSMatrix ofArray(int[][] vectors) {
        return CuVSProvider.provider().newMatrixFromArray(vectors);
    }

    public static CuVSMatrix ofArray(byte[][] vectors) {
        return CuVSProvider.provider().newMatrixFromArray(vectors);
    }

    public static Builder builder(int size, int columns, DataType dataType) {
        return CuVSProvider.provider().newMatrixBuilder(size, columns, dataType);
    }

    public long size();

    public long columns();

    public RowView getRow(long var1);

    public void toArray(int[][] var1);

    public void toArray(float[][] var1);

    public void toArray(byte[][] var1);

    @Override
    public void close();

    public static enum DataType {
        FLOAT,
        INT,
        BYTE;

    }

    public static interface Builder {
        public void addVector(float[] var1);

        public void addVector(byte[] var1);

        public void addVector(int[] var1);

        public CuVSMatrix build();
    }

    public static enum MemoryKind {
        HOST,
        DEVICE;

    }
}

