/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.HnswSearchParams;
import com.nvidia.cuvs.SearchResults;
import java.util.Arrays;
import java.util.function.LongToIntFunction;

public class HnswQuery {
    private final HnswSearchParams hnswSearchParams;
    private final LongToIntFunction mapping;
    private final float[][] queryVectors;
    private final int topK;

    private HnswQuery(HnswSearchParams hnswSearchParams, float[][] queryVectors, LongToIntFunction mapping, int topK) {
        this.hnswSearchParams = hnswSearchParams;
        this.queryVectors = queryVectors;
        this.mapping = mapping;
        this.topK = topK;
    }

    public HnswSearchParams getHnswSearchParams() {
        return this.hnswSearchParams;
    }

    public float[][] getQueryVectors() {
        return this.queryVectors;
    }

    public LongToIntFunction getMapping() {
        return this.mapping;
    }

    public int getTopK() {
        return this.topK;
    }

    public String toString() {
        return "HnswQuery [mapping=" + String.valueOf(this.mapping) + ", queryVectors=" + Arrays.toString((Object[])this.queryVectors) + ", topK=" + this.topK + "]";
    }

    public static class Builder {
        private HnswSearchParams hnswSearchParams;
        private float[][] queryVectors;
        private LongToIntFunction mapping = SearchResults.IDENTITY_MAPPING;
        private int topK = 2;

        public Builder withSearchParams(HnswSearchParams hnswSearchParams) {
            this.hnswSearchParams = hnswSearchParams;
            return this;
        }

        public Builder withQueryVectors(float[][] queryVectors) {
            this.queryVectors = queryVectors;
            return this;
        }

        public Builder withMapping(LongToIntFunction mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public HnswQuery build() {
            return new HnswQuery(this.hnswSearchParams, this.queryVectors, this.mapping, this.topK);
        }
    }
}

