/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CuVSMatrix;
import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.SearchResults;
import com.nvidia.cuvs.TieredIndexParams;
import com.nvidia.cuvs.TieredIndexQuery;
import com.nvidia.cuvs.spi.CuVSProvider;
import java.io.InputStream;
import java.util.Objects;

public interface TieredIndex {
    public void destroyIndex() throws Throwable;

    public SearchResults search(TieredIndexQuery var1) throws Throwable;

    public TieredIndexType getIndexType();

    public CuVSResources getCuVSResources();

    public static Builder newBuilder(CuVSResources cuvsResources) {
        Objects.requireNonNull(cuvsResources);
        return CuVSProvider.provider().newTieredIndexBuilder(cuvsResources);
    }

    public ExtendBuilder extend();

    public static interface Builder {
        public Builder from(InputStream var1);

        public Builder withDataset(float[][] var1);

        public Builder withDataset(CuVSMatrix var1);

        public Builder withIndexParams(TieredIndexParams var1);

        public Builder withIndexType(TieredIndexType var1);

        public TieredIndex build() throws Throwable;
    }

    public static interface ExtendBuilder {
        public ExtendBuilder withDataset(float[][] var1);

        public ExtendBuilder withDataset(CuVSMatrix var1);

        public void execute() throws Throwable;
    }

    public static enum TieredIndexType {
        CAGRA;

    }
}

